/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.RRA_O18_TREATMENT;
import ca.uhn.hl7v2.model.v27.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RRA_O18_ADMINISTRATION
extends AbstractGroup {
    public RRA_O18_ADMINISTRATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RRA_O18_TREATMENT.class, true, true, false);
            this.add(RXR.class, true, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RRA_O18_ADMINISTRATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public RRA_O18_TREATMENT getTREATMENT() {
        RRA_O18_TREATMENT retVal = (RRA_O18_TREATMENT)this.getTyped("TREATMENT", RRA_O18_TREATMENT.class);
        return retVal;
    }

    public RRA_O18_TREATMENT getTREATMENT(int rep) {
        RRA_O18_TREATMENT retVal = (RRA_O18_TREATMENT)this.getTyped("TREATMENT", rep, RRA_O18_TREATMENT.class);
        return retVal;
    }

    public int getTREATMENTReps() {
        return this.getReps("TREATMENT");
    }

    public List<RRA_O18_TREATMENT> getTREATMENTAll() throws HL7Exception {
        return this.getAllAsList("TREATMENT", RRA_O18_TREATMENT.class);
    }

    public void insertTREATMENT(RRA_O18_TREATMENT structure, int rep) throws HL7Exception {
        super.insertRepetition("TREATMENT", (Structure)structure, rep);
    }

    public RRA_O18_TREATMENT insertTREATMENT(int rep) throws HL7Exception {
        return (RRA_O18_TREATMENT)super.insertRepetition("TREATMENT", rep);
    }

    public RRA_O18_TREATMENT removeTREATMENT(int rep) throws HL7Exception {
        return (RRA_O18_TREATMENT)super.removeRepetition("TREATMENT", rep);
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }
}

