/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.CQU_I19_APPOINTMENT_HISTORY;
import ca.uhn.hl7v2.model.v27.group.CQU_I19_CLINICAL_HISTORY;
import ca.uhn.hl7v2.model.v27.group.CQU_I19_GOAL;
import ca.uhn.hl7v2.model.v27.group.CQU_I19_INSURANCE;
import ca.uhn.hl7v2.model.v27.group.CQU_I19_MEDICATION_HISTORY;
import ca.uhn.hl7v2.model.v27.group.CQU_I19_PATHWAY;
import ca.uhn.hl7v2.model.v27.group.CQU_I19_PATIENT;
import ca.uhn.hl7v2.model.v27.group.CQU_I19_PATIENT_VISITS;
import ca.uhn.hl7v2.model.v27.group.CQU_I19_PROBLEM;
import ca.uhn.hl7v2.model.v27.group.CQU_I19_PROVIDER_CONTACT;
import ca.uhn.hl7v2.model.v27.segment.ERR;
import ca.uhn.hl7v2.model.v27.segment.MSA;
import ca.uhn.hl7v2.model.v27.segment.MSH;
import ca.uhn.hl7v2.model.v27.segment.NK1;
import ca.uhn.hl7v2.model.v27.segment.REL;
import ca.uhn.hl7v2.model.v27.segment.RF1;
import ca.uhn.hl7v2.model.v27.segment.SFT;
import ca.uhn.hl7v2.model.v27.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CQU_I19
extends AbstractMessage {
    public CQU_I19() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public CQU_I19(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(RF1.class, true, false);
            this.add(CQU_I19_PROVIDER_CONTACT.class, false, true);
            this.add(CQU_I19_PATIENT.class, false, true);
            this.add(NK1.class, false, true);
            this.add(CQU_I19_INSURANCE.class, false, true);
            this.add(CQU_I19_APPOINTMENT_HISTORY.class, false, true);
            this.add(CQU_I19_CLINICAL_HISTORY.class, false, true);
            this.add(CQU_I19_PATIENT_VISITS.class, true, true);
            this.add(CQU_I19_MEDICATION_HISTORY.class, false, true);
            this.add(CQU_I19_PROBLEM.class, false, true);
            this.add(CQU_I19_GOAL.class, false, true);
            this.add(CQU_I19_PATHWAY.class, false, true);
            this.add(REL.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CQU_I19 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return (ERR)this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", (Structure)structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public RF1 getRF1() {
        return (RF1)this.getTyped("RF1", RF1.class);
    }

    public CQU_I19_PROVIDER_CONTACT getPROVIDER_CONTACT() {
        return (CQU_I19_PROVIDER_CONTACT)this.getTyped("PROVIDER_CONTACT", CQU_I19_PROVIDER_CONTACT.class);
    }

    public CQU_I19_PROVIDER_CONTACT getPROVIDER_CONTACT(int rep) {
        return (CQU_I19_PROVIDER_CONTACT)this.getTyped("PROVIDER_CONTACT", rep, CQU_I19_PROVIDER_CONTACT.class);
    }

    public int getPROVIDER_CONTACTReps() {
        return this.getReps("PROVIDER_CONTACT");
    }

    public List<CQU_I19_PROVIDER_CONTACT> getPROVIDER_CONTACTAll() throws HL7Exception {
        return this.getAllAsList("PROVIDER_CONTACT", CQU_I19_PROVIDER_CONTACT.class);
    }

    public void insertPROVIDER_CONTACT(CQU_I19_PROVIDER_CONTACT structure, int rep) throws HL7Exception {
        super.insertRepetition("PROVIDER_CONTACT", (Structure)structure, rep);
    }

    public CQU_I19_PROVIDER_CONTACT insertPROVIDER_CONTACT(int rep) throws HL7Exception {
        return (CQU_I19_PROVIDER_CONTACT)super.insertRepetition("PROVIDER_CONTACT", rep);
    }

    public CQU_I19_PROVIDER_CONTACT removePROVIDER_CONTACT(int rep) throws HL7Exception {
        return (CQU_I19_PROVIDER_CONTACT)super.removeRepetition("PROVIDER_CONTACT", rep);
    }

    public CQU_I19_PATIENT getPATIENT() {
        return (CQU_I19_PATIENT)this.getTyped("PATIENT", CQU_I19_PATIENT.class);
    }

    public CQU_I19_PATIENT getPATIENT(int rep) {
        return (CQU_I19_PATIENT)this.getTyped("PATIENT", rep, CQU_I19_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<CQU_I19_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", CQU_I19_PATIENT.class);
    }

    public void insertPATIENT(CQU_I19_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", (Structure)structure, rep);
    }

    public CQU_I19_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (CQU_I19_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public CQU_I19_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (CQU_I19_PATIENT)super.removeRepetition("PATIENT", rep);
    }

    public NK1 getNK1() {
        return (NK1)this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return (NK1)this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public CQU_I19_INSURANCE getINSURANCE() {
        return (CQU_I19_INSURANCE)this.getTyped("INSURANCE", CQU_I19_INSURANCE.class);
    }

    public CQU_I19_INSURANCE getINSURANCE(int rep) {
        return (CQU_I19_INSURANCE)this.getTyped("INSURANCE", rep, CQU_I19_INSURANCE.class);
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<CQU_I19_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", CQU_I19_INSURANCE.class);
    }

    public void insertINSURANCE(CQU_I19_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public CQU_I19_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (CQU_I19_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public CQU_I19_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (CQU_I19_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public CQU_I19_APPOINTMENT_HISTORY getAPPOINTMENT_HISTORY() {
        return (CQU_I19_APPOINTMENT_HISTORY)this.getTyped("APPOINTMENT_HISTORY", CQU_I19_APPOINTMENT_HISTORY.class);
    }

    public CQU_I19_APPOINTMENT_HISTORY getAPPOINTMENT_HISTORY(int rep) {
        return (CQU_I19_APPOINTMENT_HISTORY)this.getTyped("APPOINTMENT_HISTORY", rep, CQU_I19_APPOINTMENT_HISTORY.class);
    }

    public int getAPPOINTMENT_HISTORYReps() {
        return this.getReps("APPOINTMENT_HISTORY");
    }

    public List<CQU_I19_APPOINTMENT_HISTORY> getAPPOINTMENT_HISTORYAll() throws HL7Exception {
        return this.getAllAsList("APPOINTMENT_HISTORY", CQU_I19_APPOINTMENT_HISTORY.class);
    }

    public void insertAPPOINTMENT_HISTORY(CQU_I19_APPOINTMENT_HISTORY structure, int rep) throws HL7Exception {
        super.insertRepetition("APPOINTMENT_HISTORY", (Structure)structure, rep);
    }

    public CQU_I19_APPOINTMENT_HISTORY insertAPPOINTMENT_HISTORY(int rep) throws HL7Exception {
        return (CQU_I19_APPOINTMENT_HISTORY)super.insertRepetition("APPOINTMENT_HISTORY", rep);
    }

    public CQU_I19_APPOINTMENT_HISTORY removeAPPOINTMENT_HISTORY(int rep) throws HL7Exception {
        return (CQU_I19_APPOINTMENT_HISTORY)super.removeRepetition("APPOINTMENT_HISTORY", rep);
    }

    public CQU_I19_CLINICAL_HISTORY getCLINICAL_HISTORY() {
        return (CQU_I19_CLINICAL_HISTORY)this.getTyped("CLINICAL_HISTORY", CQU_I19_CLINICAL_HISTORY.class);
    }

    public CQU_I19_CLINICAL_HISTORY getCLINICAL_HISTORY(int rep) {
        return (CQU_I19_CLINICAL_HISTORY)this.getTyped("CLINICAL_HISTORY", rep, CQU_I19_CLINICAL_HISTORY.class);
    }

    public int getCLINICAL_HISTORYReps() {
        return this.getReps("CLINICAL_HISTORY");
    }

    public List<CQU_I19_CLINICAL_HISTORY> getCLINICAL_HISTORYAll() throws HL7Exception {
        return this.getAllAsList("CLINICAL_HISTORY", CQU_I19_CLINICAL_HISTORY.class);
    }

    public void insertCLINICAL_HISTORY(CQU_I19_CLINICAL_HISTORY structure, int rep) throws HL7Exception {
        super.insertRepetition("CLINICAL_HISTORY", (Structure)structure, rep);
    }

    public CQU_I19_CLINICAL_HISTORY insertCLINICAL_HISTORY(int rep) throws HL7Exception {
        return (CQU_I19_CLINICAL_HISTORY)super.insertRepetition("CLINICAL_HISTORY", rep);
    }

    public CQU_I19_CLINICAL_HISTORY removeCLINICAL_HISTORY(int rep) throws HL7Exception {
        return (CQU_I19_CLINICAL_HISTORY)super.removeRepetition("CLINICAL_HISTORY", rep);
    }

    public CQU_I19_PATIENT_VISITS getPATIENT_VISITS() {
        return (CQU_I19_PATIENT_VISITS)this.getTyped("PATIENT_VISITS", CQU_I19_PATIENT_VISITS.class);
    }

    public CQU_I19_PATIENT_VISITS getPATIENT_VISITS(int rep) {
        return (CQU_I19_PATIENT_VISITS)this.getTyped("PATIENT_VISITS", rep, CQU_I19_PATIENT_VISITS.class);
    }

    public int getPATIENT_VISITSReps() {
        return this.getReps("PATIENT_VISITS");
    }

    public List<CQU_I19_PATIENT_VISITS> getPATIENT_VISITSAll() throws HL7Exception {
        return this.getAllAsList("PATIENT_VISITS", CQU_I19_PATIENT_VISITS.class);
    }

    public void insertPATIENT_VISITS(CQU_I19_PATIENT_VISITS structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_VISITS", (Structure)structure, rep);
    }

    public CQU_I19_PATIENT_VISITS insertPATIENT_VISITS(int rep) throws HL7Exception {
        return (CQU_I19_PATIENT_VISITS)super.insertRepetition("PATIENT_VISITS", rep);
    }

    public CQU_I19_PATIENT_VISITS removePATIENT_VISITS(int rep) throws HL7Exception {
        return (CQU_I19_PATIENT_VISITS)super.removeRepetition("PATIENT_VISITS", rep);
    }

    public CQU_I19_MEDICATION_HISTORY getMEDICATION_HISTORY() {
        return (CQU_I19_MEDICATION_HISTORY)this.getTyped("MEDICATION_HISTORY", CQU_I19_MEDICATION_HISTORY.class);
    }

    public CQU_I19_MEDICATION_HISTORY getMEDICATION_HISTORY(int rep) {
        return (CQU_I19_MEDICATION_HISTORY)this.getTyped("MEDICATION_HISTORY", rep, CQU_I19_MEDICATION_HISTORY.class);
    }

    public int getMEDICATION_HISTORYReps() {
        return this.getReps("MEDICATION_HISTORY");
    }

    public List<CQU_I19_MEDICATION_HISTORY> getMEDICATION_HISTORYAll() throws HL7Exception {
        return this.getAllAsList("MEDICATION_HISTORY", CQU_I19_MEDICATION_HISTORY.class);
    }

    public void insertMEDICATION_HISTORY(CQU_I19_MEDICATION_HISTORY structure, int rep) throws HL7Exception {
        super.insertRepetition("MEDICATION_HISTORY", (Structure)structure, rep);
    }

    public CQU_I19_MEDICATION_HISTORY insertMEDICATION_HISTORY(int rep) throws HL7Exception {
        return (CQU_I19_MEDICATION_HISTORY)super.insertRepetition("MEDICATION_HISTORY", rep);
    }

    public CQU_I19_MEDICATION_HISTORY removeMEDICATION_HISTORY(int rep) throws HL7Exception {
        return (CQU_I19_MEDICATION_HISTORY)super.removeRepetition("MEDICATION_HISTORY", rep);
    }

    public CQU_I19_PROBLEM getPROBLEM() {
        return (CQU_I19_PROBLEM)this.getTyped("PROBLEM", CQU_I19_PROBLEM.class);
    }

    public CQU_I19_PROBLEM getPROBLEM(int rep) {
        return (CQU_I19_PROBLEM)this.getTyped("PROBLEM", rep, CQU_I19_PROBLEM.class);
    }

    public int getPROBLEMReps() {
        return this.getReps("PROBLEM");
    }

    public List<CQU_I19_PROBLEM> getPROBLEMAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM", CQU_I19_PROBLEM.class);
    }

    public void insertPROBLEM(CQU_I19_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", (Structure)structure, rep);
    }

    public CQU_I19_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (CQU_I19_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public CQU_I19_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (CQU_I19_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }

    public CQU_I19_GOAL getGOAL() {
        return (CQU_I19_GOAL)this.getTyped("GOAL", CQU_I19_GOAL.class);
    }

    public CQU_I19_GOAL getGOAL(int rep) {
        return (CQU_I19_GOAL)this.getTyped("GOAL", rep, CQU_I19_GOAL.class);
    }

    public int getGOALReps() {
        return this.getReps("GOAL");
    }

    public List<CQU_I19_GOAL> getGOALAll() throws HL7Exception {
        return this.getAllAsList("GOAL", CQU_I19_GOAL.class);
    }

    public void insertGOAL(CQU_I19_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL", (Structure)structure, rep);
    }

    public CQU_I19_GOAL insertGOAL(int rep) throws HL7Exception {
        return (CQU_I19_GOAL)super.insertRepetition("GOAL", rep);
    }

    public CQU_I19_GOAL removeGOAL(int rep) throws HL7Exception {
        return (CQU_I19_GOAL)super.removeRepetition("GOAL", rep);
    }

    public CQU_I19_PATHWAY getPATHWAY() {
        return (CQU_I19_PATHWAY)this.getTyped("PATHWAY", CQU_I19_PATHWAY.class);
    }

    public CQU_I19_PATHWAY getPATHWAY(int rep) {
        return (CQU_I19_PATHWAY)this.getTyped("PATHWAY", rep, CQU_I19_PATHWAY.class);
    }

    public int getPATHWAYReps() {
        return this.getReps("PATHWAY");
    }

    public List<CQU_I19_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", CQU_I19_PATHWAY.class);
    }

    public void insertPATHWAY(CQU_I19_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", (Structure)structure, rep);
    }

    public CQU_I19_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (CQU_I19_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public CQU_I19_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (CQU_I19_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }

    public REL getREL() {
        return (REL)this.getTyped("REL", REL.class);
    }

    public REL getREL(int rep) {
        return (REL)this.getTyped("REL", rep, REL.class);
    }

    public int getRELReps() {
        return this.getReps("REL");
    }

    public List<REL> getRELAll() throws HL7Exception {
        return this.getAllAsList("REL", REL.class);
    }

    public void insertREL(REL structure, int rep) throws HL7Exception {
        super.insertRepetition("REL", (Structure)structure, rep);
    }

    public REL insertREL(int rep) throws HL7Exception {
        return (REL)super.insertRepetition("REL", rep);
    }

    public REL removeREL(int rep) throws HL7Exception {
        return (REL)super.removeRepetition("REL", rep);
    }
}

