/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.MFN_M07_MF_CLIN_STUDY_SCHED;
import ca.uhn.hl7v2.model.v27.segment.MFI;
import ca.uhn.hl7v2.model.v27.segment.MSH;
import ca.uhn.hl7v2.model.v27.segment.SFT;
import ca.uhn.hl7v2.model.v27.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M07
extends AbstractMessage {
    public MFN_M07() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFN_M07(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M07_MF_CLIN_STUDY_SCHED.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M07 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFN_M07_MF_CLIN_STUDY_SCHED getMF_CLIN_STUDY_SCHED() {
        return (MFN_M07_MF_CLIN_STUDY_SCHED)this.getTyped("MF_CLIN_STUDY_SCHED", MFN_M07_MF_CLIN_STUDY_SCHED.class);
    }

    public MFN_M07_MF_CLIN_STUDY_SCHED getMF_CLIN_STUDY_SCHED(int rep) {
        return (MFN_M07_MF_CLIN_STUDY_SCHED)this.getTyped("MF_CLIN_STUDY_SCHED", rep, MFN_M07_MF_CLIN_STUDY_SCHED.class);
    }

    public int getMF_CLIN_STUDY_SCHEDReps() {
        return this.getReps("MF_CLIN_STUDY_SCHED");
    }

    public List<MFN_M07_MF_CLIN_STUDY_SCHED> getMF_CLIN_STUDY_SCHEDAll() throws HL7Exception {
        return this.getAllAsList("MF_CLIN_STUDY_SCHED", MFN_M07_MF_CLIN_STUDY_SCHED.class);
    }

    public void insertMF_CLIN_STUDY_SCHED(MFN_M07_MF_CLIN_STUDY_SCHED structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_CLIN_STUDY_SCHED", (Structure)structure, rep);
    }

    public MFN_M07_MF_CLIN_STUDY_SCHED insertMF_CLIN_STUDY_SCHED(int rep) throws HL7Exception {
        return (MFN_M07_MF_CLIN_STUDY_SCHED)super.insertRepetition("MF_CLIN_STUDY_SCHED", rep);
    }

    public MFN_M07_MF_CLIN_STUDY_SCHED removeMF_CLIN_STUDY_SCHED(int rep) throws HL7Exception {
        return (MFN_M07_MF_CLIN_STUDY_SCHED)super.removeRepetition("MF_CLIN_STUDY_SCHED", rep);
    }
}

