/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.RDR_RDR_DEFINITION;
import ca.uhn.hl7v2.model.v27.segment.DSC;
import ca.uhn.hl7v2.model.v27.segment.ERR;
import ca.uhn.hl7v2.model.v27.segment.MSA;
import ca.uhn.hl7v2.model.v27.segment.MSH;
import ca.uhn.hl7v2.model.v27.segment.SFT;
import ca.uhn.hl7v2.model.v27.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RDR_RDR
extends AbstractMessage {
    public RDR_RDR() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RDR_RDR(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(SFT.class, false, false);
            this.add(UAC.class, false, false);
            this.add(RDR_RDR_DEFINITION.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RDR_RDR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return (ERR)this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", (Structure)structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public RDR_RDR_DEFINITION getDEFINITION() {
        return (RDR_RDR_DEFINITION)this.getTyped("DEFINITION", RDR_RDR_DEFINITION.class);
    }

    public RDR_RDR_DEFINITION getDEFINITION(int rep) {
        return (RDR_RDR_DEFINITION)this.getTyped("DEFINITION", rep, RDR_RDR_DEFINITION.class);
    }

    public int getDEFINITIONReps() {
        return this.getReps("DEFINITION");
    }

    public List<RDR_RDR_DEFINITION> getDEFINITIONAll() throws HL7Exception {
        return this.getAllAsList("DEFINITION", RDR_RDR_DEFINITION.class);
    }

    public void insertDEFINITION(RDR_RDR_DEFINITION structure, int rep) throws HL7Exception {
        super.insertRepetition("DEFINITION", (Structure)structure, rep);
    }

    public RDR_RDR_DEFINITION insertDEFINITION(int rep) throws HL7Exception {
        return (RDR_RDR_DEFINITION)super.insertRepetition("DEFINITION", rep);
    }

    public RDR_RDR_DEFINITION removeDEFINITION(int rep) throws HL7Exception {
        return (RDR_RDR_DEFINITION)super.removeRepetition("DEFINITION", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

