/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.segment.AFF;
import ca.uhn.hl7v2.model.v281.segment.CER;
import ca.uhn.hl7v2.model.v281.segment.EDU;
import ca.uhn.hl7v2.model.v281.segment.EVN;
import ca.uhn.hl7v2.model.v281.segment.LAN;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.NK1;
import ca.uhn.hl7v2.model.v281.segment.ORG;
import ca.uhn.hl7v2.model.v281.segment.PRA;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.model.v281.segment.ROL;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.STF;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PMU_B01
extends AbstractMessage {
    public PMU_B01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public PMU_B01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EVN.class, true, false);
            this.add(STF.class, true, false);
            this.add(PRA.class, false, true);
            this.add(ORG.class, false, true);
            this.add(AFF.class, false, true);
            this.add(LAN.class, false, true);
            this.add(EDU.class, false, true);
            this.add(CER.class, false, true);
            this.add(NK1.class, false, true);
            this.add(PRT.class, false, true);
            this.add(ROL.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PMU_B01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public STF getSTF() {
        return (STF)this.getTyped("STF", STF.class);
    }

    public PRA getPRA() {
        return (PRA)this.getTyped("PRA", PRA.class);
    }

    public PRA getPRA(int rep) {
        return (PRA)this.getTyped("PRA", rep, PRA.class);
    }

    public int getPRAReps() {
        return this.getReps("PRA");
    }

    public List<PRA> getPRAAll() throws HL7Exception {
        return this.getAllAsList("PRA", PRA.class);
    }

    public void insertPRA(PRA structure, int rep) throws HL7Exception {
        super.insertRepetition("PRA", (Structure)structure, rep);
    }

    public PRA insertPRA(int rep) throws HL7Exception {
        return (PRA)super.insertRepetition("PRA", rep);
    }

    public PRA removePRA(int rep) throws HL7Exception {
        return (PRA)super.removeRepetition("PRA", rep);
    }

    public ORG getORG() {
        return (ORG)this.getTyped("ORG", ORG.class);
    }

    public ORG getORG(int rep) {
        return (ORG)this.getTyped("ORG", rep, ORG.class);
    }

    public int getORGReps() {
        return this.getReps("ORG");
    }

    public List<ORG> getORGAll() throws HL7Exception {
        return this.getAllAsList("ORG", ORG.class);
    }

    public void insertORG(ORG structure, int rep) throws HL7Exception {
        super.insertRepetition("ORG", (Structure)structure, rep);
    }

    public ORG insertORG(int rep) throws HL7Exception {
        return (ORG)super.insertRepetition("ORG", rep);
    }

    public ORG removeORG(int rep) throws HL7Exception {
        return (ORG)super.removeRepetition("ORG", rep);
    }

    public AFF getAFF() {
        return (AFF)this.getTyped("AFF", AFF.class);
    }

    public AFF getAFF(int rep) {
        return (AFF)this.getTyped("AFF", rep, AFF.class);
    }

    public int getAFFReps() {
        return this.getReps("AFF");
    }

    public List<AFF> getAFFAll() throws HL7Exception {
        return this.getAllAsList("AFF", AFF.class);
    }

    public void insertAFF(AFF structure, int rep) throws HL7Exception {
        super.insertRepetition("AFF", (Structure)structure, rep);
    }

    public AFF insertAFF(int rep) throws HL7Exception {
        return (AFF)super.insertRepetition("AFF", rep);
    }

    public AFF removeAFF(int rep) throws HL7Exception {
        return (AFF)super.removeRepetition("AFF", rep);
    }

    public LAN getLAN() {
        return (LAN)this.getTyped("LAN", LAN.class);
    }

    public LAN getLAN(int rep) {
        return (LAN)this.getTyped("LAN", rep, LAN.class);
    }

    public int getLANReps() {
        return this.getReps("LAN");
    }

    public List<LAN> getLANAll() throws HL7Exception {
        return this.getAllAsList("LAN", LAN.class);
    }

    public void insertLAN(LAN structure, int rep) throws HL7Exception {
        super.insertRepetition("LAN", (Structure)structure, rep);
    }

    public LAN insertLAN(int rep) throws HL7Exception {
        return (LAN)super.insertRepetition("LAN", rep);
    }

    public LAN removeLAN(int rep) throws HL7Exception {
        return (LAN)super.removeRepetition("LAN", rep);
    }

    public EDU getEDU() {
        return (EDU)this.getTyped("EDU", EDU.class);
    }

    public EDU getEDU(int rep) {
        return (EDU)this.getTyped("EDU", rep, EDU.class);
    }

    public int getEDUReps() {
        return this.getReps("EDU");
    }

    public List<EDU> getEDUAll() throws HL7Exception {
        return this.getAllAsList("EDU", EDU.class);
    }

    public void insertEDU(EDU structure, int rep) throws HL7Exception {
        super.insertRepetition("EDU", (Structure)structure, rep);
    }

    public EDU insertEDU(int rep) throws HL7Exception {
        return (EDU)super.insertRepetition("EDU", rep);
    }

    public EDU removeEDU(int rep) throws HL7Exception {
        return (EDU)super.removeRepetition("EDU", rep);
    }

    public CER getCER() {
        return (CER)this.getTyped("CER", CER.class);
    }

    public CER getCER(int rep) {
        return (CER)this.getTyped("CER", rep, CER.class);
    }

    public int getCERReps() {
        return this.getReps("CER");
    }

    public List<CER> getCERAll() throws HL7Exception {
        return this.getAllAsList("CER", CER.class);
    }

    public void insertCER(CER structure, int rep) throws HL7Exception {
        super.insertRepetition("CER", (Structure)structure, rep);
    }

    public CER insertCER(int rep) throws HL7Exception {
        return (CER)super.insertRepetition("CER", rep);
    }

    public CER removeCER(int rep) throws HL7Exception {
        return (CER)super.removeRepetition("CER", rep);
    }

    public NK1 getNK1() {
        return (NK1)this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return (NK1)this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public PRT getPRT() {
        return (PRT)this.getTyped("PRT", PRT.class);
    }

    public PRT getPRT(int rep) {
        return (PRT)this.getTyped("PRT", rep, PRT.class);
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ROL getROL() {
        return (ROL)this.getTyped("ROL", ROL.class);
    }

    public ROL getROL(int rep) {
        return (ROL)this.getTyped("ROL", rep, ROL.class);
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }
}

