/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.ED;
import ca.uhn.hl7v2.model.v281.datatype.EI;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.SI;
import ca.uhn.hl7v2.model.v281.datatype.ST;
import ca.uhn.hl7v2.model.v281.datatype.XCN;
import ca.uhn.hl7v2.model.v281.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CER
extends AbstractSegment {
    public CER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 0, new Object[]{this.getMessage()}, "Set ID - CER");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Serial Number");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Version");
            this.add(XON.class, false, 1, 0, new Object[]{this.getMessage()}, "Granting Authority");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Issuing Authority");
            this.add(ED.class, false, 1, 0, new Object[]{this.getMessage()}, "Signature");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(399)}, "Granting Country");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Granting State/Province");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Granting County/Parish");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Certificate Type");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Certificate Domain");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Subject ID");
            this.add(ST.class, true, 1, 0, new Object[]{this.getMessage()}, "Subject Name");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Subject Directory Attribute Extension");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Subject Public Key Info");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Authority Key Identifier");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Basic Constraint");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "CRL Distribution Point");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(399)}, "Jurisdiction Country");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Jurisdiction State/Province");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Jurisdiction County/Parish");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Jurisdiction Breadth");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Granting Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Issuing Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Activation Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Inactivation Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Expiration Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Renewal Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Revocation Date");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Revocation Reason Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Certificate Status Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDCER() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getCer1_SetIDCER() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getSerialNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getCer2_SerialNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getVersion() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getCer3_Version() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public XON getGrantingAuthority() {
        XON retVal = (XON)this.getTypedField(4, 0);
        return retVal;
    }

    public XON getCer4_GrantingAuthority() {
        XON retVal = (XON)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN getIssuingAuthority() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public XCN getCer5_IssuingAuthority() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public ED getSignature() {
        ED retVal = (ED)this.getTypedField(6, 0);
        return retVal;
    }

    public ED getCer6_Signature() {
        ED retVal = (ED)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getGrantingCountry() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getCer7_GrantingCountry() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getGrantingStateProvince() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getCer8_GrantingStateProvince() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getGrantingCountyParish() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getCer9_GrantingCountyParish() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getCertificateType() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getCer10_CertificateType() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getCertificateDomain() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getCer11_CertificateDomain() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public EI getSubjectID() {
        EI retVal = (EI)this.getTypedField(12, 0);
        return retVal;
    }

    public EI getCer12_SubjectID() {
        EI retVal = (EI)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getSubjectName() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getCer13_SubjectName() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE[] getSubjectDirectoryAttributeExtension() {
        CWE[] retVal = (CWE[])this.getTypedField(14, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getCer14_SubjectDirectoryAttributeExtension() {
        CWE[] retVal = (CWE[])this.getTypedField(14, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSubjectDirectoryAttributeExtensionReps() {
        return this.getReps(14);
    }

    public CWE getSubjectDirectoryAttributeExtension(int rep) {
        CWE retVal = (CWE)this.getTypedField(14, rep);
        return retVal;
    }

    public CWE getCer14_SubjectDirectoryAttributeExtension(int rep) {
        CWE retVal = (CWE)this.getTypedField(14, rep);
        return retVal;
    }

    public int getCer14_SubjectDirectoryAttributeExtensionReps() {
        return this.getReps(14);
    }

    public CWE insertSubjectDirectoryAttributeExtension(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(14, rep);
    }

    public CWE insertCer14_SubjectDirectoryAttributeExtension(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(14, rep);
    }

    public CWE removeSubjectDirectoryAttributeExtension(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(14, rep);
    }

    public CWE removeCer14_SubjectDirectoryAttributeExtension(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(14, rep);
    }

    public CWE getSubjectPublicKeyInfo() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getCer15_SubjectPublicKeyInfo() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getAuthorityKeyIdentifier() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getCer16_AuthorityKeyIdentifier() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getBasicConstraint() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getCer17_BasicConstraint() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE[] getCRLDistributionPoint() {
        CWE[] retVal = (CWE[])this.getTypedField(18, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getCer18_CRLDistributionPoint() {
        CWE[] retVal = (CWE[])this.getTypedField(18, (Type[])new CWE[0]);
        return retVal;
    }

    public int getCRLDistributionPointReps() {
        return this.getReps(18);
    }

    public CWE getCRLDistributionPoint(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public CWE getCer18_CRLDistributionPoint(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public int getCer18_CRLDistributionPointReps() {
        return this.getReps(18);
    }

    public CWE insertCRLDistributionPoint(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE insertCer18_CRLDistributionPoint(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE removeCRLDistributionPoint(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public CWE removeCer18_CRLDistributionPoint(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public ID getJurisdictionCountry() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getCer19_JurisdictionCountry() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public CWE getJurisdictionStateProvince() {
        CWE retVal = (CWE)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getCer20_JurisdictionStateProvince() {
        CWE retVal = (CWE)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getJurisdictionCountyParish() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getCer21_JurisdictionCountyParish() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE[] getJurisdictionBreadth() {
        CWE[] retVal = (CWE[])this.getTypedField(22, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getCer22_JurisdictionBreadth() {
        CWE[] retVal = (CWE[])this.getTypedField(22, (Type[])new CWE[0]);
        return retVal;
    }

    public int getJurisdictionBreadthReps() {
        return this.getReps(22);
    }

    public CWE getJurisdictionBreadth(int rep) {
        CWE retVal = (CWE)this.getTypedField(22, rep);
        return retVal;
    }

    public CWE getCer22_JurisdictionBreadth(int rep) {
        CWE retVal = (CWE)this.getTypedField(22, rep);
        return retVal;
    }

    public int getCer22_JurisdictionBreadthReps() {
        return this.getReps(22);
    }

    public CWE insertJurisdictionBreadth(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(22, rep);
    }

    public CWE insertCer22_JurisdictionBreadth(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(22, rep);
    }

    public CWE removeJurisdictionBreadth(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(22, rep);
    }

    public CWE removeCer22_JurisdictionBreadth(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(22, rep);
    }

    public DTM getGrantingDate() {
        DTM retVal = (DTM)this.getTypedField(23, 0);
        return retVal;
    }

    public DTM getCer23_GrantingDate() {
        DTM retVal = (DTM)this.getTypedField(23, 0);
        return retVal;
    }

    public DTM getIssuingDate() {
        DTM retVal = (DTM)this.getTypedField(24, 0);
        return retVal;
    }

    public DTM getCer24_IssuingDate() {
        DTM retVal = (DTM)this.getTypedField(24, 0);
        return retVal;
    }

    public DTM getActivationDate() {
        DTM retVal = (DTM)this.getTypedField(25, 0);
        return retVal;
    }

    public DTM getCer25_ActivationDate() {
        DTM retVal = (DTM)this.getTypedField(25, 0);
        return retVal;
    }

    public DTM getInactivationDate() {
        DTM retVal = (DTM)this.getTypedField(26, 0);
        return retVal;
    }

    public DTM getCer26_InactivationDate() {
        DTM retVal = (DTM)this.getTypedField(26, 0);
        return retVal;
    }

    public DTM getExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(27, 0);
        return retVal;
    }

    public DTM getCer27_ExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(27, 0);
        return retVal;
    }

    public DTM getRenewalDate() {
        DTM retVal = (DTM)this.getTypedField(28, 0);
        return retVal;
    }

    public DTM getCer28_RenewalDate() {
        DTM retVal = (DTM)this.getTypedField(28, 0);
        return retVal;
    }

    public DTM getRevocationDate() {
        DTM retVal = (DTM)this.getTypedField(29, 0);
        return retVal;
    }

    public DTM getCer29_RevocationDate() {
        DTM retVal = (DTM)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getRevocationReasonCode() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getCer30_RevocationReasonCode() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getCertificateStatusCode() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE getCer31_CertificateStatusCode() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new XON(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new ED(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(399));
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new EI(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new ID(this.getMessage(), new Integer(399));
            }
            case 19: {
                return new CWE(this.getMessage());
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new CWE(this.getMessage());
            }
            case 22: {
                return new DTM(this.getMessage());
            }
            case 23: {
                return new DTM(this.getMessage());
            }
            case 24: {
                return new DTM(this.getMessage());
            }
            case 25: {
                return new DTM(this.getMessage());
            }
            case 26: {
                return new DTM(this.getMessage());
            }
            case 27: {
                return new DTM(this.getMessage());
            }
            case 28: {
                return new DTM(this.getMessage());
            }
            case 29: {
                return new CWE(this.getMessage());
            }
            case 30: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

