/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 * 
 * The contents of this file are subject to the Mozilla Public License Version 1.1 
 * (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the 
 * specific language governing rights and limitations under the License. 
 * 
 * The Original Code is "[file_name]".  Description: 
 * "[one_line_description]" 
 * 
 * The Initial Developer of the Original Code is University Health Network. Copyright (C) 
 * 2012.  All Rights Reserved. 
 * 
 * Contributor(s): ______________________________________. 
 * 
 * Alternatively, the contents of this file may be used under the terms of the 
 * GNU General Public License (the  "GPL"), in which case the provisions of the GPL are 
 * applicable instead of those above.  If you wish to allow use of your version of this 
 * file only under the terms of the GPL and not to allow others to use your version 
 * of this file under the MPL, indicate your decision by deleting  the provisions above 
 * and replace  them with the notice and other provisions required by the GPL License.  
 * If you do not delete the provisions above, a recipient may use your version of 
 * this file under either the MPL or the GPL. 
 * 
 */


package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.model.v281.segment.*;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.model.*;

/**
 * <p>Represents a EAC_U07_SPECIMEN_CONTAINER group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                         * <li>1: SAC (Specimen Container detail) <b>  </b></li>
                         * <li>2: OBR (Observation Request) <b>optional repeating </b></li>
                         * <li>3: SPM (Specimen) <b>optional repeating </b></li>
 * </ul>
 */
//@SuppressWarnings("unused")
public class EAC_U07_SPECIMEN_CONTAINER extends AbstractGroup {

    /** 
     * Creates a new EAC_U07_SPECIMEN_CONTAINER group
     */
    public EAC_U07_SPECIMEN_CONTAINER(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SAC.class, true, false, false);
                                  this.add(OBR.class, false, true, false);
                                  this.add(SPM.class, false, true, false);
       } catch(HL7Exception e) {
          log.error("Unexpected error creating EAC_U07_SPECIMEN_CONTAINER - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.8.1"
     */
    public String getVersion() {
       return "2.8.1";
    }



    /**
     * Returns
     * SAC (Specimen Container detail) - creates it if necessary
     */
    public SAC getSAC() { 
       SAC retVal = getTyped("SAC", SAC.class);
       return retVal;
    }




    /**
     * Returns
     * the first repetition of 
     * OBR (Observation Request) - creates it if necessary
     */
    public OBR getOBR() { 
       OBR retVal = getTyped("OBR", OBR.class);
       return retVal;
    }


    /**
     * Returns a specific repetition of
     * OBR (Observation Request) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public OBR getOBR(int rep) { 
       OBR retVal = getTyped("OBR", rep, OBR.class);
       return retVal;
    }

    /** 
     * Returns the number of existing repetitions of OBR 
     */ 
    public int getOBRReps() {  
        return getReps("OBR");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of OBR.
     * <p>
     * <p>
     * Note that unlike {@link #getOBR()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public java.util.List<OBR> getOBRAll() throws HL7Exception {
    	return getAllAsList("OBR", OBR.class);
    } 

    /**
     * Inserts a specific repetition of OBR (Observation Request)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertOBR(OBR structure, int rep) throws HL7Exception { 
       super.insertRepetition("OBR", structure, rep);
    }


    /**
     * Inserts a specific repetition of OBR (Observation Request)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public OBR insertOBR(int rep) throws HL7Exception { 
       return (OBR)super.insertRepetition("OBR", rep);
    }


    /**
     * Removes a specific repetition of OBR (Observation Request)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public OBR removeOBR(int rep) throws HL7Exception { 
       return (OBR)super.removeRepetition("OBR", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * SPM (Specimen) - creates it if necessary
     */
    public SPM getSPM() { 
       SPM retVal = getTyped("SPM", SPM.class);
       return retVal;
    }


    /**
     * Returns a specific repetition of
     * SPM (Specimen) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SPM getSPM(int rep) { 
       SPM retVal = getTyped("SPM", rep, SPM.class);
       return retVal;
    }

    /** 
     * Returns the number of existing repetitions of SPM 
     */ 
    public int getSPMReps() {  
        return getReps("SPM");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of SPM.
     * <p>
     * <p>
     * Note that unlike {@link #getSPM()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public java.util.List<SPM> getSPMAll() throws HL7Exception {
    	return getAllAsList("SPM", SPM.class);
    } 

    /**
     * Inserts a specific repetition of SPM (Specimen)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertSPM(SPM structure, int rep) throws HL7Exception { 
       super.insertRepetition("SPM", structure, rep);
    }


    /**
     * Inserts a specific repetition of SPM (Specimen)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SPM insertSPM(int rep) throws HL7Exception { 
       return (SPM)super.insertRepetition("SPM", rep);
    }


    /**
     * Removes a specific repetition of SPM (Specimen)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SPM removeSPM(int rep) throws HL7Exception { 
       return (SPM)super.removeRepetition("SPM", rep);
    }



}

