/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.segment.AUT;
import ca.uhn.hl7v2.model.v281.segment.IN1;
import ca.uhn.hl7v2.model.v281.segment.IN2;
import ca.uhn.hl7v2.model.v281.segment.IN3;
import ca.uhn.hl7v2.model.v281.segment.RF1;
import ca.uhn.hl7v2.model.v281.segment.ROL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADT_A05_INSURANCE
extends AbstractGroup {
    public ADT_A05_INSURANCE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(IN1.class, true, false, false);
            this.add(IN2.class, false, false, false);
            this.add(IN3.class, false, true, false);
            this.add(ROL.class, false, true, false);
            this.add(AUT.class, false, true, false);
            this.add(RF1.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A05_INSURANCE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public IN1 getIN1() {
        IN1 retVal = (IN1)this.getTyped("IN1", IN1.class);
        return retVal;
    }

    public IN2 getIN2() {
        IN2 retVal = (IN2)this.getTyped("IN2", IN2.class);
        return retVal;
    }

    public IN3 getIN3() {
        IN3 retVal = (IN3)this.getTyped("IN3", IN3.class);
        return retVal;
    }

    public IN3 getIN3(int rep) {
        IN3 retVal = (IN3)this.getTyped("IN3", rep, IN3.class);
        return retVal;
    }

    public int getIN3Reps() {
        return this.getReps("IN3");
    }

    public List<IN3> getIN3All() throws HL7Exception {
        return this.getAllAsList("IN3", IN3.class);
    }

    public void insertIN3(IN3 structure, int rep) throws HL7Exception {
        super.insertRepetition("IN3", (Structure)structure, rep);
    }

    public IN3 insertIN3(int rep) throws HL7Exception {
        return (IN3)super.insertRepetition("IN3", rep);
    }

    public IN3 removeIN3(int rep) throws HL7Exception {
        return (IN3)super.removeRepetition("IN3", rep);
    }

    public ROL getROL() {
        ROL retVal = (ROL)this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = (ROL)this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public AUT getAUT() {
        AUT retVal = (AUT)this.getTyped("AUT", AUT.class);
        return retVal;
    }

    public AUT getAUT(int rep) {
        AUT retVal = (AUT)this.getTyped("AUT", rep, AUT.class);
        return retVal;
    }

    public int getAUTReps() {
        return this.getReps("AUT");
    }

    public List<AUT> getAUTAll() throws HL7Exception {
        return this.getAllAsList("AUT", AUT.class);
    }

    public void insertAUT(AUT structure, int rep) throws HL7Exception {
        super.insertRepetition("AUT", (Structure)structure, rep);
    }

    public AUT insertAUT(int rep) throws HL7Exception {
        return (AUT)super.insertRepetition("AUT", rep);
    }

    public AUT removeAUT(int rep) throws HL7Exception {
        return (AUT)super.removeRepetition("AUT", rep);
    }

    public RF1 getRF1() {
        RF1 retVal = (RF1)this.getTyped("RF1", RF1.class);
        return retVal;
    }

    public RF1 getRF1(int rep) {
        RF1 retVal = (RF1)this.getTyped("RF1", rep, RF1.class);
        return retVal;
    }

    public int getRF1Reps() {
        return this.getReps("RF1");
    }

    public List<RF1> getRF1All() throws HL7Exception {
        return this.getAllAsList("RF1", RF1.class);
    }

    public void insertRF1(RF1 structure, int rep) throws HL7Exception {
        super.insertRepetition("RF1", (Structure)structure, rep);
    }

    public RF1 insertRF1(int rep) throws HL7Exception {
        return (RF1)super.insertRepetition("RF1", rep);
    }

    public RF1 removeRF1(int rep) throws HL7Exception {
        return (RF1)super.removeRepetition("RF1", rep);
    }
}

