/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.ORI_O24_TIMING;
import ca.uhn.hl7v2.model.v281.segment.IPC;
import ca.uhn.hl7v2.model.v281.segment.NTE;
import ca.uhn.hl7v2.model.v281.segment.OBR;
import ca.uhn.hl7v2.model.v281.segment.ORC;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORI_O24_ORDER
extends AbstractGroup {
    public ORI_O24_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(ORI_O24_TIMING.class, false, true, false);
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(PRT.class, false, true, false);
            this.add(IPC.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORI_O24_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ORI_O24_TIMING getTIMING() {
        ORI_O24_TIMING retVal = (ORI_O24_TIMING)this.getTyped("TIMING", ORI_O24_TIMING.class);
        return retVal;
    }

    public ORI_O24_TIMING getTIMING(int rep) {
        ORI_O24_TIMING retVal = (ORI_O24_TIMING)this.getTyped("TIMING", rep, ORI_O24_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<ORI_O24_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", ORI_O24_TIMING.class);
    }

    public void insertTIMING(ORI_O24_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public ORI_O24_TIMING insertTIMING(int rep) throws HL7Exception {
        return (ORI_O24_TIMING)super.insertRepetition("TIMING", rep);
    }

    public ORI_O24_TIMING removeTIMING(int rep) throws HL7Exception {
        return (ORI_O24_TIMING)super.removeRepetition("TIMING", rep);
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public PRT getPRT2() {
        PRT retVal = (PRT)this.getTyped("PRT2", PRT.class);
        return retVal;
    }

    public PRT getPRT2(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT2", rep, PRT.class);
        return retVal;
    }

    public int getPRT2Reps() {
        return this.getReps("PRT2");
    }

    public List<PRT> getPRT2All() throws HL7Exception {
        return this.getAllAsList("PRT2", PRT.class);
    }

    public void insertPRT2(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT2", (Structure)structure, rep);
    }

    public PRT insertPRT2(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT2", rep);
    }

    public PRT removePRT2(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT2", rep);
    }

    public IPC getIPC() {
        IPC retVal = (IPC)this.getTyped("IPC", IPC.class);
        return retVal;
    }

    public IPC getIPC(int rep) {
        IPC retVal = (IPC)this.getTyped("IPC", rep, IPC.class);
        return retVal;
    }

    public int getIPCReps() {
        return this.getReps("IPC");
    }

    public List<IPC> getIPCAll() throws HL7Exception {
        return this.getAllAsList("IPC", IPC.class);
    }

    public void insertIPC(IPC structure, int rep) throws HL7Exception {
        super.insertRepetition("IPC", (Structure)structure, rep);
    }

    public IPC insertIPC(int rep) throws HL7Exception {
        return (IPC)super.insertRepetition("IPC", rep);
    }

    public IPC removeIPC(int rep) throws HL7Exception {
        return (IPC)super.removeRepetition("IPC", rep);
    }
}

