/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.DPR_O48_DONATION;
import ca.uhn.hl7v2.model.v281.group.DPR_O48_DONOR;
import ca.uhn.hl7v2.model.v281.group.DPR_O48_OBRNTE;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class DPR_O48
extends AbstractMessage {
    public DPR_O48() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public DPR_O48(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(DPR_O48_DONOR.class, false, false);
            this.add(DPR_O48_OBRNTE.class, true, true);
            this.add(DPR_O48_DONATION.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DPR_O48 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public DPR_O48_DONOR getDONOR() {
        return (DPR_O48_DONOR)this.getTyped("DONOR", DPR_O48_DONOR.class);
    }

    public DPR_O48_OBRNTE getOBRNTE() {
        return (DPR_O48_OBRNTE)this.getTyped("OBRNTE", DPR_O48_OBRNTE.class);
    }

    public DPR_O48_OBRNTE getOBRNTE(int rep) {
        return (DPR_O48_OBRNTE)this.getTyped("OBRNTE", rep, DPR_O48_OBRNTE.class);
    }

    public int getOBRNTEReps() {
        return this.getReps("OBRNTE");
    }

    public List<DPR_O48_OBRNTE> getOBRNTEAll() throws HL7Exception {
        return this.getAllAsList("OBRNTE", DPR_O48_OBRNTE.class);
    }

    public void insertOBRNTE(DPR_O48_OBRNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("OBRNTE", (Structure)structure, rep);
    }

    public DPR_O48_OBRNTE insertOBRNTE(int rep) throws HL7Exception {
        return (DPR_O48_OBRNTE)super.insertRepetition("OBRNTE", rep);
    }

    public DPR_O48_OBRNTE removeOBRNTE(int rep) throws HL7Exception {
        return (DPR_O48_OBRNTE)super.removeRepetition("OBRNTE", rep);
    }

    public DPR_O48_DONATION getDONATION() {
        return (DPR_O48_DONATION)this.getTyped("DONATION", DPR_O48_DONATION.class);
    }
}

