/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.CX;
import ca.uhn.hl7v2.model.v281.datatype.DT;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.DTN;
import ca.uhn.hl7v2.model.v281.datatype.ICD;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.MOP;
import ca.uhn.hl7v2.model.v281.datatype.SI;
import ca.uhn.hl7v2.model.v281.datatype.ST;
import ca.uhn.hl7v2.model.v281.datatype.XCN;
import ca.uhn.hl7v2.model.v281.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IN3
extends AbstractSegment {
    public IN3(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 0, new Object[]{this.getMessage()}, "Set ID - IN3");
            this.add(CX.class, false, 1, 0, new Object[]{this.getMessage()}, "Certification Number");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Certified By");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Certification Required");
            this.add(MOP.class, false, 1, 0, new Object[]{this.getMessage()}, "Penalty");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Certification Date/Time");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Certification Modify Date/Time");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Operator");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Certification Begin Date");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Certification End Date");
            this.add(DTN.class, false, 1, 0, new Object[]{this.getMessage()}, "Days");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Non-Concur Code/Description");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Non-Concur Effective Date/Time");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Physician Reviewer");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Certification Contact");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Certification Contact Phone Number");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Appeal Reason");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Certification Agency");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Certification Agency Phone Number");
            this.add(ICD.class, false, 0, 0, new Object[]{this.getMessage()}, "Pre-Certification Requirement");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Case Manager");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Second Opinion Date");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Second Opinion Status");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Second Opinion Documentation Received");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Second Opinion Physician");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Certification Type");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Certification Category");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating IN3 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDIN3() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getIn31_SetIDIN3() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CX getCertificationNumber() {
        CX retVal = (CX)this.getTypedField(2, 0);
        return retVal;
    }

    public CX getIn32_CertificationNumber() {
        CX retVal = (CX)this.getTypedField(2, 0);
        return retVal;
    }

    public XCN[] getCertifiedBy() {
        XCN[] retVal = (XCN[])this.getTypedField(3, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getIn33_CertifiedBy() {
        XCN[] retVal = (XCN[])this.getTypedField(3, (Type[])new XCN[0]);
        return retVal;
    }

    public int getCertifiedByReps() {
        return this.getReps(3);
    }

    public XCN getCertifiedBy(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public XCN getIn33_CertifiedBy(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public int getIn33_CertifiedByReps() {
        return this.getReps(3);
    }

    public XCN insertCertifiedBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN insertIn33_CertifiedBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN removeCertifiedBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public XCN removeIn33_CertifiedBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public ID getCertificationRequired() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getIn34_CertificationRequired() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public MOP getPenalty() {
        MOP retVal = (MOP)this.getTypedField(5, 0);
        return retVal;
    }

    public MOP getIn35_Penalty() {
        MOP retVal = (MOP)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getCertificationDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getIn36_CertificationDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getCertificationModifyDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getIn37_CertificationModifyDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public XCN[] getOperator() {
        XCN[] retVal = (XCN[])this.getTypedField(8, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getIn38_Operator() {
        XCN[] retVal = (XCN[])this.getTypedField(8, (Type[])new XCN[0]);
        return retVal;
    }

    public int getOperatorReps() {
        return this.getReps(8);
    }

    public XCN getOperator(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public XCN getIn38_Operator(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public int getIn38_OperatorReps() {
        return this.getReps(8);
    }

    public XCN insertOperator(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN insertIn38_Operator(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN removeOperator(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public XCN removeIn38_Operator(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public DT getCertificationBeginDate() {
        DT retVal = (DT)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getIn39_CertificationBeginDate() {
        DT retVal = (DT)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getCertificationEndDate() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    public DT getIn310_CertificationEndDate() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    public DTN getDays() {
        DTN retVal = (DTN)this.getTypedField(11, 0);
        return retVal;
    }

    public DTN getIn311_Days() {
        DTN retVal = (DTN)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getNonConcurCodeDescription() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getIn312_NonConcurCodeDescription() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public DTM getNonConcurEffectiveDateTime() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getIn313_NonConcurEffectiveDateTime() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public XCN[] getPhysicianReviewer() {
        XCN[] retVal = (XCN[])this.getTypedField(14, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getIn314_PhysicianReviewer() {
        XCN[] retVal = (XCN[])this.getTypedField(14, (Type[])new XCN[0]);
        return retVal;
    }

    public int getPhysicianReviewerReps() {
        return this.getReps(14);
    }

    public XCN getPhysicianReviewer(int rep) {
        XCN retVal = (XCN)this.getTypedField(14, rep);
        return retVal;
    }

    public XCN getIn314_PhysicianReviewer(int rep) {
        XCN retVal = (XCN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getIn314_PhysicianReviewerReps() {
        return this.getReps(14);
    }

    public XCN insertPhysicianReviewer(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(14, rep);
    }

    public XCN insertIn314_PhysicianReviewer(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(14, rep);
    }

    public XCN removePhysicianReviewer(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(14, rep);
    }

    public XCN removeIn314_PhysicianReviewer(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(14, rep);
    }

    public ST getCertificationContact() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getIn315_CertificationContact() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public XTN[] getCertificationContactPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(16, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getIn316_CertificationContactPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(16, (Type[])new XTN[0]);
        return retVal;
    }

    public int getCertificationContactPhoneNumberReps() {
        return this.getReps(16);
    }

    public XTN getCertificationContactPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(16, rep);
        return retVal;
    }

    public XTN getIn316_CertificationContactPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getIn316_CertificationContactPhoneNumberReps() {
        return this.getReps(16);
    }

    public XTN insertCertificationContactPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(16, rep);
    }

    public XTN insertIn316_CertificationContactPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(16, rep);
    }

    public XTN removeCertificationContactPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(16, rep);
    }

    public XTN removeIn316_CertificationContactPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(16, rep);
    }

    public CWE getAppealReason() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getIn317_AppealReason() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getCertificationAgency() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getIn318_CertificationAgency() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public XTN[] getCertificationAgencyPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(19, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getIn319_CertificationAgencyPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(19, (Type[])new XTN[0]);
        return retVal;
    }

    public int getCertificationAgencyPhoneNumberReps() {
        return this.getReps(19);
    }

    public XTN getCertificationAgencyPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(19, rep);
        return retVal;
    }

    public XTN getIn319_CertificationAgencyPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(19, rep);
        return retVal;
    }

    public int getIn319_CertificationAgencyPhoneNumberReps() {
        return this.getReps(19);
    }

    public XTN insertCertificationAgencyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(19, rep);
    }

    public XTN insertIn319_CertificationAgencyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(19, rep);
    }

    public XTN removeCertificationAgencyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(19, rep);
    }

    public XTN removeIn319_CertificationAgencyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(19, rep);
    }

    public ICD[] getPreCertificationRequirement() {
        ICD[] retVal = (ICD[])this.getTypedField(20, (Type[])new ICD[0]);
        return retVal;
    }

    public ICD[] getIn320_PreCertificationRequirement() {
        ICD[] retVal = (ICD[])this.getTypedField(20, (Type[])new ICD[0]);
        return retVal;
    }

    public int getPreCertificationRequirementReps() {
        return this.getReps(20);
    }

    public ICD getPreCertificationRequirement(int rep) {
        ICD retVal = (ICD)this.getTypedField(20, rep);
        return retVal;
    }

    public ICD getIn320_PreCertificationRequirement(int rep) {
        ICD retVal = (ICD)this.getTypedField(20, rep);
        return retVal;
    }

    public int getIn320_PreCertificationRequirementReps() {
        return this.getReps(20);
    }

    public ICD insertPreCertificationRequirement(int rep) throws HL7Exception {
        return (ICD)super.insertRepetition(20, rep);
    }

    public ICD insertIn320_PreCertificationRequirement(int rep) throws HL7Exception {
        return (ICD)super.insertRepetition(20, rep);
    }

    public ICD removePreCertificationRequirement(int rep) throws HL7Exception {
        return (ICD)super.removeRepetition(20, rep);
    }

    public ICD removeIn320_PreCertificationRequirement(int rep) throws HL7Exception {
        return (ICD)super.removeRepetition(20, rep);
    }

    public ST getCaseManager() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getIn321_CaseManager() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public DT getSecondOpinionDate() {
        DT retVal = (DT)this.getTypedField(22, 0);
        return retVal;
    }

    public DT getIn322_SecondOpinionDate() {
        DT retVal = (DT)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getSecondOpinionStatus() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE getIn323_SecondOpinionStatus() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE[] getSecondOpinionDocumentationReceived() {
        CWE[] retVal = (CWE[])this.getTypedField(24, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getIn324_SecondOpinionDocumentationReceived() {
        CWE[] retVal = (CWE[])this.getTypedField(24, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSecondOpinionDocumentationReceivedReps() {
        return this.getReps(24);
    }

    public CWE getSecondOpinionDocumentationReceived(int rep) {
        CWE retVal = (CWE)this.getTypedField(24, rep);
        return retVal;
    }

    public CWE getIn324_SecondOpinionDocumentationReceived(int rep) {
        CWE retVal = (CWE)this.getTypedField(24, rep);
        return retVal;
    }

    public int getIn324_SecondOpinionDocumentationReceivedReps() {
        return this.getReps(24);
    }

    public CWE insertSecondOpinionDocumentationReceived(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(24, rep);
    }

    public CWE insertIn324_SecondOpinionDocumentationReceived(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(24, rep);
    }

    public CWE removeSecondOpinionDocumentationReceived(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(24, rep);
    }

    public CWE removeIn324_SecondOpinionDocumentationReceived(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(24, rep);
    }

    public XCN[] getSecondOpinionPhysician() {
        XCN[] retVal = (XCN[])this.getTypedField(25, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getIn325_SecondOpinionPhysician() {
        XCN[] retVal = (XCN[])this.getTypedField(25, (Type[])new XCN[0]);
        return retVal;
    }

    public int getSecondOpinionPhysicianReps() {
        return this.getReps(25);
    }

    public XCN getSecondOpinionPhysician(int rep) {
        XCN retVal = (XCN)this.getTypedField(25, rep);
        return retVal;
    }

    public XCN getIn325_SecondOpinionPhysician(int rep) {
        XCN retVal = (XCN)this.getTypedField(25, rep);
        return retVal;
    }

    public int getIn325_SecondOpinionPhysicianReps() {
        return this.getReps(25);
    }

    public XCN insertSecondOpinionPhysician(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(25, rep);
    }

    public XCN insertIn325_SecondOpinionPhysician(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(25, rep);
    }

    public XCN removeSecondOpinionPhysician(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(25, rep);
    }

    public XCN removeIn325_SecondOpinionPhysician(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(25, rep);
    }

    public CWE getCertificationType() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getIn326_CertificationType() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getCertificationCategory() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getIn327_CertificationCategory() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CX(this.getMessage());
            }
            case 2: {
                return new XCN(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 4: {
                return new MOP(this.getMessage());
            }
            case 5: {
                return new DTM(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new DT(this.getMessage());
            }
            case 9: {
                return new DT(this.getMessage());
            }
            case 10: {
                return new DTN(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new DTM(this.getMessage());
            }
            case 13: {
                return new XCN(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new XTN(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new XTN(this.getMessage());
            }
            case 19: {
                return new ICD(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new DT(this.getMessage());
            }
            case 22: {
                return new CWE(this.getMessage());
            }
            case 23: {
                return new CWE(this.getMessage());
            }
            case 24: {
                return new XCN(this.getMessage());
            }
            case 25: {
                return new CWE(this.getMessage());
            }
            case 26: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

