/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.EI;
import ca.uhn.hl7v2.model.v281.datatype.NA;
import ca.uhn.hl7v2.model.v281.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PAC
extends AbstractSegment {
    public PAC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 0, new Object[]{this.getMessage()}, "Set Id - PAC");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Package ID");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Parent Package ID");
            this.add(NA.class, false, 1, 0, new Object[]{this.getMessage()}, "Position in Parent Package");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Package Type");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Package Condition");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Package Handling Code");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Package Risk Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PAC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIdPAC() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPac1_SetIdPAC() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPackageID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getPac2_PackageID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getParentPackageID() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getPac3_ParentPackageID() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public NA getPositionInParentPackage() {
        NA retVal = (NA)this.getTypedField(4, 0);
        return retVal;
    }

    public NA getPac4_PositionInParentPackage() {
        NA retVal = (NA)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getPackageType() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getPac5_PackageType() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE[] getPackageCondition() {
        CWE[] retVal = (CWE[])this.getTypedField(6, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getPac6_PackageCondition() {
        CWE[] retVal = (CWE[])this.getTypedField(6, (Type[])new CWE[0]);
        return retVal;
    }

    public int getPackageConditionReps() {
        return this.getReps(6);
    }

    public CWE getPackageCondition(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public CWE getPac6_PackageCondition(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public int getPac6_PackageConditionReps() {
        return this.getReps(6);
    }

    public CWE insertPackageCondition(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE insertPac6_PackageCondition(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE removePackageCondition(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public CWE removePac6_PackageCondition(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public CWE[] getPackageHandlingCode() {
        CWE[] retVal = (CWE[])this.getTypedField(7, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getPac7_PackageHandlingCode() {
        CWE[] retVal = (CWE[])this.getTypedField(7, (Type[])new CWE[0]);
        return retVal;
    }

    public int getPackageHandlingCodeReps() {
        return this.getReps(7);
    }

    public CWE getPackageHandlingCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public CWE getPac7_PackageHandlingCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getPac7_PackageHandlingCodeReps() {
        return this.getReps(7);
    }

    public CWE insertPackageHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE insertPac7_PackageHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE removePackageHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public CWE removePac7_PackageHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public CWE[] getPackageRiskCode() {
        CWE[] retVal = (CWE[])this.getTypedField(8, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getPac8_PackageRiskCode() {
        CWE[] retVal = (CWE[])this.getTypedField(8, (Type[])new CWE[0]);
        return retVal;
    }

    public int getPackageRiskCodeReps() {
        return this.getReps(8);
    }

    public CWE getPackageRiskCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(8, rep);
        return retVal;
    }

    public CWE getPac8_PackageRiskCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(8, rep);
        return retVal;
    }

    public int getPac8_PackageRiskCodeReps() {
        return this.getReps(8);
    }

    public CWE insertPackageRiskCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(8, rep);
    }

    public CWE insertPac8_PackageRiskCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(8, rep);
    }

    public CWE removePackageRiskCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(8, rep);
    }

    public CWE removePac8_PackageRiskCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(8, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new NA(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

