/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DR;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.PL;
import ca.uhn.hl7v2.model.v281.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PDA
extends AbstractSegment {
    public PDA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Death Cause Code");
            this.add(PL.class, false, 1, 0, new Object[]{this.getMessage()}, "Death Location");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Death Certified Indicator");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Death Certificate Signed Date/Time");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Death Certified By");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Autopsy Indicator");
            this.add(DR.class, false, 1, 0, new Object[]{this.getMessage()}, "Autopsy Start and End Date/Time");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Autopsy Performed By");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Coroner Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PDA - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE[] getDeathCauseCode() {
        CWE[] retVal = (CWE[])this.getTypedField(1, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getPda1_DeathCauseCode() {
        CWE[] retVal = (CWE[])this.getTypedField(1, (Type[])new CWE[0]);
        return retVal;
    }

    public int getDeathCauseCodeReps() {
        return this.getReps(1);
    }

    public CWE getDeathCauseCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(1, rep);
        return retVal;
    }

    public CWE getPda1_DeathCauseCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(1, rep);
        return retVal;
    }

    public int getPda1_DeathCauseCodeReps() {
        return this.getReps(1);
    }

    public CWE insertDeathCauseCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(1, rep);
    }

    public CWE insertPda1_DeathCauseCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(1, rep);
    }

    public CWE removeDeathCauseCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(1, rep);
    }

    public CWE removePda1_DeathCauseCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(1, rep);
    }

    public PL getDeathLocation() {
        PL retVal = (PL)this.getTypedField(2, 0);
        return retVal;
    }

    public PL getPda2_DeathLocation() {
        PL retVal = (PL)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getDeathCertifiedIndicator() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getPda3_DeathCertifiedIndicator() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getDeathCertificateSignedDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getPda4_DeathCertificateSignedDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN getDeathCertifiedBy() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public XCN getPda5_DeathCertifiedBy() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getAutopsyIndicator() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getPda6_AutopsyIndicator() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public DR getAutopsyStartAndEndDateTime() {
        DR retVal = (DR)this.getTypedField(7, 0);
        return retVal;
    }

    public DR getPda7_AutopsyStartAndEndDateTime() {
        DR retVal = (DR)this.getTypedField(7, 0);
        return retVal;
    }

    public XCN getAutopsyPerformedBy() {
        XCN retVal = (XCN)this.getTypedField(8, 0);
        return retVal;
    }

    public XCN getPda8_AutopsyPerformedBy() {
        XCN retVal = (XCN)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getCoronerIndicator() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getPda9_CoronerIndicator() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new PL(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 6: {
                return new DR(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

