/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.base.Charsets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HarFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileRecordReader;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class HadoopArchives
implements Tool {
    public static final int VERSION = 3;
    private static final Log LOG = LogFactory.getLog(HadoopArchives.class);
    private static final String NAME = "har";
    static final String SRC_LIST_LABEL = "har.src.list";
    static final String DST_DIR_LABEL = "har.dest.path";
    static final String TMP_DIR_LABEL = "har.tmp.dir";
    static final String JOB_DIR_LABEL = "har.job.dir";
    static final String SRC_COUNT_LABEL = "har.src.count";
    static final String TOTAL_SIZE_LABEL = "har.total.size";
    static final String DST_HAR_LABEL = "har.archive.name";
    static final String SRC_PARENT_LABEL = "har.parent.path";
    static final String HAR_BLOCKSIZE_LABEL = "har.block.size";
    static final String HAR_PARTSIZE_LABEL = "har.partfile.size";
    long partSize = 0x80000000L;
    long blockSize = 0x20000000L;
    short repl = (short)10;
    private static final String usage = "archive -archiveName <NAME>.har -p <parent path> [-r <replication factor>]<src>* <dest>\n";
    private JobConf conf;
    static final String TEST_HADOOP_ARCHIVES_JAR_PATH = "test.hadoop.archives.jar";

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf, HadoopArchives.class);
        String testJar = System.getProperty(TEST_HADOOP_ARCHIVES_JAR_PATH, null);
        if (testJar != null) {
            this.conf.setJar(testJar);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public HadoopArchives(Configuration conf) {
        this.setConf(conf);
    }

    private static void checkPaths(Configuration conf, List<Path> paths) throws IOException {
        for (Path p : paths) {
            FileSystem fs = p.getFileSystem(conf);
            if (fs.exists(p)) continue;
            throw new FileNotFoundException("Source " + p + " does not exist.");
        }
    }

    private void recursivels(FileSystem fs, FileStatusDir fdir, List<FileStatusDir> out) throws IOException {
        if (fdir.getFileStatus().isFile()) {
            out.add(fdir);
            return;
        }
        out.add(fdir);
        FileStatus[] listStatus = fs.listStatus(fdir.getFileStatus().getPath());
        fdir.setChildren(listStatus);
        for (FileStatus stat : listStatus) {
            FileStatusDir fstatDir = new FileStatusDir(stat, null);
            this.recursivels(fs, fstatDir, out);
        }
    }

    private boolean checkValidName(String name) {
        Path tmp = new Path(name);
        if (tmp.depth() != 1) {
            return false;
        }
        return name.endsWith(".har");
    }

    private Path largestDepth(List<Path> paths) {
        Path deepest = paths.get(0);
        for (Path p : paths) {
            if (p.depth() <= deepest.depth()) continue;
            deepest = p;
        }
        return deepest;
    }

    private Path relPathToRoot(Path fullPath, Path root) {
        Path justRoot = new Path("/");
        if (fullPath.depth() == root.depth()) {
            return justRoot;
        }
        if (fullPath.depth() > root.depth()) {
            Path retPath = new Path(fullPath.getName());
            Path parent = fullPath.getParent();
            for (int i = 0; i < fullPath.depth() - root.depth() - 1; ++i) {
                retPath = new Path(parent.getName(), retPath);
                parent = parent.getParent();
            }
            return new Path(justRoot, retPath);
        }
        return null;
    }

    private void writeTopLevelDirs(SequenceFile.Writer srcWriter, List<Path> paths, Path parentPath) throws IOException {
        ArrayList<Path> justPaths = new ArrayList<Path>();
        for (Path p : paths) {
            justPaths.add(new Path(p.toUri().getPath()));
        }
        TreeMap<String, HashSet> allpaths = new TreeMap<String, HashSet>();
        Path deepest = this.largestDepth(paths);
        Path root = new Path("/");
        for (int i = parentPath.depth(); i < deepest.depth(); ++i) {
            ArrayList<Path> parents = new ArrayList<Path>();
            for (Path p : justPaths) {
                HashSet children;
                Path parent;
                if (p.compareTo((Object)root) == 0 || null == (parent = p.getParent())) continue;
                if (allpaths.containsKey(parent.toString())) {
                    children = (HashSet)allpaths.get(parent.toString());
                    children.add(p.getName());
                } else {
                    children = new HashSet();
                    children.add(p.getName());
                    allpaths.put(parent.toString(), children);
                }
                parents.add(parent);
            }
            justPaths = parents;
        }
        Set keyVals = allpaths.entrySet();
        for (Map.Entry entry : keyVals) {
            Path relPath = this.relPathToRoot(new Path((String)entry.getKey()), parentPath);
            if (relPath == null) continue;
            String[] children = new String[((HashSet)entry.getValue()).size()];
            int i = 0;
            for (String child : (HashSet)entry.getValue()) {
                children[i++] = child;
            }
            this.append(srcWriter, 0L, relPath.toString(), children);
        }
    }

    private void append(SequenceFile.Writer srcWriter, long len, String path, String[] children) throws IOException {
        srcWriter.append((Writable)new LongWritable(len), (Writable)new HarEntry(path, children));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void archive(Path parentPath, List<Path> srcPaths, String archiveName, Path dest) throws IOException {
        Path stagingArea;
        HadoopArchives.checkPaths((Configuration)this.conf, srcPaths);
        int numFiles = 0;
        long totalSize = 0L;
        FileSystem fs = parentPath.getFileSystem((Configuration)this.conf);
        this.blockSize = this.conf.getLong(HAR_BLOCKSIZE_LABEL, this.blockSize);
        this.partSize = this.conf.getLong(HAR_PARTSIZE_LABEL, this.partSize);
        this.conf.setLong(HAR_BLOCKSIZE_LABEL, this.blockSize);
        this.conf.setLong(HAR_PARTSIZE_LABEL, this.partSize);
        this.conf.set(DST_HAR_LABEL, archiveName);
        this.conf.set(SRC_PARENT_LABEL, parentPath.makeQualified(fs).toString());
        Path outputPath = new Path(dest, archiveName);
        FileOutputFormat.setOutputPath((JobConf)this.conf, (Path)outputPath);
        FileSystem outFs = outputPath.getFileSystem((Configuration)this.conf);
        if (outFs.exists(outputPath) || outFs.isFile(dest)) {
            throw new IOException("Invalid Output: " + outputPath);
        }
        this.conf.set(DST_DIR_LABEL, outputPath.toString());
        try {
            stagingArea = JobSubmissionFiles.getStagingDir((Cluster)new Cluster((Configuration)this.conf), (Configuration)this.conf);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        Path jobDirectory = new Path(stagingArea, "har_" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE), 36));
        FsPermission mapredSysPerms = new FsPermission(JobSubmissionFiles.JOB_DIR_PERMISSION);
        FileSystem.mkdirs((FileSystem)jobDirectory.getFileSystem((Configuration)this.conf), (Path)jobDirectory, (FsPermission)mapredSysPerms);
        this.conf.set(JOB_DIR_LABEL, jobDirectory.toString());
        FileSystem jobfs = jobDirectory.getFileSystem((Configuration)this.conf);
        Path srcFiles = new Path(jobDirectory, "_har_src_files");
        this.conf.set(SRC_LIST_LABEL, srcFiles.toString());
        try (SequenceFile.Writer srcWriter = SequenceFile.createWriter((FileSystem)jobfs, (Configuration)this.conf, (Path)srcFiles, LongWritable.class, HarEntry.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);){
            this.writeTopLevelDirs(srcWriter, srcPaths, parentPath);
            srcWriter.sync();
            for (Path src : srcPaths) {
                ArrayList<FileStatusDir> allFiles = new ArrayList<FileStatusDir>();
                FileStatus fstatus = fs.getFileStatus(src);
                FileStatusDir fdir = new FileStatusDir(fstatus, null);
                this.recursivels(fs, fdir, allFiles);
                for (FileStatusDir statDir : allFiles) {
                    String[] children;
                    FileStatus stat = statDir.getFileStatus();
                    long len = stat.isDirectory() ? 0L : stat.getLen();
                    Path path = this.relPathToRoot(stat.getPath(), parentPath);
                    if (stat.isDirectory()) {
                        FileStatus[] list = statDir.getChildren();
                        children = new String[list.length];
                        for (int i = 0; i < list.length; ++i) {
                            children[i] = list[i].getPath().getName();
                        }
                    } else {
                        children = null;
                    }
                    this.append(srcWriter, len, path.toString(), children);
                    srcWriter.sync();
                    ++numFiles;
                    totalSize += len;
                }
            }
        }
        jobfs.setReplication(srcFiles, this.repl);
        this.conf.setInt(SRC_COUNT_LABEL, numFiles);
        this.conf.setLong(TOTAL_SIZE_LABEL, totalSize);
        int numMaps = (int)(totalSize / this.partSize);
        this.conf.setNumMapTasks(numMaps == 0 ? 1 : numMaps);
        this.conf.setNumReduceTasks(1);
        this.conf.setInputFormat(HArchiveInputFormat.class);
        this.conf.setOutputFormat(NullOutputFormat.class);
        this.conf.setMapperClass(HArchivesMapper.class);
        this.conf.setReducerClass(HArchivesReducer.class);
        this.conf.setMapOutputKeyClass(IntWritable.class);
        this.conf.setMapOutputValueClass(Text.class);
        FileInputFormat.addInputPath((JobConf)this.conf, (Path)jobDirectory);
        this.conf.setSpeculativeExecution(false);
        JobClient.runJob((JobConf)this.conf);
        try {
            jobfs.delete(jobDirectory, true);
        }
        catch (IOException ie) {
            LOG.info((Object)("Unable to clean tmp directory " + jobDirectory));
        }
    }

    public int run(String[] args) throws Exception {
        try {
            Path parentPath = null;
            ArrayList<Path> srcPaths = new ArrayList<Path>();
            Path destPath = null;
            String archiveName = null;
            if (args.length < 5) {
                System.out.println(usage);
                throw new IOException("Invalid usage.");
            }
            if (!"-archiveName".equals(args[0])) {
                System.out.println(usage);
                throw new IOException("Archive Name not specified.");
            }
            archiveName = args[1];
            if (!this.checkValidName(archiveName)) {
                System.out.println(usage);
                throw new IOException("Invalid name for archives. " + archiveName);
            }
            int i = 2;
            if (!"-p".equals(args[i])) {
                System.out.println(usage);
                throw new IOException("Parent path not specified.");
            }
            parentPath = new Path(args[i + 1]);
            if (!parentPath.isAbsolute()) {
                parentPath = parentPath.getFileSystem(this.getConf()).makeQualified(parentPath);
            }
            if ("-r".equals(args[i += 2])) {
                this.repl = Short.parseShort(args[i + 1]);
                i += 2;
            }
            while (i < args.length) {
                if (i == args.length - 1) {
                    destPath = new Path(args[i]);
                    if (!destPath.isAbsolute()) {
                        destPath = destPath.getFileSystem(this.getConf()).makeQualified(destPath);
                    }
                } else {
                    Path argPath = new Path(args[i]);
                    if (argPath.isAbsolute()) {
                        System.out.println(usage);
                        throw new IOException("source path " + argPath + " is not relative  to " + parentPath);
                    }
                    srcPaths.add(new Path(parentPath, argPath));
                }
                ++i;
            }
            if (srcPaths.size() == 0) {
                srcPaths.add(parentPath);
            }
            ArrayList<Path> globPaths = new ArrayList<Path>();
            for (Path p : srcPaths) {
                FileSystem fs = p.getFileSystem(this.getConf());
                FileStatus[] statuses = fs.globStatus(p);
                if (statuses == null) continue;
                for (FileStatus status : statuses) {
                    globPaths.add(fs.makeQualified(status.getPath()));
                }
            }
            if (globPaths.isEmpty()) {
                throw new IOException("The resolved paths set is empty.  Please check whether the srcPaths exist, where srcPaths = " + srcPaths);
            }
            this.archive(parentPath, globPaths, archiveName, destPath);
        }
        catch (IOException ie) {
            System.err.println(ie.getLocalizedMessage());
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        JobConf job = new JobConf(HadoopArchives.class);
        HadoopArchives harchives = new HadoopArchives((Configuration)job);
        int ret = 0;
        try {
            ret = ToolRunner.run((Tool)harchives, (String[])args);
        }
        catch (Exception e) {
            LOG.debug((Object)"Exception in archives  ", (Throwable)e);
            System.err.println(e.getClass().getSimpleName() + " in archives");
            String s = e.getLocalizedMessage();
            if (s != null) {
                System.err.println(s);
            } else {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
        System.exit(ret);
    }

    static class HArchivesReducer
    implements Reducer<IntWritable, Text, Text, Text> {
        private JobConf conf = null;
        private long startIndex = 0L;
        private long endIndex = 0L;
        private long startPos = 0L;
        private Path masterIndex = null;
        private Path index = null;
        private FileSystem fs = null;
        private FSDataOutputStream outStream = null;
        private FSDataOutputStream indexStream = null;
        private int numIndexes = 1000;
        private Path tmpOutputDir = null;
        private int written = 0;
        private int keyVal = 0;

        HArchivesReducer() {
        }

        public void configure(JobConf conf) {
            this.conf = conf;
            this.tmpOutputDir = FileOutputFormat.getWorkOutputPath((JobConf)this.conf);
            this.masterIndex = new Path(this.tmpOutputDir, "_masterindex");
            this.index = new Path(this.tmpOutputDir, "_index");
            try {
                this.fs = this.masterIndex.getFileSystem((Configuration)conf);
                if (this.fs.exists(this.masterIndex)) {
                    this.fs.delete(this.masterIndex, false);
                }
                if (this.fs.exists(this.index)) {
                    this.fs.delete(this.index, false);
                }
                this.indexStream = this.fs.create(this.index);
                this.outStream = this.fs.create(this.masterIndex);
                String version = "3 \n";
                this.outStream.write(version.getBytes(Charsets.UTF_8));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void reduce(IntWritable key, Iterator<Text> values, OutputCollector<Text, Text> out, Reporter reporter) throws IOException {
            this.keyVal = key.get();
            while (values.hasNext()) {
                Text value = values.next();
                String towrite = value.toString() + "\n";
                this.indexStream.write(towrite.getBytes(Charsets.UTF_8));
                ++this.written;
                if (this.written <= this.numIndexes - 1) continue;
                reporter.setStatus("Creating index for archives");
                reporter.progress();
                this.endIndex = this.keyVal;
                String masterWrite = this.startIndex + " " + this.endIndex + " " + this.startPos + " " + this.indexStream.getPos() + " \n";
                this.outStream.write(masterWrite.getBytes(Charsets.UTF_8));
                this.startPos = this.indexStream.getPos();
                this.startIndex = this.endIndex;
                this.written = 0;
            }
        }

        public void close() throws IOException {
            if (this.written > 0) {
                String masterWrite = this.startIndex + " " + this.keyVal + " " + this.startPos + " " + this.indexStream.getPos() + " \n";
                this.outStream.write(masterWrite.getBytes(Charsets.UTF_8));
            }
            this.outStream.close();
            this.indexStream.close();
            this.fs.setReplication(this.index, (short)5);
            this.fs.setReplication(this.masterIndex, (short)5);
        }
    }

    static class HArchivesMapper
    implements Mapper<LongWritable, HarEntry, IntWritable, Text> {
        private JobConf conf = null;
        int partId = -1;
        Path tmpOutputDir = null;
        Path tmpOutput = null;
        String partname = null;
        Path rootPath = null;
        FSDataOutputStream partStream = null;
        FileSystem destFs = null;
        byte[] buffer;
        int buf_size = 131072;
        long blockSize = 0x20000000L;

        HArchivesMapper() {
        }

        public void configure(JobConf conf) {
            this.conf = conf;
            this.partId = conf.getInt("mapreduce.task.partition", -1);
            this.tmpOutputDir = FileOutputFormat.getWorkOutputPath((JobConf)conf);
            this.blockSize = conf.getLong(HadoopArchives.HAR_BLOCKSIZE_LABEL, this.blockSize);
            this.partname = "part-" + this.partId;
            this.tmpOutput = new Path(this.tmpOutputDir, this.partname);
            Path path = this.rootPath = conf.get(HadoopArchives.SRC_PARENT_LABEL, null) == null ? null : new Path(conf.get(HadoopArchives.SRC_PARENT_LABEL));
            if (this.rootPath == null) {
                throw new RuntimeException("Unable to read parent path for har from config");
            }
            try {
                this.destFs = this.tmpOutput.getFileSystem((Configuration)conf);
                if (this.destFs.exists(this.tmpOutput)) {
                    this.destFs.delete(this.tmpOutput, false);
                }
                this.partStream = this.destFs.create(this.tmpOutput, false, conf.getInt("io.file.buffer.size", 4096), this.destFs.getDefaultReplication(this.tmpOutput), this.blockSize);
            }
            catch (IOException ie) {
                throw new RuntimeException("Unable to open output file " + this.tmpOutput, ie);
            }
            this.buffer = new byte[this.buf_size];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyData(Path input, FSDataInputStream fsin, FSDataOutputStream fout, Reporter reporter) throws IOException {
            try {
                int cbread = 0;
                while ((cbread = fsin.read(this.buffer)) >= 0) {
                    fout.write(this.buffer, 0, cbread);
                    reporter.progress();
                }
            }
            finally {
                fsin.close();
            }
        }

        private Path realPath(Path p, Path parent) {
            Path rootPath = new Path("/");
            if (rootPath.compareTo((Object)p) == 0) {
                return parent;
            }
            return new Path(parent, new Path(p.toString().substring(1)));
        }

        private static String encodeName(String s) throws UnsupportedEncodingException {
            return URLEncoder.encode(s, "UTF-8");
        }

        private static String encodeProperties(FileStatus fStatus) throws UnsupportedEncodingException {
            String propStr = HArchivesMapper.encodeName(fStatus.getModificationTime() + " " + fStatus.getPermission().toShort() + " " + HArchivesMapper.encodeName(fStatus.getOwner()) + " " + HArchivesMapper.encodeName(fStatus.getGroup()));
            return propStr;
        }

        public void map(LongWritable key, HarEntry value, OutputCollector<IntWritable, Text> out, Reporter reporter) throws IOException {
            Path relPath = new Path(value.path);
            int hash = HarFileSystem.getHarHash((Path)relPath);
            String towrite = null;
            Path srcPath = this.realPath(relPath, this.rootPath);
            long startPos = this.partStream.getPos();
            FileSystem srcFs = srcPath.getFileSystem((Configuration)this.conf);
            FileStatus srcStatus = srcFs.getFileStatus(srcPath);
            String propStr = HArchivesMapper.encodeProperties(srcStatus);
            if (value.isDir()) {
                towrite = HArchivesMapper.encodeName(relPath.toString()) + " dir " + propStr + " 0 0 ";
                StringBuffer sbuff = new StringBuffer();
                sbuff.append(towrite);
                for (String child : value.children) {
                    sbuff.append(HArchivesMapper.encodeName(child) + " ");
                }
                towrite = sbuff.toString();
                reporter.progress();
            } else {
                FSDataInputStream input = srcFs.open(srcStatus.getPath());
                reporter.setStatus("Copying file " + srcStatus.getPath() + " to archive.");
                this.copyData(srcStatus.getPath(), input, this.partStream, reporter);
                towrite = HArchivesMapper.encodeName(relPath.toString()) + " file " + this.partname + " " + startPos + " " + srcStatus.getLen() + " " + propStr + " ";
            }
            out.collect((Object)new IntWritable(hash), (Object)new Text(towrite));
        }

        public void close() throws IOException {
            this.partStream.close();
        }
    }

    static class FileStatusDir {
        private FileStatus fstatus;
        private FileStatus[] children = null;

        FileStatusDir(FileStatus fstatus, FileStatus[] children) {
            this.fstatus = fstatus;
            this.children = children;
        }

        public void setChildren(FileStatus[] listStatus) {
            this.children = listStatus;
        }

        FileStatus getFileStatus() {
            return this.fstatus;
        }

        FileStatus[] getChildren() {
            return this.children;
        }
    }

    static class HArchiveInputFormat
    implements InputFormat<LongWritable, HarEntry> {
        HArchiveInputFormat() {
        }

        public InputSplit[] getSplits(JobConf jconf, int numSplits) throws IOException {
            String srcfilelist = jconf.get(HadoopArchives.SRC_LIST_LABEL, "");
            if ("".equals(srcfilelist)) {
                throw new IOException("Unable to get the src file for archive generation.");
            }
            long totalSize = jconf.getLong(HadoopArchives.TOTAL_SIZE_LABEL, -1L);
            if (totalSize == -1L) {
                throw new IOException("Invalid size of files to archive");
            }
            Path src = new Path(srcfilelist);
            FileSystem fs = src.getFileSystem((Configuration)jconf);
            FileStatus fstatus = fs.getFileStatus(src);
            ArrayList<FileSplit> splits = new ArrayList<FileSplit>(numSplits);
            LongWritable key = new LongWritable();
            HarEntry value = new HarEntry();
            long remaining = fstatus.getLen();
            long currentCount = 0L;
            long lastPos = 0L;
            long startPos = 0L;
            long targetSize = totalSize / (long)numSplits;
            try (SequenceFile.Reader reader = new SequenceFile.Reader(fs, src, (Configuration)jconf);){
                while (reader.next((Writable)key, (Writable)value)) {
                    if (currentCount + key.get() > targetSize && currentCount != 0L) {
                        long size = lastPos - startPos;
                        splits.add(new FileSplit(src, startPos, size, (String[])null));
                        remaining -= size;
                        startPos = lastPos;
                        currentCount = 0L;
                    }
                    currentCount += key.get();
                    lastPos = reader.getPosition();
                }
                if (remaining != 0L) {
                    splits.add(new FileSplit(src, startPos, remaining, (String[])null));
                }
            }
            return (InputSplit[])splits.toArray(new FileSplit[splits.size()]);
        }

        public RecordReader<LongWritable, HarEntry> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return new SequenceFileRecordReader((Configuration)job, (FileSplit)split);
        }
    }

    private static class HarEntry
    implements Writable {
        String path;
        String[] children;

        HarEntry() {
        }

        HarEntry(String path, String[] children) {
            this.path = path;
            this.children = children;
        }

        boolean isDir() {
            return this.children != null;
        }

        public void readFields(DataInput in) throws IOException {
            this.path = Text.readString((DataInput)in);
            if (in.readBoolean()) {
                this.children = new String[in.readInt()];
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i] = Text.readString((DataInput)in);
                }
            } else {
                this.children = null;
            }
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.path);
            boolean dir = this.isDir();
            out.writeBoolean(dir);
            if (dir) {
                out.writeInt(this.children.length);
                for (String c : this.children) {
                    Text.writeString((DataOutput)out, (String)c);
                }
            }
        }
    }
}

