/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.RoundRobinUserResolver;
import org.apache.hadoop.mapred.gridmix.SubmitterUserResolver;
import org.apache.hadoop.mapred.gridmix.UserResolver;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestUserResolve {
    private static Path rootDir = null;
    private static Configuration conf = null;
    private static FileSystem fs = null;

    @BeforeClass
    public static void createRootDir() throws IOException {
        conf = new Configuration();
        fs = FileSystem.getLocal((Configuration)conf);
        rootDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")).makeQualified(fs), "gridmixUserResolve");
    }

    private static void writeUserList(Path usersFilePath, String usersFileContent) throws IOException {
        try (FSDataOutputStream out = null;){
            out = fs.create(usersFilePath, true);
            out.writeBytes(usersFileContent);
        }
    }

    private void validateBadUsersFile(UserResolver rslv, URI userRsrc, String expectedErrorMsg) {
        boolean fail = false;
        try {
            rslv.setTargetUsers(userRsrc, conf);
        }
        catch (IOException e) {
            Assert.assertTrue((String)"Exception message from RoundRobinUserResolver is wrong", (boolean)e.getMessage().equals(expectedErrorMsg));
            fail = true;
        }
        Assert.assertTrue((String)"User list required for RoundRobinUserResolver", (boolean)fail);
    }

    @Test
    public void testRoundRobinResolver() throws Exception {
        RoundRobinUserResolver rslv = new RoundRobinUserResolver();
        Path usersFilePath = new Path(rootDir, "users");
        URI userRsrc = new URI(usersFilePath.toString());
        fs.delete(usersFilePath, false);
        String expectedErrorMsg = "File " + userRsrc + " does not exist";
        this.validateBadUsersFile((UserResolver)rslv, userRsrc, expectedErrorMsg);
        TestUserResolve.writeUserList((Path)usersFilePath, (String)"");
        expectedErrorMsg = RoundRobinUserResolver.buildEmptyUsersErrorMsg((URI)userRsrc);
        this.validateBadUsersFile((UserResolver)rslv, userRsrc, expectedErrorMsg);
        TestUserResolve.writeUserList((Path)usersFilePath, (String)"user0,groupA,groupB,groupC\nuser1,groupA,groupC\n");
        this.validateValidUsersFile((UserResolver)rslv, userRsrc);
        TestUserResolve.writeUserList((Path)usersFilePath, (String)"user0,groupA,groupB\nuser1,");
        this.validateValidUsersFile((UserResolver)rslv, userRsrc);
        TestUserResolve.writeUserList((Path)usersFilePath, (String)"user0\nuser1");
        this.validateValidUsersFile((UserResolver)rslv, userRsrc);
    }

    private void validateValidUsersFile(UserResolver rslv, URI userRsrc) throws IOException {
        Assert.assertTrue((boolean)rslv.setTargetUsers(userRsrc, conf));
        UserGroupInformation ugi1 = UserGroupInformation.createRemoteUser((String)"hfre0");
        Assert.assertEquals((Object)"user0", (Object)rslv.getTargetUgi(ugi1).getUserName());
        Assert.assertEquals((Object)"user1", (Object)rslv.getTargetUgi(UserGroupInformation.createRemoteUser((String)"hfre1")).getUserName());
        Assert.assertEquals((Object)"user0", (Object)rslv.getTargetUgi(UserGroupInformation.createRemoteUser((String)"hfre2")).getUserName());
        Assert.assertEquals((Object)"user0", (Object)rslv.getTargetUgi(ugi1).getUserName());
        Assert.assertEquals((Object)"user1", (Object)rslv.getTargetUgi(UserGroupInformation.createRemoteUser((String)"hfre3")).getUserName());
        Assert.assertEquals((Object)"user0", (Object)rslv.getTargetUgi(UserGroupInformation.createRemoteUser((String)"hfre0")).getUserName());
        Assert.assertEquals((Object)"user0", (Object)rslv.getTargetUgi(UserGroupInformation.createRemoteUser((String)"hfre5")).getUserName());
        Assert.assertEquals((Object)"user0", (Object)rslv.getTargetUgi(UserGroupInformation.createRemoteUser((String)"hfre0")).getUserName());
    }

    @Test
    public void testSubmitterResolver() throws Exception {
        SubmitterUserResolver rslv = new SubmitterUserResolver();
        Assert.assertFalse((boolean)rslv.needsTargetUsersList());
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Assert.assertEquals((Object)ugi, (Object)rslv.getTargetUgi((UserGroupInformation)null));
    }
}

