/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

class RandomTextDataGenerator {
    static final Log LOG = LogFactory.getLog(RandomTextDataGenerator.class);
    static final String GRIDMIX_DATAGEN_RANDOMTEXT_LISTSIZE = "gridmix.datagenerator.randomtext.listsize";
    static final String GRIDMIX_DATAGEN_RANDOMTEXT_WORDSIZE = "gridmix.datagenerator.randomtext.wordsize";
    static final int DEFAULT_LIST_SIZE = 200;
    static final int DEFAULT_WORD_SIZE = 10;
    static final long DEFAULT_SEED = 0L;
    private String[] words;
    private Random random;

    RandomTextDataGenerator(int size, int wordSize) {
        this(size, 0L, wordSize);
    }

    RandomTextDataGenerator(int size, Long seed, int wordSize) {
        this.random = new Random(seed);
        this.words = new String[size];
        for (int i = 0; i < size; ++i) {
            this.words[i] = RandomStringUtils.random((int)wordSize, (int)0, (int)0, (boolean)true, (boolean)false, null, (Random)this.random);
        }
    }

    static int getRandomTextDataGeneratorListSize(Configuration conf) {
        return conf.getInt(GRIDMIX_DATAGEN_RANDOMTEXT_LISTSIZE, 200);
    }

    static void setRandomTextDataGeneratorListSize(Configuration conf, int listSize) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Random text data generator is configured to use a dictionary  with " + listSize + " words"));
        }
        conf.setInt(GRIDMIX_DATAGEN_RANDOMTEXT_LISTSIZE, listSize);
    }

    static int getRandomTextDataGeneratorWordSize(Configuration conf) {
        return conf.getInt(GRIDMIX_DATAGEN_RANDOMTEXT_WORDSIZE, 10);
    }

    static void setRandomTextDataGeneratorWordSize(Configuration conf, int wordSize) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Random text data generator is configured to use a dictionary  with words of length " + wordSize));
        }
        conf.setInt(GRIDMIX_DATAGEN_RANDOMTEXT_WORDSIZE, wordSize);
    }

    String getRandomWord() {
        int index = this.random.nextInt(this.words.length);
        return this.words[index];
    }

    List<String> getRandomWords() {
        return Arrays.asList(this.words);
    }
}

