/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.gridmix.CommonJobTest;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapred.gridmix.EchoUserResolver;
import org.apache.hadoop.mapred.gridmix.Gridmix;
import org.apache.hadoop.mapred.gridmix.GridmixJobSubmissionPolicy;
import org.apache.hadoop.mapred.gridmix.GridmixTestUtils;
import org.apache.hadoop.mapred.gridmix.TestGridmixSubmission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;

public class CommonJobTest {
    public static final Log LOG = LogFactory.getLog(Gridmix.class);
    protected static int NJOBS = 2;
    protected static final long GENDATA = 1L;
    protected static GridmixJobSubmissionPolicy policy = GridmixJobSubmissionPolicy.REPLAY;
    private static File workspace = new File("target" + File.separator + TestGridmixSubmission.class.getName() + "-test");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSubmission(String jobCreatorName, boolean defaultOutputPath) throws Exception {
        block8: {
            Path in = new Path("foo").makeQualified(GridmixTestUtils.dfs.getUri(), GridmixTestUtils.dfs.getWorkingDirectory());
            Path out = GridmixTestUtils.DEST.makeQualified(GridmixTestUtils.dfs.getUri(), GridmixTestUtils.dfs.getWorkingDirectory());
            Path root = new Path(workspace.getName()).makeQualified(GridmixTestUtils.dfs.getUri(), GridmixTestUtils.dfs.getWorkingDirectory());
            if (!workspace.exists()) {
                Assert.assertTrue((boolean)workspace.mkdirs());
            }
            Configuration conf = null;
            try {
                ArrayList<String> argsList = new ArrayList<String>();
                argsList.add("-Dgridmix.min.file.size=0");
                argsList.add("-Dgridmix.user.resolve.class=" + EchoUserResolver.class.getName());
                if (jobCreatorName != null) {
                    argsList.add("-Dgridmix.job.type=" + jobCreatorName);
                }
                if (!defaultOutputPath) {
                    argsList.add("-Dgridmix.output.directory=" + out);
                }
                argsList.add("-generate");
                argsList.add(String.valueOf(1L) + "m");
                argsList.add(in.toString());
                argsList.add("-");
                String[] argv = argsList.toArray(new String[argsList.size()]);
                DebugGridmix client = new DebugGridmix();
                conf = GridmixTestUtils.mrvl.getConfig();
                CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
                conf.setEnum("gridmix.job-submission.policy", (Enum)policy);
                conf.setBoolean("gridmix.job-submission.use-queue-in-trace", true);
                UserGroupInformation ugi = UserGroupInformation.getLoginUser();
                conf.set("mapreduce.job.user.name", ugi.getUserName());
                GridmixTestUtils.dfs.mkdirs(root, new FsPermission(777));
                GridmixTestUtils.dfs.setPermission(root, new FsPermission(777));
                int res = ToolRunner.run((Configuration)conf, (Tool)client, (String[])argv);
                Assert.assertEquals((String)"Client exited with nonzero status", (long)0L, (long)res);
                client.checkMonitor();
                in.getFileSystem(conf).delete(in, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block8;
            }
            finally {
                in.getFileSystem(conf).delete(in, true);
                out.getFileSystem(conf).delete(out, true);
                root.getFileSystem(conf).delete(root, true);
            }
            out.getFileSystem(conf).delete(out, true);
            root.getFileSystem(conf).delete(root, true);
        }
    }
}

