/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.mapred.gridmix.GenerateData;
import org.apache.hadoop.mapred.gridmix.Gridmix;
import org.apache.hadoop.mapred.gridmix.JobFactory;
import org.apache.hadoop.mapred.gridmix.StatListener;
import org.apache.hadoop.mapred.gridmix.Statistics;
import org.apache.hadoop.mapred.gridmix.UserResolver;
import org.apache.hadoop.mapreduce.Job;

/*
 * Exception performing whole class analysis ignored.
 */
class ExecutionSummarizer
implements StatListener<Statistics.JobStats> {
    static final Log LOG = LogFactory.getLog(ExecutionSummarizer.class);
    private static final FastDateFormat UTIL = FastDateFormat.getInstance();
    private int numJobsInInputTrace;
    private int totalSuccessfulJobs;
    private int totalFailedJobs;
    private int totalLostJobs;
    private int totalMapTasksLaunched;
    private int totalReduceTasksLaunched;
    private long totalSimulationTime;
    private long totalRuntime;
    private final String commandLineArgs;
    private long startTime = System.currentTimeMillis();
    private long endTime;
    private long simulationStartTime;
    private String inputTraceLocation;
    private String inputTraceSignature;
    private String jobSubmissionPolicy;
    private String resolver;
    private GenerateData.DataStatistics dataStats;
    private String expectedDataSize;

    ExecutionSummarizer(String[] args) {
        this.commandLineArgs = StringUtils.join((Object[])args, (char)' ');
    }

    ExecutionSummarizer() {
        this.commandLineArgs = "N/A";
    }

    void start(Configuration conf) {
        this.simulationStartTime = System.currentTimeMillis();
    }

    private void processJobState(Statistics.JobStats stats) {
        Job job = stats.getJob();
        try {
            if (job.isSuccessful()) {
                ++this.totalSuccessfulJobs;
            } else {
                ++this.totalFailedJobs;
            }
        }
        catch (Exception e) {
            ++this.totalLostJobs;
        }
    }

    private void processJobTasks(Statistics.JobStats stats) {
        this.totalMapTasksLaunched += stats.getNoOfMaps();
        this.totalReduceTasksLaunched += stats.getNoOfReds();
    }

    private void process(Statistics.JobStats stats) {
        this.processJobState(stats);
        this.processJobTasks(stats);
    }

    public void update(Statistics.JobStats item) {
        if (this.simulationStartTime > 0L) {
            this.process(item);
            this.totalSimulationTime = System.currentTimeMillis() - this.getSimulationStartTime();
        }
    }

    protected static String getTraceSignature(String input) throws IOException {
        Path inputPath = new Path(input);
        FileSystem fs = inputPath.getFileSystem(new Configuration());
        FileStatus status = fs.getFileStatus(inputPath);
        Path qPath = fs.makeQualified(status.getPath());
        String traceID = status.getModificationTime() + qPath.toString() + status.getOwner() + status.getLen();
        return MD5Hash.digest((String)traceID).toString();
    }

    void finalize(JobFactory factory, String inputPath, long dataSize, UserResolver userResolver, GenerateData.DataStatistics stats, Configuration conf) throws IOException {
        this.numJobsInInputTrace = factory.numJobsInTrace;
        this.endTime = System.currentTimeMillis();
        if ("-".equals(inputPath)) {
            this.inputTraceLocation = "N/A";
            this.inputTraceSignature = "N/A";
        } else {
            Path inputTracePath = new Path(inputPath);
            FileSystem fs = inputTracePath.getFileSystem(conf);
            this.inputTraceLocation = fs.makeQualified(inputTracePath).toString();
            this.inputTraceSignature = ExecutionSummarizer.getTraceSignature((String)inputPath);
        }
        this.jobSubmissionPolicy = Gridmix.getJobSubmissionPolicy((Configuration)conf).name();
        this.resolver = userResolver.getClass().getName();
        this.expectedDataSize = dataSize > 0L ? org.apache.hadoop.util.StringUtils.humanReadableInt((long)dataSize) : "N/A";
        this.dataStats = stats;
        this.totalRuntime = System.currentTimeMillis() - this.getStartTime();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Execution Summary:-");
        builder.append("\nInput trace: ").append(this.getInputTraceLocation());
        builder.append("\nInput trace signature: ").append(this.getInputTraceSignature());
        builder.append("\nTotal number of jobs in trace: ").append(this.getNumJobsInTrace());
        builder.append("\nExpected input data size: ").append(this.getExpectedDataSize());
        builder.append("\nInput data statistics: ").append(this.getInputDataStatistics());
        builder.append("\nTotal number of jobs processed: ").append(this.getNumSubmittedJobs());
        builder.append("\nTotal number of successful jobs: ").append(this.getNumSuccessfulJobs());
        builder.append("\nTotal number of failed jobs: ").append(this.getNumFailedJobs());
        builder.append("\nTotal number of lost jobs: ").append(this.getNumLostJobs());
        builder.append("\nTotal number of map tasks launched: ").append(this.getNumMapTasksLaunched());
        builder.append("\nTotal number of reduce task launched: ").append(this.getNumReduceTasksLaunched());
        builder.append("\nGridmix start time: ").append(UTIL.format(this.getStartTime()));
        builder.append("\nGridmix end time: ").append(UTIL.format(this.getEndTime()));
        builder.append("\nGridmix simulation start time: ").append(UTIL.format(this.getStartTime()));
        builder.append("\nGridmix runtime: ").append(org.apache.hadoop.util.StringUtils.formatTime((long)this.getRuntime()));
        builder.append("\nTime spent in initialization (data-gen etc): ").append(org.apache.hadoop.util.StringUtils.formatTime((long)this.getInitTime()));
        builder.append("\nTime spent in simulation: ").append(org.apache.hadoop.util.StringUtils.formatTime((long)this.getSimulationTime()));
        builder.append("\nGridmix configuration parameters: ").append(this.getCommandLineArgsString());
        builder.append("\nGridmix job submission policy: ").append(this.getJobSubmissionPolicy());
        builder.append("\nGridmix resolver: ").append(this.getUserResolver());
        builder.append("\n\n");
        return builder.toString();
    }

    static String stringifyDataStatistics(GenerateData.DataStatistics stats) {
        if (stats != null) {
            StringBuffer buffer = new StringBuffer();
            String compressionStatus = stats.isDataCompressed() ? "Compressed" : "Uncompressed";
            buffer.append(compressionStatus).append(" input data size: ");
            buffer.append(org.apache.hadoop.util.StringUtils.humanReadableInt((long)stats.getDataSize()));
            buffer.append(", ");
            buffer.append("Number of files: ").append(stats.getNumFiles());
            return buffer.toString();
        }
        return "N/A";
    }

    protected String getExpectedDataSize() {
        return this.expectedDataSize;
    }

    protected String getUserResolver() {
        return this.resolver;
    }

    protected String getInputDataStatistics() {
        return ExecutionSummarizer.stringifyDataStatistics((GenerateData.DataStatistics)this.dataStats);
    }

    protected String getInputTraceSignature() {
        return this.inputTraceSignature;
    }

    protected String getInputTraceLocation() {
        return this.inputTraceLocation;
    }

    protected int getNumJobsInTrace() {
        return this.numJobsInInputTrace;
    }

    protected int getNumSuccessfulJobs() {
        return this.totalSuccessfulJobs;
    }

    protected int getNumFailedJobs() {
        return this.totalFailedJobs;
    }

    protected int getNumLostJobs() {
        return this.totalLostJobs;
    }

    protected int getNumSubmittedJobs() {
        return this.totalSuccessfulJobs + this.totalFailedJobs + this.totalLostJobs;
    }

    protected int getNumMapTasksLaunched() {
        return this.totalMapTasksLaunched;
    }

    protected int getNumReduceTasksLaunched() {
        return this.totalReduceTasksLaunched;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected long getEndTime() {
        return this.endTime;
    }

    protected long getInitTime() {
        return this.simulationStartTime - this.startTime;
    }

    protected long getSimulationStartTime() {
        return this.simulationStartTime;
    }

    protected long getSimulationTime() {
        return this.totalSimulationTime;
    }

    protected long getRuntime() {
        return this.totalRuntime;
    }

    protected String getCommandLineArgsString() {
        return this.commandLineArgs;
    }

    protected String getJobSubmissionPolicy() {
        return this.jobSubmissionPolicy;
    }
}

