/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.UTF8ByteArrayUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StreamKeyValUtil {
    public static int findTab(byte[] utf, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            if (utf[i] != 9) continue;
            return i;
        }
        return -1;
    }

    public static int findTab(byte[] utf) {
        return UTF8ByteArrayUtils.findNthByte((byte[])utf, (int)0, (int)utf.length, (byte)9, (int)1);
    }

    public static void splitKeyVal(byte[] utf, int start, int length, Text key, Text val, int splitPos, int separatorLength) throws IOException {
        if (splitPos < start || splitPos >= start + length) {
            throw new IllegalArgumentException("splitPos must be in the range [" + start + ", " + (start + length) + "]: " + splitPos);
        }
        int keyLen = splitPos - start;
        int valLen = start + length - splitPos - separatorLength;
        key.set(utf, start, keyLen);
        val.set(utf, splitPos + separatorLength, valLen);
    }

    public static void splitKeyVal(byte[] utf, int start, int length, Text key, Text val, int splitPos) throws IOException {
        StreamKeyValUtil.splitKeyVal((byte[])utf, (int)start, (int)length, (Text)key, (Text)val, (int)splitPos, (int)1);
    }

    public static void splitKeyVal(byte[] utf, Text key, Text val, int splitPos, int separatorLength) throws IOException {
        StreamKeyValUtil.splitKeyVal((byte[])utf, (int)0, (int)utf.length, (Text)key, (Text)val, (int)splitPos, (int)separatorLength);
    }

    public static void splitKeyVal(byte[] utf, Text key, Text val, int splitPos) throws IOException {
        StreamKeyValUtil.splitKeyVal((byte[])utf, (int)0, (int)utf.length, (Text)key, (Text)val, (int)splitPos, (int)1);
    }

    public static int readLine(LineReader lineReader, Text out) throws IOException {
        out.clear();
        return lineReader.readLine(out);
    }
}

