/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming.io;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.streaming.PipeMapRed;
import org.apache.hadoop.streaming.StreamKeyValUtil;
import org.apache.hadoop.streaming.io.OutputReader;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.UTF8ByteArrayUtils;

public class TextOutputReader
extends OutputReader<Text, Text> {
    private LineReader lineReader;
    private byte[] bytes;
    private DataInput clientIn;
    private Configuration conf;
    private int numKeyFields;
    private byte[] separator;
    private Text key;
    private Text value;
    private Text line;

    public void initialize(PipeMapRed pipeMapRed) throws IOException {
        super.initialize(pipeMapRed);
        this.clientIn = pipeMapRed.getClientInput();
        this.conf = pipeMapRed.getConfiguration();
        this.numKeyFields = pipeMapRed.getNumOfKeyFields();
        this.separator = pipeMapRed.getFieldSeparator();
        this.lineReader = new LineReader((InputStream)((Object)this.clientIn), this.conf);
        this.key = new Text();
        this.value = new Text();
        this.line = new Text();
    }

    public boolean readKeyValue() throws IOException {
        if (this.lineReader.readLine(this.line) <= 0) {
            return false;
        }
        this.bytes = this.line.getBytes();
        this.splitKeyVal(this.bytes, this.line.getLength(), this.key, this.value);
        this.line.clear();
        return true;
    }

    public Text getCurrentKey() throws IOException {
        return this.key;
    }

    public Text getCurrentValue() throws IOException {
        return this.value;
    }

    public String getLastOutput() {
        if (this.bytes != null) {
            try {
                return new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "<undecodable>";
            }
        }
        return null;
    }

    private void splitKeyVal(byte[] line, int length, Text key, Text val) throws IOException {
        int pos = UTF8ByteArrayUtils.findBytes((byte[])line, (int)0, (int)length, (byte[])this.separator);
        for (int k = 1; k < this.numKeyFields && pos != -1; ++k) {
            pos = UTF8ByteArrayUtils.findBytes((byte[])line, (int)(pos + this.separator.length), (int)length, (byte[])this.separator);
        }
        try {
            if (pos == -1) {
                key.set(line, 0, length);
                val.set("");
            } else {
                StreamKeyValUtil.splitKeyVal((byte[])line, (int)0, (int)length, (Text)key, (Text)val, (int)pos, (int)this.separator.length);
            }
        }
        catch (CharacterCodingException e) {
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
    }
}

