/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming.io;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.streaming.PipeMapRed;
import org.apache.hadoop.streaming.io.InputWriter;
import org.apache.hadoop.typedbytes.TypedBytesOutput;
import org.apache.hadoop.typedbytes.TypedBytesWritableOutput;

public class TypedBytesInputWriter
extends InputWriter<Object, Object> {
    private TypedBytesOutput tbOut;
    private TypedBytesWritableOutput tbwOut;

    public void initialize(PipeMapRed pipeMapRed) throws IOException {
        super.initialize(pipeMapRed);
        DataOutput clientOut = pipeMapRed.getClientOutput();
        this.tbOut = new TypedBytesOutput(clientOut);
        this.tbwOut = new TypedBytesWritableOutput(clientOut);
    }

    public void writeKey(Object key) throws IOException {
        this.writeTypedBytes(key);
    }

    public void writeValue(Object value) throws IOException {
        this.writeTypedBytes(value);
    }

    private void writeTypedBytes(Object value) throws IOException {
        if (value instanceof Writable) {
            this.tbwOut.write((Writable)value);
        } else {
            this.tbOut.write(value);
        }
    }
}

