/*
 * Decompiled with CFR 0.152.
 */
package cn.danielw.fop;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Log {
    private static Logger logger = Logger.getLogger("FOP");

    private static String getString(Throwable ex, Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            sb.append(object);
        }
        sb.append(", ");
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        sb.append(writer.toString());
        return sb.toString();
    }

    public static boolean isDebug() {
        return logger.isLoggable(Level.FINE);
    }

    private static String getString(Object ... objects) {
        if (objects.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (Object object : objects) {
                sb.append(object);
            }
            return sb.toString();
        }
        return objects[0].toString();
    }

    public static void debug(Object ... objects) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Log.getString(objects));
        }
    }

    public static void info(Object ... objects) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(Log.getString(objects));
        }
    }

    public static void error(Object ... objects) {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.severe(Log.getString(objects));
        }
    }

    public static void error(Exception ex, Object ... objects) {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.severe(Log.getString(ex, objects));
        }
    }
}

