/*
 * Decompiled with CFR 0.152.
 */
package cn.danielw.fop;

import cn.danielw.fop.Log;
import cn.danielw.fop.ObjectFactory;
import cn.danielw.fop.ObjectPoolPartition;
import cn.danielw.fop.PoolConfig;
import cn.danielw.fop.Poolable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class ObjectPool<T> {
    protected final PoolConfig config;
    protected final ObjectFactory<T> factory;
    protected final ObjectPoolPartition<T>[] partitions;
    private Scavenger scavenger;
    private volatile boolean shuttingDown;

    public ObjectPool(PoolConfig poolConfig, ObjectFactory<T> objectFactory) {
        this.config = poolConfig;
        this.factory = objectFactory;
        this.partitions = new ObjectPoolPartition[this.config.getPartitionSize()];
        try {
            for (int i = 0; i < this.config.getPartitionSize(); ++i) {
                this.partitions[i] = new ObjectPoolPartition<T>(this, i, this.config, objectFactory, this.createBlockingQueue(poolConfig));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.config.getScavengeIntervalMilliseconds() > 0) {
            this.scavenger = new Scavenger();
            this.scavenger.start();
        }
    }

    protected BlockingQueue<Poolable<T>> createBlockingQueue(PoolConfig poolConfig) {
        return new ArrayBlockingQueue<Poolable<T>>(poolConfig.getMaxSize());
    }

    public Poolable<T> borrowObject() {
        return this.borrowObject(true);
    }

    public Poolable<T> borrowObject(boolean blocking) {
        for (int i = 0; i < 3; ++i) {
            Poolable<T> result = this.getObject(blocking);
            if (this.factory.validate(result.getObject())) {
                return result;
            }
            this.partitions[result.getPartition()].decreaseObject(result);
        }
        throw new RuntimeException("Cannot find a valid object");
    }

    private Poolable<T> getObject(boolean blocking) {
        if (this.shuttingDown) {
            throw new IllegalStateException("Your pool is shutting down");
        }
        int partition = (int)(Thread.currentThread().getId() % (long)this.config.getPartitionSize());
        ObjectPoolPartition<T> subPool = this.partitions[partition];
        Poolable<T> freeObject = (Poolable<T>)subPool.getObjectQueue().poll();
        if (freeObject == null) {
            subPool.increaseObjects(1);
            try {
                if (blocking) {
                    freeObject = subPool.getObjectQueue().take();
                } else {
                    freeObject = subPool.getObjectQueue().poll(this.config.getMaxWaitMilliseconds(), TimeUnit.MILLISECONDS);
                    if (freeObject == null) {
                        throw new RuntimeException("Cannot get a free object from the pool");
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        freeObject.setLastAccessTs(System.currentTimeMillis());
        return freeObject;
    }

    public void returnObject(Poolable<T> obj) {
        ObjectPoolPartition<T> subPool = this.partitions[obj.getPartition()];
        try {
            subPool.getObjectQueue().put(obj);
            if (Log.isDebug()) {
                Log.debug("return object: queue size:", subPool.getObjectQueue().size(), ", partition id:", obj.getPartition());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int getSize() {
        int size = 0;
        for (ObjectPoolPartition<T> subPool : this.partitions) {
            size += subPool.getTotalCount();
        }
        return size;
    }

    public synchronized int shutdown() throws InterruptedException {
        this.shuttingDown = true;
        int removed = 0;
        if (this.scavenger != null) {
            this.scavenger.interrupt();
            this.scavenger.join();
        }
        for (ObjectPoolPartition<T> partition : this.partitions) {
            removed += partition.shutdown();
        }
        return removed;
    }

    private class Scavenger
    extends Thread {
        private Scavenger() {
        }

        @Override
        public void run() {
            int partition = 0;
            while (!ObjectPool.this.shuttingDown) {
                try {
                    Thread.sleep(ObjectPool.this.config.getScavengeIntervalMilliseconds());
                    ++partition;
                    Log.debug("scavenge sub pool ", partition %= ObjectPool.this.config.getPartitionSize());
                    ObjectPool.this.partitions[partition].scavenge();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

