/*
 * Decompiled with CFR 0.152.
 */
package cn.danielw.fop;

import cn.danielw.fop.Log;
import cn.danielw.fop.ObjectFactory;
import cn.danielw.fop.ObjectPool;
import cn.danielw.fop.PoolConfig;
import cn.danielw.fop.Poolable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadLocalRandom;

public class ObjectPoolPartition<T> {
    private final ObjectPool<T> pool;
    private final PoolConfig config;
    private final int partition;
    private final BlockingQueue<Poolable<T>> objectQueue;
    private final ObjectFactory<T> objectFactory;
    private int totalCount;

    public ObjectPoolPartition(ObjectPool<T> pool, int partition, PoolConfig config, ObjectFactory<T> objectFactory, BlockingQueue<Poolable<T>> queue) throws InterruptedException {
        this.pool = pool;
        this.config = config;
        this.objectFactory = objectFactory;
        this.partition = partition;
        this.objectQueue = queue;
        for (int i = 0; i < config.getMinSize(); ++i) {
            this.objectQueue.add(new Poolable<T>(objectFactory.create(), pool, partition));
        }
        this.totalCount = config.getMinSize();
    }

    public BlockingQueue<Poolable<T>> getObjectQueue() {
        return this.objectQueue;
    }

    public synchronized int increaseObjects(int delta) {
        if (delta + this.totalCount > this.config.getMaxSize()) {
            delta = this.config.getMaxSize() - this.totalCount;
        }
        try {
            for (int i = 0; i < delta; ++i) {
                this.objectQueue.put(new Poolable<T>(this.objectFactory.create(), this.pool, this.partition));
            }
            this.totalCount += delta;
            if (Log.isDebug()) {
                Log.debug("increase objects: count=", this.totalCount, ", queue size=", this.objectQueue.size());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return delta;
    }

    public synchronized boolean decreaseObject(Poolable<T> obj) {
        this.objectFactory.destroy(obj.getObject());
        --this.totalCount;
        return true;
    }

    public synchronized int getTotalCount() {
        return this.totalCount;
    }

    public synchronized void scavenge() throws InterruptedException {
        Poolable obj;
        int delta = this.totalCount - this.config.getMinSize();
        if (delta <= 0) {
            return;
        }
        int removed = 0;
        long now = System.currentTimeMillis();
        while (delta-- > 0 && (obj = (Poolable)this.objectQueue.poll()) != null) {
            if (Log.isDebug()) {
                Log.debug("obj=", obj, ", now-last=", now - obj.getLastAccessTs(), ", max idle=", this.config.getMaxIdleMilliseconds());
            }
            if (now - obj.getLastAccessTs() > (long)this.config.getMaxIdleMilliseconds() && ThreadLocalRandom.current().nextDouble(1.0) < this.config.getScavengeRatio()) {
                this.decreaseObject(obj);
                ++removed;
                continue;
            }
            this.objectQueue.put(obj);
        }
        if (removed > 0) {
            Log.debug(removed, " objects were scavenged.");
        }
    }

    public synchronized int shutdown() {
        int removed = 0;
        while (this.totalCount > 0) {
            Poolable obj = (Poolable)this.objectQueue.poll();
            if (obj == null) continue;
            this.decreaseObject(obj);
            ++removed;
        }
        return removed;
    }
}

