/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.stp;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.annotation.SaCheckDisable;
import cn.dev33.satoken.annotation.SaCheckLogin;
import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaCheckSafe;
import cn.dev33.satoken.annotation.SaMode;
import cn.dev33.satoken.config.SaCookieConfig;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaCookie;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.context.model.SaStorage;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.exception.ApiDisabledException;
import cn.dev33.satoken.exception.DisableServiceException;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.dev33.satoken.exception.NotSafeException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.fun.SaFunction;
import cn.dev33.satoken.listener.SaTokenEventCenter;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.session.TokenSign;
import cn.dev33.satoken.stp.SaLoginModel;
import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaValue2Box;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class StpLogic {
    public String loginType;
    private SaTokenConfig config;

    public StpLogic(String loginType) {
        this.setLoginType(loginType);
    }

    public String getLoginType() {
        return this.loginType;
    }

    public StpLogic setLoginType(String loginType) {
        if (SaFoxUtil.isNotEmpty(this.loginType)) {
            SaManager.removeStpLogic(this.loginType);
        }
        this.loginType = loginType;
        SaManager.putStpLogic(this);
        return this;
    }

    public StpLogic setConfig(SaTokenConfig config) {
        this.config = config;
        return this;
    }

    public SaTokenConfig getConfig() {
        return this.config;
    }

    public SaTokenConfig getConfigOrGlobal() {
        SaTokenConfig cfg = this.getConfig();
        if (cfg != null) {
            return cfg;
        }
        return SaManager.getConfig();
    }

    public String getTokenName() {
        return this.splicingKeyTokenName();
    }

    public String createTokenValue(Object loginId, String device, long timeout, Map<String, Object> extraData) {
        return (String)SaStrategy.instance.createToken.apply(loginId, this.loginType);
    }

    public void setTokenValue(String tokenValue) {
        this.setTokenValue(tokenValue, new SaLoginModel().setTimeout(this.getConfigOrGlobal().getTimeout()));
    }

    public void setTokenValue(String tokenValue, int cookieTimeout) {
        this.setTokenValue(tokenValue, new SaLoginModel().setTimeout(cookieTimeout));
    }

    public void setTokenValue(String tokenValue, SaLoginModel loginModel) {
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return;
        }
        this.setTokenValueToStorage(tokenValue);
        if (this.getConfigOrGlobal().getIsReadCookie().booleanValue()) {
            this.setTokenValueToCookie(tokenValue, loginModel.getCookieTimeout());
        }
        if (loginModel.getIsWriteHeaderOrGlobalConfig().booleanValue()) {
            this.setTokenValueToResponseHeader(tokenValue);
        }
    }

    public void setTokenValueToStorage(String tokenValue) {
        SaStorage storage = SaHolder.getStorage();
        String tokenPrefix = this.getConfigOrGlobal().getTokenPrefix();
        if (SaFoxUtil.isEmpty(tokenPrefix)) {
            storage.set(this.splicingKeyJustCreatedSave(), tokenValue);
        } else {
            storage.set(this.splicingKeyJustCreatedSave(), tokenPrefix + " " + tokenValue);
        }
        storage.set("JUST_CREATED_NOT_PREFIX_", tokenValue);
    }

    public void setTokenValueToCookie(String tokenValue, int cookieTimeout) {
        SaCookieConfig cfg = this.getConfigOrGlobal().getCookie();
        SaCookie cookie = new SaCookie().setName(this.getTokenName()).setValue(tokenValue).setMaxAge(cookieTimeout).setDomain(cfg.getDomain()).setPath(cfg.getPath()).setSecure(cfg.getSecure()).setHttpOnly(cfg.getHttpOnly()).setSameSite(cfg.getSameSite());
        SaHolder.getResponse().addCookie(cookie);
    }

    public void setTokenValueToResponseHeader(String tokenValue) {
        String tokenName = this.getTokenName();
        SaResponse response = SaHolder.getResponse();
        response.setHeader(tokenName, tokenValue);
        response.addHeader("Access-Control-Expose-Headers", tokenName);
    }

    public String getTokenValue() {
        return this.getTokenValue(false);
    }

    public String getTokenValue(boolean noPrefixThrowException) {
        String tokenValue = this.getTokenValueNotCut();
        String tokenPrefix = this.getConfigOrGlobal().getTokenPrefix();
        if (SaFoxUtil.isNotEmpty(tokenPrefix)) {
            if (SaFoxUtil.isEmpty(tokenValue)) {
                tokenValue = null;
            } else if (!tokenValue.startsWith(tokenPrefix + " ")) {
                if (noPrefixThrowException) {
                    throw NotLoginException.newInstance(this.loginType, "-7", "\u672a\u6309\u7167\u6307\u5b9a\u524d\u7f00\u63d0\u4ea4 token\uff0cprefix=" + tokenPrefix, null).setCode(11017);
                }
                tokenValue = null;
            } else {
                tokenValue = tokenValue.substring(tokenPrefix.length() + " ".length());
            }
        }
        return tokenValue;
    }

    public String getTokenValueNotCut() {
        SaStorage storage = SaHolder.getStorage();
        SaRequest request = SaHolder.getRequest();
        SaTokenConfig config = this.getConfigOrGlobal();
        String keyTokenName = this.getTokenName();
        String tokenValue = null;
        if (storage.get(this.splicingKeyJustCreatedSave()) != null) {
            tokenValue = String.valueOf(storage.get(this.splicingKeyJustCreatedSave()));
        }
        if (tokenValue == null && config.getIsReadBody().booleanValue()) {
            tokenValue = request.getParam(keyTokenName);
        }
        if (tokenValue == null && config.getIsReadHeader().booleanValue()) {
            tokenValue = request.getHeader(keyTokenName);
        }
        if (tokenValue == null && config.getIsReadCookie().booleanValue()) {
            tokenValue = request.getCookieValue(keyTokenName);
        }
        return tokenValue;
    }

    public String getTokenValueNotNull() {
        String tokenValue = this.getTokenValue(true);
        if (SaFoxUtil.isEmpty(tokenValue)) {
            throw NotLoginException.newInstance(this.loginType, "-1", "\u672a\u80fd\u8bfb\u53d6\u5230\u6709\u6548 token", null).setCode(11001);
        }
        return tokenValue;
    }

    public SaTokenInfo getTokenInfo() {
        SaTokenInfo info = new SaTokenInfo();
        info.tokenName = this.getTokenName();
        info.tokenValue = this.getTokenValue();
        info.isLogin = this.isLogin();
        info.loginId = this.getLoginIdDefaultNull();
        info.loginType = this.getLoginType();
        info.tokenTimeout = this.getTokenTimeout();
        info.sessionTimeout = this.getSessionTimeout();
        info.tokenSessionTimeout = this.getTokenSessionTimeout();
        info.tokenActiveTimeout = this.getTokenActiveTimeout();
        info.loginDevice = this.getLoginDevice();
        return info;
    }

    public void login(Object id) {
        this.login(id, new SaLoginModel());
    }

    public void login(Object id, String device) {
        this.login(id, new SaLoginModel().setDevice(device));
    }

    public void login(Object id, boolean isLastingCookie) {
        this.login(id, new SaLoginModel().setIsLastingCookie(isLastingCookie));
    }

    public void login(Object id, long timeout) {
        this.login(id, new SaLoginModel().setTimeout(timeout));
    }

    public void login(Object id, SaLoginModel loginModel) {
        String token = this.createLoginSession(id, loginModel);
        this.setTokenValue(token, loginModel);
    }

    public String createLoginSession(Object id) {
        return this.createLoginSession(id, new SaLoginModel());
    }

    public String createLoginSession(Object id, SaLoginModel loginModel) {
        this.checkLoginArgs(id, loginModel);
        SaTokenConfig config = this.getConfigOrGlobal();
        loginModel.build(config);
        String tokenValue = this.distUsableToken(id, loginModel);
        SaSession session = this.getSessionByLoginId(id, true);
        session.updateMinTimeout(loginModel.getTimeout());
        TokenSign tokenSign = new TokenSign(tokenValue, loginModel.getDeviceOrDefault(), loginModel.getTokenSignTag());
        session.addTokenSign(tokenSign);
        this.saveTokenToIdMapping(tokenValue, id, loginModel.getTimeout());
        if (this.isOpenCheckActiveTimeout()) {
            this.setLastActiveToNow(tokenValue, loginModel.getActiveTimeout(), loginModel.getTimeoutOrGlobalConfig());
        }
        SaTokenEventCenter.doLogin(this.loginType, id, tokenValue, loginModel);
        if (config.getMaxLoginCount() != -1) {
            this.logoutByMaxLoginCount(id, session, null, config.getMaxLoginCount());
        }
        return tokenValue;
    }

    protected String distUsableToken(Object id, SaLoginModel loginModel) {
        String tokenValue2;
        Boolean isConcurrent = this.getConfigOrGlobal().getIsConcurrent();
        if (!isConcurrent.booleanValue()) {
            this.replaced(id, loginModel.getDevice());
        }
        if (SaFoxUtil.isNotEmpty(loginModel.getToken())) {
            return loginModel.getToken();
        }
        if (isConcurrent.booleanValue() && this.getConfigOfIsShare() && SaFoxUtil.isNotEmpty(tokenValue2 = this.getTokenValueByLoginId(id, loginModel.getDeviceOrDefault()))) {
            return tokenValue2;
        }
        return SaStrategy.instance.generateUniqueToken.execute("token", this.getConfigOfMaxTryTimes(), () -> this.createTokenValue(id, loginModel.getDeviceOrDefault(), loginModel.getTimeout(), loginModel.getExtraData()), tokenValue -> this.getLoginIdNotHandle((String)tokenValue) == null);
    }

    protected void checkLoginArgs(Object id, SaLoginModel loginModel) {
        Map<String, Object> extraData;
        if (SaFoxUtil.isEmpty(id)) {
            throw new SaTokenException("loginId \u4e0d\u80fd\u4e3a\u7a7a").setCode(11002);
        }
        if (NotLoginException.ABNORMAL_LIST.contains(id.toString())) {
            throw new SaTokenException("loginId \u4e0d\u80fd\u4e3a\u4ee5\u4e0b\u503c\uff1a" + NotLoginException.ABNORMAL_LIST);
        }
        if (!SaFoxUtil.isBasicType(id.getClass())) {
            SaManager.log.warn("loginId \u5e94\u8be5\u4e3a\u7b80\u5355\u7c7b\u578b\uff0c\u4f8b\u5982\uff1aString | int | long\uff0c\u4e0d\u63a8\u8350\u4f7f\u7528\u590d\u6742\u7c7b\u578b\uff1a" + id.getClass(), new Object[0]);
        }
        if (!this.isSupportExtra() && (extraData = loginModel.getExtraData()) != null && extraData.size() > 0) {
            SaManager.log.warn("\u5f53\u524d StpLogic \u4e0d\u652f\u6301 extra \u6269\u5c55\u53c2\u6570\u6a21\u5f0f\uff0c\u4f20\u5165\u7684 extra \u53c2\u6570\u5c06\u88ab\u5ffd\u7565", new Object[0]);
        }
        if (!this.getConfigOrGlobal().getDynamicActiveTimeout().booleanValue() && loginModel.getActiveTimeout() != null) {
            SaManager.log.warn("\u5f53\u524d\u5168\u5c40\u914d\u7f6e\u672a\u5f00\u542f\u52a8\u6001 activeTimeout \u529f\u80fd\uff0c\u4f20\u5165\u7684 activeTimeout \u53c2\u6570\u5c06\u88ab\u5ffd\u7565", new Object[0]);
        }
    }

    public void logout() {
        String tokenValue = this.getTokenValue();
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return;
        }
        if (this.getConfigOrGlobal().getIsReadCookie().booleanValue()) {
            SaCookieConfig cfg = this.getConfigOrGlobal().getCookie();
            SaCookie cookie = new SaCookie().setName(this.getTokenName()).setValue(null).setMaxAge(0).setDomain(cfg.getDomain()).setPath(cfg.getPath()).setSecure(cfg.getSecure()).setHttpOnly(cfg.getHttpOnly()).setSameSite(cfg.getSameSite());
            SaHolder.getResponse().addCookie(cookie);
        }
        SaStorage storage = SaHolder.getStorage();
        storage.delete(this.splicingKeyJustCreatedSave());
        storage.delete("TOKEN_ACTIVE_TIMEOUT_CHECKED_KEY_");
        this.logoutByTokenValue(tokenValue);
    }

    public void logout(Object loginId) {
        this.logout(loginId, null);
    }

    public void logout(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session != null) {
            for (TokenSign tokenSign : session.getTokenSignListByDevice(device)) {
                String tokenValue = tokenSign.getValue();
                session.removeTokenSign(tokenValue);
                if (this.isOpenCheckActiveTimeout()) {
                    this.clearLastActive(tokenValue);
                }
                this.deleteTokenToIdMapping(tokenValue);
                this.deleteTokenSession(tokenValue);
                SaTokenEventCenter.doLogout(this.loginType, loginId, tokenValue);
            }
            session.logoutByTokenSignCountToZero();
        }
    }

    public void logoutByMaxLoginCount(Object loginId, SaSession session, String device, int maxLoginCount) {
        if (session == null && (session = this.getSessionByLoginId(loginId, false)) == null) {
            return;
        }
        List<TokenSign> list = session.getTokenSignListByDevice(device);
        for (int i = 0; i < list.size() - maxLoginCount; ++i) {
            String tokenValue = list.get(i).getValue();
            session.removeTokenSign(tokenValue);
            if (this.isOpenCheckActiveTimeout()) {
                this.clearLastActive(tokenValue);
            }
            this.deleteTokenToIdMapping(tokenValue);
            this.deleteTokenSession(tokenValue);
            SaTokenEventCenter.doLogout(this.loginType, loginId, tokenValue);
        }
        session.logoutByTokenSignCountToZero();
    }

    public void logoutByTokenValue(String tokenValue) {
        if (this.isOpenCheckActiveTimeout()) {
            this.clearLastActive(tokenValue);
        }
        this.deleteTokenSession(tokenValue);
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (loginId != null) {
            this.deleteTokenToIdMapping(tokenValue);
        }
        if (!this.isValidLoginId(loginId)) {
            return;
        }
        SaTokenEventCenter.doLogout(this.loginType, loginId, tokenValue);
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session != null) {
            session.removeTokenSign(tokenValue);
            session.logoutByTokenSignCountToZero();
        }
    }

    public void kickout(Object loginId) {
        this.kickout(loginId, null);
    }

    public void kickout(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session != null) {
            for (TokenSign tokenSign : session.getTokenSignListByDevice(device)) {
                String tokenValue = tokenSign.getValue();
                session.removeTokenSign(tokenValue);
                if (this.isOpenCheckActiveTimeout()) {
                    this.clearLastActive(tokenValue);
                }
                this.updateTokenToIdMapping(tokenValue, "-5");
                SaTokenEventCenter.doKickout(this.loginType, loginId, tokenValue);
            }
            session.logoutByTokenSignCountToZero();
        }
    }

    public void kickoutByTokenValue(String tokenValue) {
        String loginId;
        if (this.isOpenCheckActiveTimeout()) {
            this.clearLastActive(tokenValue);
        }
        if (!this.isValidLoginId(loginId = this.getLoginIdNotHandle(tokenValue))) {
            return;
        }
        this.updateTokenToIdMapping(tokenValue, "-5");
        SaTokenEventCenter.doKickout(this.loginType, loginId, tokenValue);
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session != null) {
            session.removeTokenSign(tokenValue);
            session.logoutByTokenSignCountToZero();
        }
    }

    public void replaced(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session != null) {
            for (TokenSign tokenSign : session.getTokenSignListByDevice(device)) {
                String tokenValue = tokenSign.getValue();
                session.removeTokenSign(tokenValue);
                if (this.isOpenCheckActiveTimeout()) {
                    this.clearLastActive(tokenValue);
                }
                this.updateTokenToIdMapping(tokenValue, "-4");
                SaTokenEventCenter.doReplaced(this.loginType, loginId, tokenValue);
            }
        }
    }

    public boolean isLogin() {
        return this.getLoginIdDefaultNull() != null;
    }

    public boolean isLogin(Object loginId) {
        return this.getTokenSignListByLoginId(loginId, null).size() > 0;
    }

    public void checkLogin() {
        this.getLoginId();
    }

    public Object getLoginId() {
        if (this.isSwitch()) {
            return this.getSwitchLoginId();
        }
        String tokenValue = this.getTokenValue(true);
        if (SaFoxUtil.isEmpty(tokenValue)) {
            throw NotLoginException.newInstance(this.loginType, "-1", "\u672a\u80fd\u8bfb\u53d6\u5230\u6709\u6548 token", null).setCode(11011);
        }
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (SaFoxUtil.isEmpty(loginId)) {
            throw NotLoginException.newInstance(this.loginType, "-2", "token \u65e0\u6548", tokenValue).setCode(11012);
        }
        if (loginId.equals("-3")) {
            throw NotLoginException.newInstance(this.loginType, "-3", "token \u5df2\u8fc7\u671f", tokenValue).setCode(11013);
        }
        if (loginId.equals("-4")) {
            throw NotLoginException.newInstance(this.loginType, "-4", "token \u5df2\u88ab\u9876\u4e0b\u7ebf", tokenValue).setCode(11014);
        }
        if (loginId.equals("-5")) {
            throw NotLoginException.newInstance(this.loginType, "-5", "token \u5df2\u88ab\u8e22\u4e0b\u7ebf", tokenValue).setCode(11015);
        }
        if (this.isOpenCheckActiveTimeout()) {
            this.checkActiveTimeout(tokenValue);
            if (this.getConfigOrGlobal().getAutoRenew().booleanValue()) {
                this.updateLastActiveToNow(tokenValue);
            }
        }
        return loginId;
    }

    public <T> T getLoginId(T defaultValue) {
        Object loginId = this.getLoginIdDefaultNull();
        if (loginId == null) {
            return defaultValue;
        }
        return (T)SaFoxUtil.getValueByType(loginId, defaultValue.getClass());
    }

    public Object getLoginIdDefaultNull() {
        if (this.isSwitch()) {
            return this.getSwitchLoginId();
        }
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (!this.isValidLoginId(loginId)) {
            return null;
        }
        if (this.getTokenActiveTimeoutByToken(tokenValue) == -2L) {
            return null;
        }
        return loginId;
    }

    public String getLoginIdAsString() {
        return String.valueOf(this.getLoginId());
    }

    public int getLoginIdAsInt() {
        return Integer.parseInt(String.valueOf(this.getLoginId()));
    }

    public long getLoginIdAsLong() {
        return Long.parseLong(String.valueOf(this.getLoginId()));
    }

    public Object getLoginIdByToken(String tokenValue) {
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return null;
        }
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (!this.isValidLoginId(loginId)) {
            return null;
        }
        return loginId;
    }

    public String getLoginIdNotHandle(String tokenValue) {
        return this.getSaTokenDao().get(this.splicingKeyTokenValue(tokenValue));
    }

    public Object getExtra(String key) {
        throw new ApiDisabledException("\u53ea\u6709\u5728\u96c6\u6210 sa-token-jwt \u63d2\u4ef6\u540e\u624d\u53ef\u4ee5\u4f7f\u7528 extra \u6269\u5c55\u53c2\u6570").setCode(11031);
    }

    public Object getExtra(String tokenValue, String key) {
        throw new ApiDisabledException("\u53ea\u6709\u5728\u96c6\u6210 sa-token-jwt \u63d2\u4ef6\u540e\u624d\u53ef\u4ee5\u4f7f\u7528 extra \u6269\u5c55\u53c2\u6570").setCode(11031);
    }

    public boolean isValidLoginId(Object loginId) {
        return SaFoxUtil.isNotEmpty(loginId) && !NotLoginException.ABNORMAL_LIST.contains(loginId.toString());
    }

    public void saveTokenToIdMapping(String tokenValue, Object loginId, long timeout) {
        this.getSaTokenDao().set(this.splicingKeyTokenValue(tokenValue), String.valueOf(loginId), timeout);
    }

    public void updateTokenToIdMapping(String tokenValue, Object loginId) {
        SaTokenException.throwBy(SaFoxUtil.isEmpty(loginId), "loginId \u4e0d\u80fd\u4e3a\u7a7a", 11003);
        this.getSaTokenDao().update(this.splicingKeyTokenValue(tokenValue), loginId.toString());
    }

    public void deleteTokenToIdMapping(String tokenValue) {
        this.getSaTokenDao().delete(this.splicingKeyTokenValue(tokenValue));
    }

    public SaSession getSessionBySessionId(String sessionId, boolean isCreate, Consumer<SaSession> appendOperation) {
        SaSession session = this.getSaTokenDao().getSession(sessionId);
        if (session == null && isCreate) {
            session = (SaSession)SaStrategy.instance.createSession.apply(sessionId);
            if (appendOperation != null) {
                appendOperation.accept(session);
            }
            this.getSaTokenDao().setSession(session, this.getConfigOrGlobal().getTimeout());
        }
        return session;
    }

    public SaSession getSessionBySessionId(String sessionId) {
        return this.getSessionBySessionId(sessionId, false, null);
    }

    public SaSession getSessionByLoginId(Object loginId, boolean isCreate) {
        return this.getSessionBySessionId(this.splicingKeySession(loginId), isCreate, session -> {
            session.setType("Account-Session");
            session.setLoginType(this.getLoginType());
            session.setLoginId(loginId);
        });
    }

    public SaSession getSessionByLoginId(Object loginId) {
        return this.getSessionByLoginId(loginId, true);
    }

    public SaSession getSession(boolean isCreate) {
        return this.getSessionByLoginId(this.getLoginId(), isCreate);
    }

    public SaSession getSession() {
        return this.getSession(true);
    }

    public SaSession getTokenSessionByToken(String tokenValue, boolean isCreate) {
        return this.getSessionBySessionId(this.splicingKeyTokenSession(tokenValue), isCreate, session -> {
            session.setType("Token-Session");
            session.setLoginType(this.getLoginType());
            session.setToken(tokenValue);
        });
    }

    public SaSession getTokenSessionByToken(String tokenValue) {
        return this.getTokenSessionByToken(tokenValue, true);
    }

    public SaSession getTokenSession(boolean isCreate) {
        String tokenValue;
        if (this.getConfigOrGlobal().getTokenSessionCheckLogin().booleanValue()) {
            this.checkLogin();
        }
        if (SaFoxUtil.isEmpty(tokenValue = this.getTokenValue())) {
            return null;
        }
        return this.getTokenSessionByToken(tokenValue, isCreate);
    }

    public SaSession getTokenSession() {
        return this.getTokenSession(true);
    }

    public SaSession getAnonTokenSession(boolean isCreate) {
        String tokenValue = this.getTokenValue();
        if (SaFoxUtil.isNotEmpty(tokenValue)) {
            SaSession session = this.getTokenSessionByToken(tokenValue, false);
            if (session != null) {
                return session;
            }
            String loginId = this.getLoginIdNotHandle(tokenValue);
            if (this.isValidLoginId(loginId)) {
                return this.getTokenSessionByToken(tokenValue, isCreate);
            }
        }
        if (isCreate) {
            tokenValue = SaStrategy.instance.generateUniqueToken.execute("token", this.getConfigOfMaxTryTimes(), () -> this.createTokenValue(null, null, this.getConfigOrGlobal().getTimeout(), null), token -> this.getTokenSessionByToken((String)token, false) == null);
            if (this.isOpenCheckActiveTimeout()) {
                this.setLastActiveToNow(tokenValue, null, null);
            }
            this.setTokenValue(tokenValue);
            return this.getTokenSessionByToken(tokenValue, isCreate);
        }
        return null;
    }

    public SaSession getAnonTokenSession() {
        return this.getAnonTokenSession(true);
    }

    public void deleteTokenSession(String tokenValue) {
        this.getSaTokenDao().delete(this.splicingKeyTokenSession(tokenValue));
    }

    protected void setLastActiveToNow(String tokenValue, Long activeTimeout, Long timeout) {
        SaTokenConfig config = this.getConfigOrGlobal();
        if (timeout == null) {
            timeout = config.getTimeout();
        }
        String key = this.splicingKeyLastActiveTime(tokenValue);
        String value = String.valueOf(System.currentTimeMillis());
        if (config.getDynamicActiveTimeout().booleanValue() && activeTimeout != null) {
            value = value + "," + activeTimeout;
        }
        this.getSaTokenDao().set(key, value, timeout);
    }

    public void updateLastActiveToNow(String tokenValue) {
        String key = this.splicingKeyLastActiveTime(tokenValue);
        String value = new SaValue2Box(System.currentTimeMillis(), this.getTokenUseActiveTimeout(tokenValue)).toString();
        this.getSaTokenDao().update(key, value);
    }

    public void updateLastActiveToNow() {
        this.updateLastActiveToNow(this.getTokenValue());
    }

    protected void clearLastActive(String tokenValue) {
        this.getSaTokenDao().delete(this.splicingKeyLastActiveTime(tokenValue));
    }

    public void checkActiveTimeout(String tokenValue) {
        SaStorage storage = SaHolder.getStorage();
        storage.get("TOKEN_ACTIVE_TIMEOUT_CHECKED_KEY_", () -> {
            long activeTimeout = this.getTokenActiveTimeoutByToken(tokenValue);
            if (activeTimeout == -1L) {
                return true;
            }
            if (activeTimeout == -2L) {
                throw NotLoginException.newInstance(this.loginType, "-6", "token \u5df2\u88ab\u51bb\u7ed3", tokenValue).setCode(11016);
            }
            return true;
        });
    }

    public void checkActiveTimeout() {
        this.checkActiveTimeout(this.getTokenValue());
    }

    public Long getTokenUseActiveTimeout(String tokenValue) {
        if (!this.getConfigOrGlobal().getDynamicActiveTimeout().booleanValue()) {
            return null;
        }
        String key = this.splicingKeyLastActiveTime(tokenValue);
        String value = this.getSaTokenDao().get(key);
        SaValue2Box box = new SaValue2Box(value);
        return box.getValue2AsLong(null);
    }

    public long getTokenUseActiveTimeoutOrGlobalConfig(String tokenValue) {
        Long activeTimeout = this.getTokenUseActiveTimeout(tokenValue);
        if (activeTimeout == null) {
            return this.getConfigOrGlobal().getActiveTimeout();
        }
        return activeTimeout;
    }

    public long getTokenTimeout() {
        return this.getTokenTimeout(this.getTokenValue());
    }

    public long getTokenTimeout(String token) {
        return this.getSaTokenDao().getTimeout(this.splicingKeyTokenValue(token));
    }

    public long getTokenTimeoutByLoginId(Object loginId) {
        return this.getSaTokenDao().getTimeout(this.splicingKeyTokenValue(this.getTokenValueByLoginId(loginId)));
    }

    public long getSessionTimeout() {
        return this.getSessionTimeoutByLoginId(this.getLoginIdDefaultNull());
    }

    public long getSessionTimeoutByLoginId(Object loginId) {
        return this.getSaTokenDao().getSessionTimeout(this.splicingKeySession(loginId));
    }

    public long getTokenSessionTimeout() {
        return this.getTokenSessionTimeoutByTokenValue(this.getTokenValue());
    }

    public long getTokenSessionTimeoutByTokenValue(String tokenValue) {
        return this.getSaTokenDao().getSessionTimeout(this.splicingKeyTokenSession(tokenValue));
    }

    public long getTokenActiveTimeout() {
        return this.getTokenActiveTimeoutByToken(this.getTokenValue());
    }

    public long getTokenActiveTimeoutByToken(String tokenValue) {
        if (!this.isOpenCheckActiveTimeout()) {
            return -1L;
        }
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return -2L;
        }
        String key = this.splicingKeyLastActiveTime(tokenValue);
        String lastActiveTimeString = this.getSaTokenDao().get(key);
        if (lastActiveTimeString == null) {
            return -2L;
        }
        SaValue2Box box = new SaValue2Box(lastActiveTimeString);
        long lastActiveTime = box.getValue1AsLong();
        long timeDiff = (System.currentTimeMillis() - lastActiveTime) / 1000L;
        long allowTimeDiff = this.getTokenUseActiveTimeoutOrGlobalConfig(tokenValue);
        if (allowTimeDiff == -1L) {
            return -1L;
        }
        long activeTimeout = allowTimeDiff - timeDiff;
        if (activeTimeout < 0L) {
            return -2L;
        }
        return activeTimeout;
    }

    public void renewTimeout(long timeout) {
        String tokenValue = this.getTokenValue();
        this.renewTimeout(tokenValue, timeout);
        if (this.getConfigOrGlobal().getIsReadCookie().booleanValue()) {
            if (timeout == -1L || timeout > Integer.MAX_VALUE) {
                timeout = Integer.MAX_VALUE;
            }
            this.setTokenValueToCookie(tokenValue, (int)timeout);
        }
    }

    public void renewTimeout(String tokenValue, long timeout) {
        Object loginId = this.getLoginIdByToken(tokenValue);
        if (loginId == null) {
            return;
        }
        SaTokenDao dao = this.getSaTokenDao();
        dao.updateTimeout(this.splicingKeyTokenValue(tokenValue), timeout);
        SaSession tokenSession = this.getTokenSessionByToken(tokenValue, false);
        if (tokenSession != null) {
            tokenSession.updateTimeout(timeout);
        }
        this.getSessionByLoginId(loginId).updateMinTimeout(timeout);
        if (this.isOpenCheckActiveTimeout()) {
            dao.updateTimeout(this.splicingKeyLastActiveTime(tokenValue), timeout);
        }
        SaTokenEventCenter.doRenewTimeout(tokenValue, loginId, timeout);
    }

    public List<String> getRoleList() {
        try {
            return this.getRoleList(this.getLoginId());
        }
        catch (NotLoginException e) {
            return SaFoxUtil.emptyList();
        }
    }

    public List<String> getRoleList(Object loginId) {
        return SaManager.getStpInterface().getRoleList(loginId, this.loginType);
    }

    public boolean hasRole(String role) {
        return this.hasElement(this.getRoleList(), role);
    }

    public boolean hasRole(Object loginId, String role) {
        return this.hasElement(this.getRoleList(loginId), role);
    }

    public boolean hasRoleAnd(String ... roleArray) {
        try {
            this.checkRoleAnd(roleArray);
            return true;
        }
        catch (NotLoginException | NotRoleException e) {
            return false;
        }
    }

    public boolean hasRoleOr(String ... roleArray) {
        try {
            this.checkRoleOr(roleArray);
            return true;
        }
        catch (NotLoginException | NotRoleException e) {
            return false;
        }
    }

    public void checkRole(String role) {
        if (!this.hasRole(role)) {
            throw new NotRoleException(role, this.loginType).setCode(11041);
        }
    }

    public void checkRoleAnd(String ... roleArray) {
        Object loginId = this.getLoginId();
        if (roleArray == null || roleArray.length == 0) {
            return;
        }
        List<String> roleList = this.getRoleList(loginId);
        for (String role : roleArray) {
            if (this.hasElement(roleList, role)) continue;
            throw new NotRoleException(role, this.loginType).setCode(11041);
        }
    }

    public void checkRoleOr(String ... roleArray) {
        Object loginId = this.getLoginId();
        if (roleArray == null || roleArray.length == 0) {
            return;
        }
        List<String> roleList = this.getRoleList(loginId);
        for (String role : roleArray) {
            if (!this.hasElement(roleList, role)) continue;
            return;
        }
        throw new NotRoleException(roleArray[0], this.loginType).setCode(11041);
    }

    public List<String> getPermissionList() {
        try {
            return this.getPermissionList(this.getLoginId());
        }
        catch (NotLoginException e) {
            return SaFoxUtil.emptyList();
        }
    }

    public List<String> getPermissionList(Object loginId) {
        return SaManager.getStpInterface().getPermissionList(loginId, this.loginType);
    }

    public boolean hasPermission(String permission) {
        return this.hasElement(this.getPermissionList(), permission);
    }

    public boolean hasPermission(Object loginId, String permission) {
        return this.hasElement(this.getPermissionList(loginId), permission);
    }

    public boolean hasPermissionAnd(String ... permissionArray) {
        try {
            this.checkPermissionAnd(permissionArray);
            return true;
        }
        catch (NotLoginException | NotPermissionException e) {
            return false;
        }
    }

    public boolean hasPermissionOr(String ... permissionArray) {
        try {
            this.checkPermissionOr(permissionArray);
            return true;
        }
        catch (NotLoginException | NotPermissionException e) {
            return false;
        }
    }

    public void checkPermission(String permission) {
        if (!this.hasPermission(permission)) {
            throw new NotPermissionException(permission, this.loginType).setCode(11051);
        }
    }

    public void checkPermissionAnd(String ... permissionArray) {
        Object loginId = this.getLoginId();
        if (permissionArray == null || permissionArray.length == 0) {
            return;
        }
        List<String> permissionList = this.getPermissionList(loginId);
        for (String permission : permissionArray) {
            if (this.hasElement(permissionList, permission)) continue;
            throw new NotPermissionException(permission, this.loginType).setCode(11051);
        }
    }

    public void checkPermissionOr(String ... permissionArray) {
        Object loginId = this.getLoginId();
        if (permissionArray == null || permissionArray.length == 0) {
            return;
        }
        List<String> permissionList = this.getPermissionList(loginId);
        for (String permission : permissionArray) {
            if (!this.hasElement(permissionList, permission)) continue;
            return;
        }
        throw new NotPermissionException(permissionArray[0], this.loginType).setCode(11051);
    }

    public String getTokenValueByLoginId(Object loginId) {
        return this.getTokenValueByLoginId(loginId, null);
    }

    public String getTokenValueByLoginId(Object loginId, String device) {
        List<String> tokenValueList = this.getTokenValueListByLoginId(loginId, device);
        return tokenValueList.size() == 0 ? null : tokenValueList.get(tokenValueList.size() - 1);
    }

    public List<String> getTokenValueListByLoginId(Object loginId) {
        return this.getTokenValueListByLoginId(loginId, null);
    }

    public List<String> getTokenValueListByLoginId(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session == null) {
            return Collections.emptyList();
        }
        return session.getTokenValueListByDevice(device);
    }

    public List<TokenSign> getTokenSignListByLoginId(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session == null) {
            return Collections.emptyList();
        }
        return session.getTokenSignListByDevice(device);
    }

    public String getLoginDevice() {
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        if (!this.isLogin()) {
            return null;
        }
        SaSession session = this.getSessionByLoginId(this.getLoginIdDefaultNull(), false);
        if (session == null) {
            return null;
        }
        List<TokenSign> tokenSignList = session.tokenSignListCopy();
        for (TokenSign tokenSign : tokenSignList) {
            if (!tokenSign.getValue().equals(tokenValue)) continue;
            return tokenSign.getDevice();
        }
        return null;
    }

    public List<String> searchTokenValue(String keyword, int start, int size, boolean sortType) {
        return this.getSaTokenDao().searchData(this.splicingKeyTokenValue(""), keyword, start, size, sortType);
    }

    public List<String> searchSessionId(String keyword, int start, int size, boolean sortType) {
        return this.getSaTokenDao().searchData(this.splicingKeySession(""), keyword, start, size, sortType);
    }

    public List<String> searchTokenSessionId(String keyword, int start, int size, boolean sortType) {
        return this.getSaTokenDao().searchData(this.splicingKeyTokenSession(""), keyword, start, size, sortType);
    }

    public void checkByAnnotation(SaCheckLogin at) {
        this.checkLogin();
    }

    public void checkByAnnotation(SaCheckRole at) {
        String[] roleArray = at.value();
        if (at.mode() == SaMode.AND) {
            this.checkRoleAnd(roleArray);
        } else {
            this.checkRoleOr(roleArray);
        }
    }

    public void checkByAnnotation(SaCheckPermission at) {
        String[] permissionArray = at.value();
        try {
            if (at.mode() == SaMode.AND) {
                this.checkPermissionAnd(permissionArray);
            } else {
                this.checkPermissionOr(permissionArray);
            }
        }
        catch (NotPermissionException e) {
            for (String role : at.orRole()) {
                String[] rArr = SaFoxUtil.convertStringToArray(role);
                if (!this.hasRoleAnd(rArr)) continue;
                return;
            }
            throw e;
        }
    }

    public void checkByAnnotation(SaCheckSafe at) {
        this.checkSafe(at.value());
    }

    public void checkByAnnotation(SaCheckDisable at) {
        Object loginId = this.getLoginId();
        for (String service : at.value()) {
            this.checkDisableLevel(loginId, service, at.level());
        }
    }

    public void disable(Object loginId, long time) {
        this.disableLevel(loginId, "login", 1, time);
    }

    public boolean isDisable(Object loginId) {
        return this.isDisableLevel(loginId, "login", 1);
    }

    public void checkDisable(Object loginId) {
        this.checkDisableLevel(loginId, "login", 1);
    }

    public long getDisableTime(Object loginId) {
        return this.getDisableTime(loginId, "login");
    }

    public void untieDisable(Object loginId) {
        this.untieDisable(loginId, "login");
    }

    public void disable(Object loginId, String service, long time) {
        this.disableLevel(loginId, service, 1, time);
    }

    public boolean isDisable(Object loginId, String service) {
        return this.isDisableLevel(loginId, service, 1);
    }

    public void checkDisable(Object loginId, String ... services) {
        if (services != null) {
            for (String service : services) {
                this.checkDisableLevel(loginId, service, 1);
            }
        }
    }

    public long getDisableTime(Object loginId, String service) {
        return this.getSaTokenDao().getTimeout(this.splicingKeyDisable(loginId, service));
    }

    public void untieDisable(Object loginId, String ... services) {
        if (SaFoxUtil.isEmpty(loginId)) {
            throw new SaTokenException("\u8bf7\u63d0\u4f9b\u8981\u89e3\u7981\u7684\u8d26\u53f7").setCode(11062);
        }
        if (services == null || services.length == 0) {
            throw new SaTokenException("\u8bf7\u63d0\u4f9b\u8981\u89e3\u7981\u7684\u670d\u52a1").setCode(11063);
        }
        for (String service : services) {
            this.getSaTokenDao().delete(this.splicingKeyDisable(loginId, service));
            SaTokenEventCenter.doUntieDisable(this.loginType, loginId, service);
        }
    }

    public void disableLevel(Object loginId, int level, long time) {
        this.disableLevel(loginId, "login", level, time);
    }

    public void disableLevel(Object loginId, String service, int level, long time) {
        if (SaFoxUtil.isEmpty(loginId)) {
            throw new SaTokenException("\u8bf7\u63d0\u4f9b\u8981\u5c01\u7981\u7684\u8d26\u53f7").setCode(11062);
        }
        if (SaFoxUtil.isEmpty(service)) {
            throw new SaTokenException("\u8bf7\u63d0\u4f9b\u8981\u5c01\u7981\u7684\u670d\u52a1").setCode(11063);
        }
        if (level < 1) {
            throw new SaTokenException("\u5c01\u7981\u7b49\u7ea7\u4e0d\u53ef\u4ee5\u5c0f\u4e8e\u6700\u5c0f\u503c\uff1a1").setCode(11064);
        }
        this.getSaTokenDao().set(this.splicingKeyDisable(loginId, service), String.valueOf(level), time);
        SaTokenEventCenter.doDisable(this.loginType, loginId, service, level, time);
    }

    public boolean isDisableLevel(Object loginId, int level) {
        return this.isDisableLevel(loginId, "login", level);
    }

    public boolean isDisableLevel(Object loginId, String service, int level) {
        int disableLevel = this.getDisableLevel(loginId, service);
        if (disableLevel == -2) {
            return false;
        }
        return disableLevel >= level;
    }

    public void checkDisableLevel(Object loginId, int level) {
        this.checkDisableLevel(loginId, "login", level);
    }

    public void checkDisableLevel(Object loginId, String service, int level) {
        String value = this.getSaTokenDao().get(this.splicingKeyDisable(loginId, service));
        if (SaFoxUtil.isEmpty(value)) {
            return;
        }
        Integer disableLevel = SaFoxUtil.getValueByType(value, Integer.TYPE);
        if (disableLevel >= level) {
            throw new DisableServiceException(this.loginType, loginId, service, disableLevel, level, this.getDisableTime(loginId, service)).setCode(11061);
        }
    }

    public int getDisableLevel(Object loginId) {
        return this.getDisableLevel(loginId, "login");
    }

    public int getDisableLevel(Object loginId, String service) {
        String value = this.getSaTokenDao().get(this.splicingKeyDisable(loginId, service));
        if (SaFoxUtil.isEmpty(value)) {
            return -2;
        }
        return SaFoxUtil.getValueByType(value, Integer.TYPE);
    }

    public void switchTo(Object loginId) {
        SaHolder.getStorage().set(this.splicingKeySwitch(), loginId);
    }

    public void endSwitch() {
        SaHolder.getStorage().delete(this.splicingKeySwitch());
    }

    public boolean isSwitch() {
        return SaHolder.getStorage().get(this.splicingKeySwitch()) != null;
    }

    public Object getSwitchLoginId() {
        return SaHolder.getStorage().get(this.splicingKeySwitch());
    }

    public void switchTo(Object loginId, SaFunction function) {
        try {
            this.switchTo(loginId);
            function.run();
        }
        finally {
            this.endSwitch();
        }
    }

    public void openSafe(long safeTime) {
        this.openSafe("important", safeTime);
    }

    public void openSafe(String service, long safeTime) {
        this.checkLogin();
        String tokenValue = this.getTokenValueNotNull();
        this.getSaTokenDao().set(this.splicingKeySafe(tokenValue, service), "SAFE_AUTH_SAVE_VALUE", safeTime);
        SaTokenEventCenter.doOpenSafe(this.loginType, tokenValue, service, safeTime);
    }

    public boolean isSafe() {
        return this.isSafe("important");
    }

    public boolean isSafe(String service) {
        return this.isSafe(this.getTokenValue(), service);
    }

    public boolean isSafe(String tokenValue, String service) {
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return false;
        }
        String value = this.getSaTokenDao().get(this.splicingKeySafe(tokenValue, service));
        return !SaFoxUtil.isEmpty(value);
    }

    public void checkSafe() {
        this.checkSafe("important");
    }

    public void checkSafe(String service) {
        String tokenValue = this.getTokenValue();
        if (!this.isSafe(tokenValue, service)) {
            throw new NotSafeException(this.loginType, tokenValue, service).setCode(11071);
        }
    }

    public long getSafeTime() {
        return this.getSafeTime("important");
    }

    public long getSafeTime(String service) {
        String tokenValue = this.getTokenValue();
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return -2L;
        }
        return this.getSaTokenDao().getTimeout(this.splicingKeySafe(tokenValue, service));
    }

    public void closeSafe() {
        this.closeSafe("important");
    }

    public void closeSafe(String service) {
        String tokenValue = this.getTokenValue();
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return;
        }
        this.getSaTokenDao().delete(this.splicingKeySafe(tokenValue, service));
        SaTokenEventCenter.doCloseSafe(this.loginType, tokenValue, service);
    }

    public String splicingKeyTokenName() {
        return this.getConfigOrGlobal().getTokenName();
    }

    public String splicingKeyTokenValue(String tokenValue) {
        return this.getConfigOrGlobal().getTokenName() + ":" + this.loginType + ":token:" + tokenValue;
    }

    public String splicingKeySession(Object loginId) {
        return this.getConfigOrGlobal().getTokenName() + ":" + this.loginType + ":session:" + loginId;
    }

    public String splicingKeyTokenSession(String tokenValue) {
        return this.getConfigOrGlobal().getTokenName() + ":" + this.loginType + ":token-session:" + tokenValue;
    }

    public String splicingKeyLastActiveTime(String tokenValue) {
        return this.getConfigOrGlobal().getTokenName() + ":" + this.loginType + ":last-active:" + tokenValue;
    }

    public String splicingKeySwitch() {
        return "SWITCH_TO_SAVE_KEY_" + this.loginType;
    }

    public String splicingKeyJustCreatedSave() {
        return "JUST_CREATED_";
    }

    public String splicingKeyDisable(Object loginId, String service) {
        return this.getConfigOrGlobal().getTokenName() + ":" + this.loginType + ":disable:" + service + ":" + loginId;
    }

    public String splicingKeySafe(String tokenValue, String service) {
        return this.getConfigOrGlobal().getTokenName() + ":" + this.loginType + ":safe:" + service + ":" + tokenValue;
    }

    public SaTokenDao getSaTokenDao() {
        return SaManager.getSaTokenDao();
    }

    public boolean getConfigOfIsShare() {
        return this.getConfigOrGlobal().getIsShare();
    }

    public boolean isOpenCheckActiveTimeout() {
        SaTokenConfig cfg = this.getConfigOrGlobal();
        return cfg.getActiveTimeout() != -1L || cfg.getDynamicActiveTimeout() != false;
    }

    public int getConfigOfCookieTimeout() {
        long timeout = this.getConfigOrGlobal().getTimeout();
        if (timeout == -1L) {
            return Integer.MAX_VALUE;
        }
        return (int)timeout;
    }

    public int getConfigOfMaxTryTimes() {
        return this.getConfigOrGlobal().getMaxTryTimes();
    }

    public boolean hasElement(List<String> list, String element) {
        return (Boolean)SaStrategy.instance.hasElement.apply(list, element);
    }

    public boolean isSupportExtra() {
        return false;
    }
}

