/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.quartz;

import cn.dreampie.quartz.QuartzKey;
import cn.dreampie.quartz.job.QuartzJob;
import com.google.common.collect.Lists;
import java.util.List;
import org.quartz.SchedulerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzKit {
    private static SchedulerFactory schedulerFactory;
    private static List<QuartzJob> quartzJobs;

    private QuartzKit() {
    }

    public static QuartzJob getJob(QuartzKey quartzKey) {
        for (QuartzJob quartzJob : quartzJobs) {
            if (!quartzJob.getQuartzKey().equals(quartzKey)) continue;
            return quartzJob;
        }
        return null;
    }

    public static void stopJob(QuartzKey quartzKey) {
        for (QuartzJob quartzJob : quartzJobs) {
            if (!quartzJob.getQuartzKey().equals(quartzKey)) continue;
            quartzJob.stop();
        }
    }

    public static void pauseJob(QuartzKey quartzKey) {
        for (QuartzJob quartzJob : quartzJobs) {
            if (!quartzJob.getQuartzKey().equals(quartzKey)) continue;
            quartzJob.pause();
        }
    }

    public static void resumeJob(QuartzKey quartzKey) {
        for (QuartzJob quartzJob : quartzJobs) {
            if (!quartzJob.getQuartzKey().equals(quartzKey)) continue;
            quartzJob.resume();
        }
    }

    public static SchedulerFactory getSchedulerFactory() {
        return schedulerFactory;
    }

    public static void setSchedulerFactory(SchedulerFactory schedulerFactory) {
        QuartzKit.schedulerFactory = schedulerFactory;
    }

    public static List<QuartzJob> getQuartzJobs() {
        return quartzJobs;
    }

    public static void setQuartzJobs(List<QuartzJob> quartzJobs) {
        QuartzKit.quartzJobs = quartzJobs;
    }

    public static void addQuartzJob(QuartzJob startedJob) {
        quartzJobs.add(startedJob);
    }

    public static void removeQuartzJob(QuartzJob startedJob) {
        quartzJobs.remove(startedJob);
    }

    static {
        quartzJobs = Lists.newArrayList();
    }
}

