/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easyocr;

import cn.easyproject.easyocr.EasyOCRException;
import cn.easyproject.easyocr.ImageClean;
import cn.easyproject.easyocr.ImageType;
import cn.easyproject.easyocr.Type;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyOCR {
    private String tesseractPath = "tesseract";
    private String tesseractOptions = "";
    public static final String OPTION_LANG_ENG = "-l eng";
    public static final String OPTION_LANG_CHI_SIM = "-l chi_sim";
    private double autoCleanImageWidthRatio = 1.0;
    private double autoCleanImageHeightRatio = 1.0;
    private int autoCleanDegrees = 0;
    private Type autoCleanImageType = ImageType.NONE;

    public EasyOCR() {
    }

    public EasyOCR(String tesseractPath) {
        this.tesseractPath = tesseractPath;
    }

    public EasyOCR(String tesseractPath, String tesseractOptions) {
        this.tesseractPath = tesseractPath;
        this.tesseractOptions = tesseractOptions;
    }

    public String discern(File fromImage) {
        String toFile = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
        try {
            return this.discernToFileAndGet(fromImage.getCanonicalPath(), toFile, true);
        }
        catch (IOException e) {
            throw new EasyOCRException("File path is incorrect, please check", e);
        }
    }

    public String discern(FileInputStream fromImage) {
        String toFile = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
        String fromFile = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
        String res = null;
        if (this.inputStreamToFile(fromImage, fromFile)) {
            res = this.discernToFileAndGet(fromFile, toFile, true);
        }
        new File(fromFile).delete();
        return res;
    }

    public String discern(String fromImage) {
        String toFile = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
        return this.discernToFileAndGet(fromImage, toFile, true);
    }

    public String discernAndAutoCleanImage(File fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(File fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(File fromImage, Type imageType) {
        return this.discernAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(File fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernAndAutoCleanImage(fromImage, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(File fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        try {
            String fromPath = fromImage.getCanonicalPath();
            return this.discernAndAutoCleanImage(fromPath, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
        }
        catch (IOException e) {
            throw new EasyOCRException("File path is incorrect, please check", e);
        }
    }

    public String discernAndAutoCleanImage(File fromImage, Type imageType, int autoCleanDegrees) {
        return this.discernAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(File fromImage, int autoCleanDegrees) {
        return this.discernAndAutoCleanImage(fromImage, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(InputStream fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(InputStream fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(InputStream fromImage, Type imageType) {
        return this.discernAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(InputStream fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernAndAutoCleanImage(fromImage, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(InputStream fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        String fromPath = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
        String res = null;
        if (this.inputStreamToFile(fromImage, fromPath)) {
            res = this.discernAndAutoCleanImage(fromPath, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
        }
        new File(fromPath).delete();
        return res;
    }

    public String discernAndAutoCleanImage(InputStream fromImage, Type imageType, int autoCleanDegrees) {
        return this.discernAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(InputStream fromImage, int autoCleanDegrees) {
        return this.discernAndAutoCleanImage(fromImage, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(String fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(String fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(String fromImage, Type imageType) {
        return this.discernAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(String fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernAndAutoCleanImage(fromImage, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String discernAndAutoCleanImage(String fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        String res = "";
        boolean urlFlag = false;
        String ex = "";
        int lastDot = fromImage.lastIndexOf(".");
        if (lastDot != -1) {
            ex = fromImage.substring(lastDot);
        }
        try {
            if (fromImage.startsWith("http://") || fromImage.startsWith("ftp://")) {
                urlFlag = true;
                URL url = new URL(fromImage);
                InputStream is = url.openStream();
                if (!this.inputStreamToFile(is, fromImage = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString() + ex)) {
                    is.close();
                    new File(fromImage).delete();
                    String string = res;
                    return string;
                }
            }
            String tempCleanImage = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString() + ex;
            ImageClean imageClean = new ImageClean(imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
            imageClean.cleanImage(fromImage, tempCleanImage);
            res = this.discern(tempCleanImage);
            new File(tempCleanImage).delete();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (urlFlag) {
                new File(fromImage).delete();
            }
        }
        return res;
    }

    public String discernAndAutoCleanImage(String fromImage, Type imageType, int autoCleanDegrees) {
        return this.discernAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernAndAutoCleanImage(String fromImage, int autoCleanDegrees) {
        return this.discernAndAutoCleanImage(fromImage, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFile(File fromImage) {
        try {
            String toFile = fromImage.getCanonicalPath();
            int lastIndex = toFile.lastIndexOf(".");
            if (lastIndex != -1) {
                toFile = toFile.substring(0, lastIndex);
            }
            return this.discernToFile(fromImage.getCanonicalPath(), toFile);
        }
        catch (IOException e) {
            throw new EasyOCRException("File path is incorrect, please check", e);
        }
    }

    public boolean discernToFile(File fromImage, String toFile) {
        try {
            return this.discernToFile(fromImage.getCanonicalPath(), toFile);
        }
        catch (IOException e) {
            throw new EasyOCRException("File path is incorrect, please check", e);
        }
    }

    public boolean discernToFile(FileInputStream fromImage, String toFile) {
        String fromPath = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
        boolean res = false;
        if (this.inputStreamToFile(fromImage, fromPath)) {
            res = this.discernToFile(fromPath, toFile);
        }
        new File(fromPath).delete();
        return res;
    }

    public boolean discernToFile(String fromImage) {
        String toFile = fromImage;
        int lastIndex = toFile.lastIndexOf(".");
        if (lastIndex != -1) {
            toFile = toFile.substring(0, lastIndex);
        }
        if (fromImage.startsWith("http://") || fromImage.startsWith("ftp://")) {
            int lastDot = fromImage.lastIndexOf(".");
            toFile = fromImage;
            int lastSeparator = fromImage.lastIndexOf("/");
            if (lastSeparator != -1) {
                toFile = lastDot != -1 ? fromImage.substring(lastSeparator + 1, lastDot) : fromImage.substring(lastSeparator + 1);
            }
        }
        return this.discernToFile(fromImage, toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean discernToFile(String fromImage, String toFile) {
        boolean flag = false;
        boolean urlFlag = false;
        try {
            if (fromImage.startsWith("http://") || fromImage.startsWith("ftp://")) {
                urlFlag = true;
                URL url = new URL(fromImage);
                InputStream is = url.openStream();
                if (!this.inputStreamToFile(is, fromImage = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString())) {
                    is.close();
                    new File(fromImage).delete();
                    boolean bl = flag;
                    return bl;
                }
            }
            ArrayList<String> cmd = new ArrayList<String>();
            File img = new File(fromImage);
            cmd.add(this.tesseractPath);
            cmd.add("");
            cmd.add(toFile);
            this.setOptions(cmd);
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.directory(img.getParentFile());
            cmd.set(1, img.getName());
            pb.command(cmd);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            int w = process.waitFor();
            if (w != 0) {
                String msg;
                switch (w) {
                    case 1: {
                        msg = "Errors accessing files. There may be spaces in your image's filename.";
                        break;
                    }
                    case 29: {
                        msg = "Cannot recognize the image or its selected region.";
                        break;
                    }
                    case 31: {
                        msg = "Unsupported image format.";
                        break;
                    }
                    default: {
                        msg = "Errors occurred.";
                    }
                }
                throw new RuntimeException(msg);
            }
            flag = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (urlFlag) {
                new File(fromImage).delete();
            }
        }
        return flag;
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, Type imageType) {
        return this.discernToFileAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndAutoCleanImage(fromImage, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        try {
            String fromPath;
            String toFile = fromPath = fromImage.getCanonicalPath();
            int lastIndex = toFile.lastIndexOf(".");
            if (lastIndex != -1) {
                toFile = toFile.substring(0, lastIndex);
            }
            return this.discernToFileAndAutoCleanImage(fromImage, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
        }
        catch (IOException e) {
            throw new EasyOCRException("File path is incorrect, please check", e);
        }
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, Type imageType, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, String toFile, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, String toFile, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, String toFile, Type imageType) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, String toFile, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, String toFile, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        try {
            String fromPath = fromImage.getCanonicalPath();
            return this.discernToFileAndAutoCleanImage(fromPath, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
        }
        catch (IOException e) {
            throw new EasyOCRException("File path is incorrect, please check", e);
        }
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, String toFile, Type imageType, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(File fromImage, String toFile, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(InputStream fromImage, String toFile, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(InputStream fromImage, String toFile, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(InputStream fromImage, String toFile, Type imageType) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(InputStream fromImage, String toFile, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(InputStream fromImage, String toFile, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        String fromPath = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
        boolean res = false;
        if (this.inputStreamToFile(fromImage, fromPath)) {
            res = this.discernToFileAndAutoCleanImage(fromPath, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
        }
        new File(fromPath).delete();
        return res;
    }

    public boolean discernToFileAndAutoCleanImage(InputStream fromImage, String toFile, Type imageType, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(InputStream fromImage, String toFile, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(String fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(String fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(String fromImage, Type imageType) {
        return this.discernToFileAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(String fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndAutoCleanImage(fromImage, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean discernToFileAndAutoCleanImage(String fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        boolean res = false;
        boolean urlFlag = false;
        String toFile = fromImage;
        int lastDot = fromImage.lastIndexOf(".");
        if (fromImage.startsWith("http://") || fromImage.startsWith("ftp://")) {
            urlFlag = true;
            int lastSeparator = fromImage.lastIndexOf("/");
            if (lastSeparator != -1) {
                toFile = lastDot != -1 ? fromImage.substring(lastSeparator + 1, lastDot) : fromImage.substring(lastSeparator + 1);
            }
        } else if (lastDot != -1) {
            toFile = toFile.substring(0, lastDot);
        }
        try {
            URL url;
            InputStream is;
            if (urlFlag && !this.inputStreamToFile(is = (url = new URL(fromImage)).openStream(), fromImage = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString())) {
                is.close();
                new File(fromImage).delete();
                boolean bl = res;
                return bl;
            }
            res = this.discernToFileAndAutoCleanImage(fromImage, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (urlFlag) {
                new File(fromImage).delete();
            }
        }
        return res;
    }

    public boolean discernToFileAndAutoCleanImage(String fromImage, Type imageType, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(String fromImage, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(String fromImage, String toFile, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(String fromImage, String toFile, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(String fromImage, String toFile, Type imageType) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(String fromImage, String toFile, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean discernToFileAndAutoCleanImage(String fromImage, String toFile, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        boolean res = false;
        boolean urlFlag = false;
        try {
            if (fromImage.startsWith("http://") || fromImage.startsWith("ftp://")) {
                urlFlag = true;
                URL url = new URL(fromImage);
                InputStream is = url.openStream();
                if (!this.inputStreamToFile(is, fromImage = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString())) {
                    is.close();
                    new File(fromImage).delete();
                    boolean bl = res;
                    return bl;
                }
            }
            String tempCleanImage = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
            ImageClean imageClean = new ImageClean(imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
            imageClean.cleanImage(fromImage, tempCleanImage);
            res = this.discernToFile(tempCleanImage, toFile);
            new File(tempCleanImage).delete();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (urlFlag) {
                new File(fromImage).delete();
            }
        }
        return res;
    }

    public boolean discernToFileAndAutoCleanImage(String fromImage, String toFile, Type imageType, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public boolean discernToFileAndAutoCleanImage(String fromImage, String toFile, int autoCleanDegrees) {
        return this.discernToFileAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGet(File fromImage) {
        try {
            String fromPath;
            String toFile = fromPath = fromImage.getCanonicalPath();
            int lastIndex = toFile.lastIndexOf(".");
            if (lastIndex != -1) {
                toFile = toFile.substring(0, lastIndex);
            }
            return this.discernToFileAndGet(fromPath, toFile, false);
        }
        catch (IOException e) {
            throw new EasyOCRException("File path is incorrect, please check", e);
        }
    }

    public String discernToFileAndGet(File fromImage, String toFile) {
        try {
            String fromPath = fromImage.getCanonicalPath();
            return this.discernToFileAndGet(fromPath, toFile, false);
        }
        catch (IOException e) {
            throw new EasyOCRException("File path is incorrect, please check", e);
        }
    }

    public String discernToFileAndGet(FileInputStream fromImage, String toFile) {
        String fromPath = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
        String res = null;
        if (this.inputStreamToFile(fromImage, fromPath)) {
            res = this.discernToFileAndGet(fromPath, toFile, false);
        }
        new File(fromPath).delete();
        return res;
    }

    public String discernToFileAndGet(String fromImage) {
        String toFile = fromImage;
        int lastDot = fromImage.lastIndexOf(".");
        if (fromImage.startsWith("http://") || fromImage.startsWith("ftp://")) {
            int lastSeparator = fromImage.lastIndexOf("/");
            if (lastSeparator != -1) {
                toFile = lastDot != -1 ? fromImage.substring(lastSeparator + 1, lastDot) : fromImage.substring(lastSeparator + 1);
            }
        } else if (lastDot != -1) {
            toFile = toFile.substring(0, lastDot);
        }
        return this.discernToFileAndGet(fromImage, toFile, false);
    }

    public String discernToFileAndGet(String fromImage, String toFile) {
        return this.discernToFileAndGet(fromImage, toFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String discernToFileAndGet(String fromImage, String toFile, boolean deleteFile) {
        StringBuilder res;
        block21: {
            boolean urlFlag = false;
            res = new StringBuilder("");
            try {
                String msg;
                if (fromImage.startsWith("http://") || fromImage.startsWith("ftp://")) {
                    urlFlag = true;
                    URL url = new URL(fromImage);
                    InputStream is = url.openStream();
                    if (!this.inputStreamToFile(is, fromImage = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString())) {
                        is.close();
                        new File(fromImage).delete();
                        String string = res.toString();
                        return string;
                    }
                }
                ArrayList<String> cmd = new ArrayList<String>();
                File img = new File(fromImage);
                if (this.tesseractPath == null || this.tesseractPath.trim().equals("")) {
                    this.tesseractPath = "tesseract";
                }
                cmd.add(this.tesseractPath);
                cmd.add("");
                cmd.add(toFile);
                this.setOptions(cmd);
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                pb.directory(img.getParentFile());
                cmd.set(1, img.getName());
                pb.command(cmd);
                pb.redirectErrorStream(true);
                Process process = pb.start();
                int w = process.waitFor();
                if (w == 0) {
                    File file = new File(toFile + ".txt");
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    String s = null;
                    while ((s = br.readLine()) != null) {
                        res.append(s).append("\n");
                    }
                    if (res.lastIndexOf("\n") != -1) {
                        res.delete(res.length() - 2, res.length());
                    }
                    br.close();
                    if (deleteFile) {
                        file.delete();
                    }
                    break block21;
                }
                switch (w) {
                    case 1: {
                        msg = "Errors accessing files. There may be spaces in your image's filename.";
                        break;
                    }
                    case 29: {
                        msg = "Cannot recognize the image or its selected region.";
                        break;
                    }
                    case 31: {
                        msg = "Unsupported image format.";
                        break;
                    }
                    default: {
                        msg = "Errors accessing files. There may be wrong filename.";
                    }
                }
                throw new RuntimeException(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                if (urlFlag) {
                    new File(fromImage).delete();
                }
            }
        }
        return res.toString();
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, Type imageType) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        try {
            String fromPath;
            String toFile = fromPath = fromImage.getCanonicalPath();
            int lastIndex = toFile.lastIndexOf(".");
            if (lastIndex != -1) {
                toFile = toFile.substring(0, lastIndex);
            }
            return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
        }
        catch (IOException e) {
            throw new EasyOCRException("File path is incorrect, please check", e);
        }
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, Type imageType, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, String toFile, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, String toFile, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, String toFile, Type imageType) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, String toFile, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, String toFile, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        try {
            String fromPath = fromImage.getCanonicalPath();
            int lastIndex = toFile.lastIndexOf(".");
            if (lastIndex != -1) {
                toFile = toFile.substring(0, lastIndex);
            }
            return this.discernToFileAndGetAndAutoCleanImage(fromPath, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
        }
        catch (IOException e) {
            throw new EasyOCRException("File path is incorrect, please check", e);
        }
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, String toFile, Type imageType, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(File fromImage, String toFile, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(InputStream fromImage, String toFile, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(InputStream fromImage, String toFile, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(InputStream fromImage, String toFile, Type imageType) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(InputStream fromImage, String toFile, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(InputStream fromImage, String toFile, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        String fromPath = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
        String res = null;
        if (this.inputStreamToFile(fromImage, fromPath)) {
            res = this.discernToFileAndGetAndAutoCleanImage(fromPath, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
        }
        new File(fromPath).delete();
        return res;
    }

    public String discernToFileAndGetAndAutoCleanImage(InputStream fromImage, String toFile, Type imageType, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(InputStream fromImage, String toFile, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(String fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(String fromImage, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(String fromImage, Type imageType) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(String fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String discernToFileAndGetAndAutoCleanImage(String fromImage, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        String res = "";
        boolean urlFlag = false;
        String toFile = fromImage;
        int lastDot = fromImage.lastIndexOf(".");
        if (fromImage.startsWith("http://") || fromImage.startsWith("ftp://")) {
            urlFlag = true;
            int lastSeparator = fromImage.lastIndexOf("/");
            if (lastSeparator != -1) {
                toFile = lastDot != -1 ? fromImage.substring(lastSeparator + 1, lastDot) : fromImage.substring(lastSeparator + 1);
            }
        } else if (lastDot != -1) {
            toFile = toFile.substring(0, lastDot);
        }
        try {
            URL url;
            InputStream is;
            if (urlFlag && !this.inputStreamToFile(is = (url = new URL(fromImage)).openStream(), fromImage = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString())) {
                is.close();
                new File(fromImage).delete();
                String string = res;
                return string;
            }
            res = this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (urlFlag) {
                new File(fromImage).delete();
            }
        }
        return res;
    }

    public String discernToFileAndGetAndAutoCleanImage(String fromImage, Type imageType, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(String fromImage, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(String fromImage, String toFile, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(String fromImage, String toFile, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(String fromImage, String toFile, Type imageType) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(String fromImage, String toFile, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, this.autoCleanDegrees);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String discernToFileAndGetAndAutoCleanImage(String fromImage, String toFile, Type imageType, double autoCleanImageWidthRatio, double autoCleanImageHeightRatio, int autoCleanDegrees) {
        String res = "";
        boolean urlFlag = false;
        int lastIndex = toFile.lastIndexOf(".");
        if (lastIndex != -1) {
            toFile = toFile.substring(0, lastIndex);
        }
        try {
            if (fromImage.startsWith("http://") || fromImage.startsWith("ftp://")) {
                urlFlag = true;
                URL url = new URL(fromImage);
                InputStream is = url.openStream();
                if (!this.inputStreamToFile(is, fromImage = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString())) {
                    is.close();
                    new File(fromImage).delete();
                    String string = res;
                    return string;
                }
            }
            String tempCleanImage = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
            ImageClean imageClean = new ImageClean(imageType, autoCleanImageWidthRatio, autoCleanImageHeightRatio, autoCleanDegrees);
            imageClean.cleanImage(fromImage, tempCleanImage);
            res = this.discernToFileAndGet(tempCleanImage, toFile);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (urlFlag) {
                new File(fromImage).delete();
            }
        }
        return res;
    }

    public String discernToFileAndGetAndAutoCleanImage(String fromImage, String toFile, Type imageType, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, imageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public String discernToFileAndGetAndAutoCleanImage(String fromImage, String toFile, int autoCleanDegrees) {
        return this.discernToFileAndGetAndAutoCleanImage(fromImage, toFile, this.autoCleanImageType, this.autoCleanImageWidthRatio, this.autoCleanImageHeightRatio, autoCleanDegrees);
    }

    public int getAutoCleanDegrees() {
        return this.autoCleanDegrees;
    }

    public double getAutoCleanImageHeightRatio() {
        return this.autoCleanImageHeightRatio;
    }

    public Type getAutoCleanType() {
        return this.autoCleanImageType;
    }

    public double getAutoCleanImageWidthRatio() {
        return this.autoCleanImageWidthRatio;
    }

    public String getTesseractOptions() {
        return this.tesseractOptions;
    }

    public String getTesseractPath() {
        return this.tesseractPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inputStreamToFile(InputStream fis, String file) {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(fis);
            bos = new BufferedOutputStream(new FileOutputStream(file));
            byte[] data = new byte[8192];
            int len = -1;
            while ((len = bis.read(data)) != -1) {
                ((BufferedOutputStream)bos).write(data, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void setAutoCleanDegrees(int autoCleanDegrees) {
        this.autoCleanDegrees = autoCleanDegrees;
    }

    public void setAutoCleanImageHeightRatio(double autoCleanImageHeightRatio) {
        this.autoCleanImageHeightRatio = autoCleanImageHeightRatio;
    }

    public void setAutoCleanImageRatio(double autoCleanImageWidthRatio, double autoCleanImageHeightRatio) {
        this.autoCleanImageWidthRatio = autoCleanImageWidthRatio;
        this.autoCleanImageHeightRatio = autoCleanImageHeightRatio;
    }

    public void setAutoCleanImageType(Type autoCleanImageType) {
        this.autoCleanImageType = autoCleanImageType;
    }

    public void setAutoCleanImageWidthRatio(double autoCleanImageWidthRatio) {
        this.autoCleanImageWidthRatio = autoCleanImageWidthRatio;
    }

    public void setDegrees(int autoCleanDegrees) {
        this.autoCleanDegrees = autoCleanDegrees;
    }

    private void setOptions(List<String> cmd) {
        String[] options;
        for (String option : options = this.tesseractOptions.split(" ")) {
            cmd.add("");
            cmd.add(option);
        }
    }

    public void setTesseractOptions(String tesseractOptions) {
        this.tesseractOptions = tesseractOptions.trim();
    }

    public void setTesseractPath(String tesseractPath) {
        this.tesseractPath = tesseractPath;
    }
}

