/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.proxy;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.core.executor.ThreadPoolNotifyAlarmHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;

public class RejectedProxyInvocationHandler
implements InvocationHandler {
    private final Object target;
    private final String threadPoolId;
    private final AtomicLong rejectCount;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.rejectCount.incrementAndGet();
        ThreadPoolNotifyAlarmHandler alarmHandler = (ThreadPoolNotifyAlarmHandler)ApplicationContextHolder.getBean(ThreadPoolNotifyAlarmHandler.class);
        alarmHandler.checkPoolRejectedAlarm(this.threadPoolId);
        try {
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
    }

    public RejectedProxyInvocationHandler(Object target, String threadPoolId, AtomicLong rejectCount) {
        this.target = target;
        this.threadPoolId = threadPoolId;
        this.rejectCount = rejectCount;
    }
}

