/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.state;

import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.common.toolkit.CalculateUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class AbstractThreadPoolRuntime {
    public abstract ThreadPoolRunStateInfo supplement(ThreadPoolRunStateInfo var1);

    public ThreadPoolRunStateInfo getPoolRunState(String threadPoolId) {
        DynamicThreadPoolWrapper executorService = GlobalThreadPoolManage.getExecutorService(threadPoolId);
        ThreadPoolExecutor pool = executorService.getExecutor();
        return this.getPoolRunState(threadPoolId, pool);
    }

    public ThreadPoolRunStateInfo getPoolRunState(String threadPoolId, Executor executor) {
        ThreadPoolExecutor actualExecutor = (ThreadPoolExecutor)executor;
        int activeCount = actualExecutor.getActiveCount();
        int largestPoolSize = actualExecutor.getLargestPoolSize();
        BlockingQueue<Runnable> blockingQueue = actualExecutor.getQueue();
        long rejectCount = actualExecutor instanceof DynamicThreadPoolExecutor ? ((DynamicThreadPoolExecutor)actualExecutor).getRejectCountNum() : -1L;
        ThreadPoolRunStateInfo stateInfo = ThreadPoolRunStateInfo.builder().tpId(threadPoolId).activeSize(Integer.valueOf(activeCount)).poolSize(Integer.valueOf(actualExecutor.getPoolSize())).completedTaskCount(Long.valueOf(actualExecutor.getCompletedTaskCount())).largestPoolSize(Integer.valueOf(largestPoolSize)).currentLoad(CalculateUtil.divide((int)activeCount, (int)actualExecutor.getMaximumPoolSize()) + "").clientLastRefreshTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).peakLoad(CalculateUtil.divide((int)largestPoolSize, (int)actualExecutor.getMaximumPoolSize()) + "").queueSize(Integer.valueOf(blockingQueue.size())).queueRemainingCapacity(Integer.valueOf(blockingQueue.remainingCapacity())).rejectCount(Long.valueOf(rejectCount)).timestamp(Long.valueOf(System.currentTimeMillis())).build();
        stateInfo.setCoreSize(Integer.valueOf(actualExecutor.getCorePoolSize()));
        stateInfo.setMaximumSize(Integer.valueOf(actualExecutor.getMaximumPoolSize()));
        stateInfo.setQueueType(blockingQueue.getClass().getSimpleName());
        stateInfo.setQueueCapacity(Integer.valueOf(blockingQueue.size() + blockingQueue.remainingCapacity()));
        return this.supplement(stateInfo);
    }
}

