/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.state;

import cn.hippo4j.common.toolkit.ReflectUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolStatusHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolStatusHandler.class);
    private static final String RUNNING = "Running";
    private static final String TERMINATED = "Terminated";
    private static final String SHUTTING_DOWN = "Shutting down";
    private static final AtomicBoolean EXCEPTION_FLAG = new AtomicBoolean(Boolean.TRUE);

    public static String getThreadPoolState(ThreadPoolExecutor executor) {
        if (EXCEPTION_FLAG.get()) {
            try {
                Method runStateLessThan = ReflectUtil.getMethodByName(ThreadPoolExecutor.class, (String)"runStateLessThan");
                ReflectUtil.setAccessible((AccessibleObject)runStateLessThan);
                AtomicInteger ctl = (AtomicInteger)ReflectUtil.getFieldValue((Object)executor, (String)"ctl");
                int shutdown = (Integer)ReflectUtil.getFieldValue((Object)executor, (String)"SHUTDOWN");
                boolean runStateLessThanBool = (Boolean)ReflectUtil.invoke((Object)executor, (Method)runStateLessThan, (Object[])new Object[]{ctl.get(), shutdown});
                if (runStateLessThanBool) {
                    return RUNNING;
                }
                Method runStateAtLeast = ReflectUtil.getMethodByName(ThreadPoolExecutor.class, (String)"runStateAtLeast");
                ReflectUtil.setAccessible((AccessibleObject)runStateAtLeast);
                int terminated = (Integer)ReflectUtil.getFieldValue((Object)executor, (String)"TERMINATED");
                String resultStatus = (Boolean)ReflectUtil.invoke((Object)executor, (Method)runStateAtLeast, (Object[])new Object[]{ctl.get(), terminated}) != false ? TERMINATED : SHUTTING_DOWN;
                return resultStatus;
            }
            catch (Exception ex) {
                log.error("Failed to get thread pool status.", (Throwable)ex);
                EXCEPTION_FLAG.set(Boolean.FALSE);
            }
        }
        return "UNKNOWN";
    }
}

