/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.support.adpter;

import cn.hippo4j.common.toolkit.ReflectUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.support.adpter.DynamicThreadPoolAdapter;
import cn.hippo4j.core.executor.support.adpter.ThreadPoolTaskExecutorAdapter;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ZipkinExecutorAdapter
implements DynamicThreadPoolAdapter {
    private static final String MATCH_CLASS_NAME = "brave.internal.WrappingExecutorService";
    private static final String FIELD_NAME = "delegate";
    private static final String TYPE_NAME = "java.util.concurrent.ExecutorService";

    @Override
    public boolean match(Object executor) {
        return this.matchSuper(executor);
    }

    public boolean matchSuper(Object executor) {
        if (Objects.equals(MATCH_CLASS_NAME, executor.getClass().getName())) {
            return true;
        }
        return Objects.equals(MATCH_CLASS_NAME, executor.getClass().getSuperclass().getName());
    }

    @Override
    public DynamicThreadPoolExecutor unwrap(Object executor) {
        Object unwrap = this.doUnwrap(executor);
        if (unwrap instanceof DynamicThreadPoolExecutor) {
            return (DynamicThreadPoolExecutor)unwrap;
        }
        if (executor instanceof ThreadPoolTaskExecutor) {
            return new ThreadPoolTaskExecutorAdapter().unwrap(executor);
        }
        return null;
    }

    @Override
    public void replace(Object executor, Executor dynamicThreadPoolExecutor) {
        Field field = ReflectUtil.findField((Object)executor, (String)FIELD_NAME, (String)TYPE_NAME);
        ReflectUtil.setFieldValue((Object)executor, (Field)field, (Object)dynamicThreadPoolExecutor);
    }

    private Object doUnwrap(Object executor) {
        Field field;
        Object unwrap = ReflectUtil.getFieldValue((Object)executor, (String)FIELD_NAME);
        if (unwrap == null && (field = ReflectUtil.findField((Object)executor, (String)FIELD_NAME, (String)TYPE_NAME)) != null) {
            return ReflectUtil.getFieldValue((Object)executor, (Field)field);
        }
        return null;
    }
}

