/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.plugin.impl;

import cn.hippo4j.core.plugin.PluginRuntime;
import cn.hippo4j.core.plugin.TaskAwarePlugin;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.core.task.TaskDecorator;

public class TaskDecoratorPlugin
implements TaskAwarePlugin {
    public static final String PLUGIN_NAME = "task-decorator-plugin";
    private final List<TaskDecorator> decorators = new ArrayList<TaskDecorator>();

    @Override
    public String getId() {
        return PLUGIN_NAME;
    }

    @Override
    public Runnable beforeTaskExecute(Runnable runnable) {
        for (TaskDecorator decorator : this.decorators) {
            runnable = decorator.decorate(runnable);
        }
        return runnable;
    }

    @Override
    public PluginRuntime getPluginRuntime() {
        return new PluginRuntime(this.getId()).addInfo("decorators", this.decorators);
    }

    public void addDecorator(@NonNull TaskDecorator decorator) {
        if (decorator == null) {
            throw new NullPointerException("decorator is marked non-null but is null");
        }
        this.decorators.remove(decorator);
        this.decorators.add(decorator);
    }

    public void clearDecorators() {
        this.decorators.clear();
    }

    public void removeDecorator(TaskDecorator decorator) {
        this.decorators.remove(decorator);
    }

    @Generated
    public List<TaskDecorator> getDecorators() {
        return this.decorators;
    }
}

