/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.plugin.impl;

import cn.hippo4j.core.plugin.PluginRuntime;
import cn.hippo4j.core.plugin.impl.AbstractTaskTimerPlugin;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;

public class TaskTimeRecordPlugin
extends AbstractTaskTimerPlugin {
    public static final String PLUGIN_NAME = "task-time-record-plugin";
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private long totalTaskTimeMillis = 0L;
    private long maxTaskTimeMillis = -1L;
    private long minTaskTimeMillis = -1L;
    private long taskCount = 0L;

    @Override
    public String getId() {
        return PLUGIN_NAME;
    }

    @Override
    public PluginRuntime getPluginRuntime() {
        Summary summary = this.summarize();
        return new PluginRuntime(this.getId()).addInfo("taskCount", summary.getTaskCount()).addInfo("minTaskTime", summary.getMinTaskTimeMillis() + "ms").addInfo("maxTaskTime", summary.getMaxTaskTimeMillis() + "ms").addInfo("totalTaskTime", summary.getTotalTaskTimeMillis() + "ms").addInfo("avgTaskTime", summary.getAvgTaskTimeMillis() + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processTaskTime(long taskExecuteTime) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            if (this.taskCount == 0L) {
                this.maxTaskTimeMillis = taskExecuteTime;
                this.minTaskTimeMillis = taskExecuteTime;
            } else {
                this.maxTaskTimeMillis = Math.max(taskExecuteTime, this.maxTaskTimeMillis);
                this.minTaskTimeMillis = Math.min(taskExecuteTime, this.minTaskTimeMillis);
            }
            ++this.taskCount;
            this.totalTaskTimeMillis += taskExecuteTime;
        }
        finally {
            writeLock.unlock();
        }
    }

    public Summary summarize() {
        Summary statistics;
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            statistics = new Summary(this.totalTaskTimeMillis, this.maxTaskTimeMillis, this.minTaskTimeMillis, this.taskCount);
        }
        finally {
            readLock.unlock();
        }
        return statistics;
    }

    @Generated
    public TaskTimeRecordPlugin() {
    }

    public static class Summary {
        private final long totalTaskTimeMillis;
        private final long maxTaskTimeMillis;
        private final long minTaskTimeMillis;
        private final long taskCount;

        public long getAvgTaskTimeMillis() {
            long totalTaskCount = this.getTaskCount();
            return totalTaskCount > 0L ? this.getTotalTaskTimeMillis() / totalTaskCount : -1L;
        }

        @Generated
        public long getTotalTaskTimeMillis() {
            return this.totalTaskTimeMillis;
        }

        @Generated
        public long getMaxTaskTimeMillis() {
            return this.maxTaskTimeMillis;
        }

        @Generated
        public long getMinTaskTimeMillis() {
            return this.minTaskTimeMillis;
        }

        @Generated
        public long getTaskCount() {
            return this.taskCount;
        }

        @Generated
        public Summary(long totalTaskTimeMillis, long maxTaskTimeMillis, long minTaskTimeMillis, long taskCount) {
            this.totalTaskTimeMillis = totalTaskTimeMillis;
            this.maxTaskTimeMillis = maxTaskTimeMillis;
            this.minTaskTimeMillis = minTaskTimeMillis;
            this.taskCount = taskCount;
        }
    }
}

