/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.plugin.impl;

import cn.hippo4j.common.api.ThreadPoolCheckAlarm;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.core.plugin.impl.AbstractTaskTimerPlugin;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;

public class TaskTimeoutNotifyAlarmPlugin
extends AbstractTaskTimerPlugin {
    public static final String PLUGIN_NAME = "task-timeout-notify-alarm-plugin";
    private final String threadPoolId;
    private Long executeTimeOut;
    private final ThreadPoolExecutor threadPoolExecutor;

    @Override
    public String getId() {
        return PLUGIN_NAME;
    }

    @Override
    protected void processTaskTime(long taskExecuteTime) {
        if (taskExecuteTime <= this.executeTimeOut) {
            return;
        }
        Optional.ofNullable(ApplicationContextHolder.getInstance()).map(context -> (ThreadPoolCheckAlarm)context.getBean(ThreadPoolCheckAlarm.class)).ifPresent(handler -> handler.asyncSendExecuteTimeOutAlarm(this.threadPoolId, taskExecuteTime, this.executeTimeOut.longValue(), this.threadPoolExecutor));
    }

    @Generated
    public TaskTimeoutNotifyAlarmPlugin(String threadPoolId, Long executeTimeOut, ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolId = threadPoolId;
        this.executeTimeOut = executeTimeOut;
        this.threadPoolExecutor = threadPoolExecutor;
    }

    @Generated
    public Long getExecuteTimeOut() {
        return this.executeTimeOut;
    }

    @Generated
    public void setExecuteTimeOut(Long executeTimeOut) {
        this.executeTimeOut = executeTimeOut;
    }
}

