/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.plugin.manager;

import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.core.plugin.ExecuteAwarePlugin;
import cn.hippo4j.core.plugin.RejectedAwarePlugin;
import cn.hippo4j.core.plugin.ShutdownAwarePlugin;
import cn.hippo4j.core.plugin.TaskAwarePlugin;
import cn.hippo4j.core.plugin.ThreadPoolPlugin;
import cn.hippo4j.core.plugin.manager.ThreadPoolPluginManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;

public class DefaultThreadPoolPluginManager
implements ThreadPoolPluginManager {
    private final ReadWriteLock instanceLock = new ReentrantReadWriteLock();
    private final Map<String, ThreadPoolPlugin> registeredPlugins = new ConcurrentHashMap<String, ThreadPoolPlugin>(16);
    private final List<TaskAwarePlugin> taskAwarePluginList = new CopyOnWriteArrayList<TaskAwarePlugin>();
    private final List<ExecuteAwarePlugin> executeAwarePluginList = new CopyOnWriteArrayList<ExecuteAwarePlugin>();
    private final List<RejectedAwarePlugin> rejectedAwarePluginList = new CopyOnWriteArrayList<RejectedAwarePlugin>();
    private final List<ShutdownAwarePlugin> shutdownAwarePluginList = new CopyOnWriteArrayList<ShutdownAwarePlugin>();

    @Override
    public synchronized void clear() {
        Lock writeLock = this.instanceLock.writeLock();
        writeLock.lock();
        try {
            Collection<ThreadPoolPlugin> plugins = this.registeredPlugins.values();
            this.registeredPlugins.clear();
            this.taskAwarePluginList.clear();
            this.executeAwarePluginList.clear();
            this.rejectedAwarePluginList.clear();
            this.shutdownAwarePluginList.clear();
            plugins.forEach(ThreadPoolPlugin::stop);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(@NonNull ThreadPoolPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        Lock writeLock = this.instanceLock.writeLock();
        writeLock.lock();
        try {
            String id = plugin.getId();
            Assert.isTrue((!this.isRegistered(id) ? 1 : 0) != 0, (String)("The plugin with id [" + id + "] has been registered"));
            this.registeredPlugins.put(id, plugin);
            if (plugin instanceof TaskAwarePlugin) {
                this.taskAwarePluginList.add((TaskAwarePlugin)plugin);
            }
            if (plugin instanceof ExecuteAwarePlugin) {
                this.executeAwarePluginList.add((ExecuteAwarePlugin)plugin);
            }
            if (plugin instanceof RejectedAwarePlugin) {
                this.rejectedAwarePluginList.add((RejectedAwarePlugin)plugin);
            }
            if (plugin instanceof ShutdownAwarePlugin) {
                this.shutdownAwarePluginList.add((ShutdownAwarePlugin)plugin);
            }
            plugin.start();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryRegister(ThreadPoolPlugin plugin) {
        Lock writeLock = this.instanceLock.writeLock();
        writeLock.lock();
        try {
            if (this.registeredPlugins.containsKey(plugin.getId())) {
                boolean bl = false;
                return bl;
            }
            this.register(plugin);
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void unregister(String pluginId) {
        Lock writeLock = this.instanceLock.writeLock();
        writeLock.lock();
        try {
            Optional.ofNullable(pluginId).map(this.registeredPlugins::remove).ifPresent(plugin -> {
                if (plugin instanceof TaskAwarePlugin) {
                    this.taskAwarePluginList.remove(plugin);
                }
                if (plugin instanceof ExecuteAwarePlugin) {
                    this.executeAwarePluginList.remove(plugin);
                }
                if (plugin instanceof RejectedAwarePlugin) {
                    this.rejectedAwarePluginList.remove(plugin);
                }
                if (plugin instanceof ShutdownAwarePlugin) {
                    this.shutdownAwarePluginList.remove(plugin);
                }
                plugin.stop();
            });
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public Collection<ThreadPoolPlugin> getAllPlugins() {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            Collection<ThreadPoolPlugin> collection = this.registeredPlugins.values();
            return collection;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRegistered(String pluginId) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            boolean bl = this.registeredPlugins.containsKey(pluginId);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends ThreadPoolPlugin> Optional<A> getPlugin(String pluginId) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            Optional<ThreadPoolPlugin> optional = Optional.ofNullable(this.registeredPlugins.get(pluginId));
            return optional;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Collection<ExecuteAwarePlugin> getExecuteAwarePluginList() {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            List<ExecuteAwarePlugin> list = this.executeAwarePluginList;
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Collection<RejectedAwarePlugin> getRejectedAwarePluginList() {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            List<RejectedAwarePlugin> list = this.rejectedAwarePluginList;
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Collection<ShutdownAwarePlugin> getShutdownAwarePluginList() {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            List<ShutdownAwarePlugin> list = this.shutdownAwarePluginList;
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Collection<TaskAwarePlugin> getTaskAwarePluginList() {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            List<TaskAwarePlugin> list = this.taskAwarePluginList;
            return list;
        }
        finally {
            readLock.unlock();
        }
    }
}

