/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.proxy;

import cn.hippo4j.common.api.ThreadPoolCheckAlarm;
import cn.hippo4j.common.config.ApplicationContextHolder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectedProxyInvocationHandler
implements InvocationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RejectedProxyInvocationHandler.class);
    private final Object target;
    private final String threadPoolId;
    private final AtomicLong rejectCount;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.rejectCount.incrementAndGet();
        if (ApplicationContextHolder.getInstance() != null) {
            try {
                ThreadPoolCheckAlarm alarmHandler = (ThreadPoolCheckAlarm)ApplicationContextHolder.getBean(ThreadPoolCheckAlarm.class);
                alarmHandler.asyncSendRejectedAlarm(this.threadPoolId);
            }
            catch (Throwable ex) {
                log.error("Failed to send rejection policy alert.", ex);
            }
        }
        try {
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
    }

    @Generated
    public RejectedProxyInvocationHandler(Object target, String threadPoolId, AtomicLong rejectCount) {
        this.target = target;
        this.threadPoolId = threadPoolId;
        this.rejectCount = rejectCount;
    }
}

