/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine.beetl;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.engine.beetl.BeetlTemplate;
import java.io.IOException;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.CompositeResourceLoader;
import org.beetl.core.resource.FileResourceLoader;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.core.resource.WebAppResourceLoader;

public class BeetlEngine
implements TemplateEngine {
    private GroupTemplate engine;

    public BeetlEngine() {
        this(new TemplateConfig());
    }

    public BeetlEngine(TemplateConfig config) {
        this(BeetlEngine.createEngine(config));
    }

    public BeetlEngine(GroupTemplate engine) {
        this.engine = engine;
    }

    @Override
    public Template getTemplate(String resource) {
        return BeetlTemplate.wrap(this.engine.getTemplate(resource));
    }

    private static GroupTemplate createEngine(TemplateConfig config) {
        if (null == config) {
            config = new TemplateConfig();
        }
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                return BeetlEngine.createGroupTemplate((ResourceLoader)new ClasspathResourceLoader(config.getPath(), config.getCharsetStr()));
            }
            case FILE: {
                return BeetlEngine.createGroupTemplate((ResourceLoader)new FileResourceLoader(config.getPath(), config.getCharsetStr()));
            }
            case WEB_ROOT: {
                return BeetlEngine.createGroupTemplate((ResourceLoader)new WebAppResourceLoader(config.getPath(), config.getCharsetStr()));
            }
            case STRING: {
                return BeetlEngine.createGroupTemplate((ResourceLoader)new StringTemplateResourceLoader());
            }
            case COMPOSITE: {
                return BeetlEngine.createGroupTemplate((ResourceLoader)new CompositeResourceLoader());
            }
        }
        return new GroupTemplate();
    }

    private static GroupTemplate createGroupTemplate(ResourceLoader loader) {
        try {
            return BeetlEngine.createGroupTemplate(loader, Configuration.defaultConfiguration());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    private static GroupTemplate createGroupTemplate(ResourceLoader loader, Configuration conf) {
        return new GroupTemplate(loader, conf);
    }
}

