/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine.freemarker;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateException;
import cn.hutool.extra.template.engine.freemarker.FreemarkerTemplate;
import cn.hutool.extra.template.engine.freemarker.SimpleStringTemplateLoader;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;

public class FreemarkerEngine
implements TemplateEngine {
    private Configuration cfg;

    public FreemarkerEngine() {
    }

    public FreemarkerEngine(TemplateConfig config) {
        this.init(config);
    }

    public FreemarkerEngine(Configuration freemarkerCfg) {
        this.init(freemarkerCfg);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        this.init(FreemarkerEngine.createCfg(config));
        return this;
    }

    private void init(Configuration freemarkerCfg) {
        this.cfg = freemarkerCfg;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.cfg) {
            this.init(TemplateConfig.DEFAULT);
        }
        try {
            return FreemarkerTemplate.wrap(this.cfg.getTemplate(resource));
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }

    private static Configuration createCfg(TemplateConfig config) {
        if (null == config) {
            config = new TemplateConfig();
        }
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
        cfg.setLocalizedLookup(false);
        cfg.setDefaultEncoding(config.getCharset().toString());
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(ClassUtil.getClassLoader(), config.getPath()));
                break;
            }
            case FILE: {
                try {
                    cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(FileUtil.file((String)config.getPath())));
                    break;
                }
                catch (IOException e) {
                    throw new IORuntimeException((Throwable)e);
                }
            }
            case WEB_ROOT: {
                try {
                    cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(FileUtil.file((File)FileUtil.getWebRoot(), (String)config.getPath())));
                    break;
                }
                catch (IOException e) {
                    throw new IORuntimeException((Throwable)e);
                }
            }
            case STRING: {
                cfg.setTemplateLoader((TemplateLoader)new SimpleStringTemplateLoader());
                break;
            }
        }
        return cfg;
    }
}

