/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.webservice;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.webservice.SoapProtocol;
import cn.hutool.http.webservice.SoapRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;

public class SoapClient {
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml;charset=";
    private String url;
    private Charset charset = CharsetUtil.CHARSET_UTF_8;
    private SOAPMessage message;
    private SOAPBodyElement methodEle;

    public static SoapClient create(String url) {
        return new SoapClient(url);
    }

    public static SoapClient create(String url, SoapProtocol protocol) {
        return new SoapClient(url, protocol);
    }

    public SoapClient(String url) {
        this(url, SoapProtocol.SOAP_1_1);
    }

    public SoapClient(String url, SoapProtocol protocol) {
        this.url = url;
        this.init(protocol);
    }

    public SoapClient init(SoapProtocol protocol) {
        try {
            MessageFactory factory = MessageFactory.newInstance((String)protocol.getValue());
            this.message = factory.createMessage();
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        return this;
    }

    public SoapClient setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public SoapClient setUrl(String url) {
        this.url = url;
        return this;
    }

    public SoapClient setHeader(QName name) {
        return this.setHeader(name, null, null, null, null);
    }

    public SoapClient setHeader(QName name, String actorURI, String roleUri, Boolean mustUnderstand, Boolean relay) {
        SOAPHeaderElement ele;
        try {
            SOAPHeader header = this.message.getSOAPHeader();
            ele = header.addHeaderElement(name);
            if (StrUtil.isNotBlank((CharSequence)roleUri)) {
                ele.setRole(roleUri);
            }
            if (null != relay) {
                ele.setRelay(relay.booleanValue());
            }
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        if (StrUtil.isNotBlank((CharSequence)actorURI)) {
            ele.setActor(actorURI);
        }
        if (null != mustUnderstand) {
            ele.setMustUnderstand(mustUnderstand.booleanValue());
        }
        return this;
    }

    public SoapClient setMethod(Name name, Map<String, Object> params, boolean useMethodPrefix) {
        return this.setMethod(new QName(name.getURI(), name.getLocalName(), name.getPrefix()), params, useMethodPrefix);
    }

    public SoapClient setMethod(QName name, Map<String, Object> params, boolean useMethodPrefix) {
        this.setMethod(name);
        String prefix = name.getPrefix();
        SOAPBodyElement methodEle = this.methodEle;
        for (Map.Entry entry : MapUtil.wrap(params)) {
            SoapClient.setParam((SOAPElement)methodEle, (String)entry.getKey(), entry.getValue(), prefix);
        }
        return this;
    }

    public SoapClient setMethod(String methodName) {
        return this.setMethod(methodName, "");
    }

    public SoapClient setMethod(String methodName, String namespaceURI) {
        List methodNameList = StrUtil.split((CharSequence)methodName, (char)':');
        QName qName = 2 == methodNameList.size() ? new QName(namespaceURI, (String)methodNameList.get(1), (String)methodNameList.get(0)) : new QName(namespaceURI, methodName);
        return this.setMethod(qName);
    }

    public SoapClient setMethod(QName name) {
        try {
            this.methodEle = this.message.getSOAPBody().addBodyElement(name);
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        return this;
    }

    public SoapClient setParam(String name, Object value) {
        return this.setParam(name, value, true);
    }

    public SoapClient setParam(String name, Object value, boolean useMethodPrefix) {
        SoapClient.setParam((SOAPElement)this.methodEle, name, value, useMethodPrefix ? this.methodEle.getPrefix() : null);
        return this;
    }

    public String getMsgStr(boolean pretty) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.message.writeTo((OutputStream)out);
        }
        catch (IOException | SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        return pretty ? XmlUtil.format((String)out.toString()) : out.toString();
    }

    public String send() {
        return this.send(false);
    }

    public String send(boolean pretty) {
        String res = HttpRequest.post(this.url).setFollowRedirects(true).contentType(this.getXmlContentType()).body(this.getMsgStr(false)).execute().body();
        return pretty ? XmlUtil.format((String)res) : res;
    }

    private String getXmlContentType() {
        return TEXT_XML_CONTENT_TYPE.concat(this.charset.toString());
    }

    private static SOAPElement setParam(SOAPElement ele, String name, Object value, String prefix) {
        SOAPElement childEle;
        try {
            childEle = StrUtil.isNotBlank((CharSequence)prefix) ? ele.addChildElement(name, prefix) : ele.addChildElement(name);
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        if (value instanceof CharSequence) {
            childEle.setValue(value.toString());
        } else if (value instanceof SOAPElement) {
            try {
                ele.addChildElement((SOAPElement)value);
            }
            catch (SOAPException e) {
                throw new SoapRuntimeException(e);
            }
        } else if (value instanceof Map) {
            Set set = ((Map)value).entrySet();
            Iterator i$ = set.iterator();
            while (i$.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = i$.next();
                SoapClient.setParam(childEle, entry.getKey().toString(), entry.getValue(), prefix);
            }
        }
        return childEle;
    }
}

