/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.commom;

import cn.jiguang.commom.utils.Base64;
import cn.jiguang.commom.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.text.SimpleDateFormat;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceHelper.class);
    private static final Pattern PUSH_PATTERNS = Pattern.compile("[^a-zA-Z0-9]");
    private static final String BASIC_PREFIX = "Basic";
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final int MIN = 100000;
    private static final int MAX = Integer.MAX_VALUE;
    private static final int MAX_BADGE_NUMBER = 99999;
    private static final Pattern USERNAME_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z_0-9.\u3001\u3002@,-]*");
    private static final Pattern DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public static boolean isValidIntBadge(int intBadge) {
        return intBadge >= 0 && intBadge <= 99999;
    }

    public static int generateSendno() {
        return RANDOM.nextInt(2147383648) + 100000;
    }

    public static String getBasicAuthorization(String username, String password) {
        String encodeKey = username + ":" + password;
        return "Basic " + String.valueOf(Base64.encode(encodeKey.getBytes()));
    }

    public static void checkBasic(String appKey, String masterSecret) {
        if (StringUtils.isEmpty(appKey) || StringUtils.isEmpty(masterSecret)) {
            throw new IllegalArgumentException("appKey and masterSecret are both required.");
        }
        if (appKey.length() != 24 || masterSecret.length() != 24 || PUSH_PATTERNS.matcher(appKey).find() || PUSH_PATTERNS.matcher(masterSecret).find()) {
            throw new IllegalArgumentException("appKey and masterSecret format is incorrect. They should be 24 size, and be composed with alphabet and numbers. Please confirm that they are coming from JPush Web Portal.");
        }
    }

    public static JsonArray fromSet(Set<String> sets) {
        JsonArray array = new JsonArray();
        if (null != sets && sets.size() > 0) {
            for (String item : sets) {
                array.add((JsonElement)new JsonPrimitive(item));
            }
        }
        return array;
    }

    public static boolean checkUsername(String username) {
        return USERNAME_PATTERN.matcher(username).matches();
    }

    public static boolean isValidBirthday(String birthday) {
        try {
            if (!DATE_PATTERN.matcher(birthday).matches()) {
                return false;
            }
            DATE_FORMAT.parse(birthday);
        }
        catch (Exception e) {
            LOG.error("incorrect date format. " + birthday, (Throwable)e);
            return false;
        }
        return true;
    }

    static {
        DATE_FORMAT.setLenient(false);
    }
}

