/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.common.connection;

import cn.jiguang.common.connection.NettyHttpClient;
import cn.jiguang.common.resp.ResponseWrapper;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpResponseHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseHandler.class);
    private int status;
    private NettyHttpClient.BaseCallback _callback;
    private CountDownLatch _latch;
    private ResponseWrapper _wrapper = new ResponseWrapper();

    public HttpResponseHandler(NettyHttpClient.BaseCallback callback, CountDownLatch latch) {
        this._callback = callback;
        this._latch = latch;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            this.status = response.status().code();
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            LOG.info(content.content().toString());
            String responseContent = content.content().toString(CharsetUtil.UTF_8);
            this._wrapper.responseCode = this.status;
            this._wrapper.responseContent = responseContent;
            if (null != this._latch) {
                this._latch.countDown();
            }
            if (null != this._callback) {
                this._callback.onSucceed(this._wrapper);
            }
            if (content instanceof LastHttpContent) {
                LOG.info("closing connection");
                ctx.close();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("error:", cause);
        try {
            ctx.close();
            if (null != this._latch) {
                this._latch.countDown();
            }
        }
        catch (Exception ex) {
            LOG.error("close error:", (Throwable)ex);
        }
    }

    public void resetLatch(CountDownLatch latch) {
        this._latch = latch;
    }

    public ResponseWrapper getResponse() {
        return this._wrapper;
    }
}

