/*
 * Decompiled with CFR 0.152.
 */
package org.seimicrawler.xpath.core;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.select.Elements;
import org.seimicrawler.xpath.exception.XpathParserException;

public class XValue
implements Comparable<XValue> {
    private Object value;
    private boolean isAttr = false;
    private boolean isExprStr = false;

    public XValue(Object val) {
        this.value = val;
    }

    public static XValue create(Object val) {
        return new XValue(val);
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public boolean isElements() {
        return this.value instanceof Elements;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isList() {
        return this.value instanceof List;
    }

    public Boolean asBoolean() {
        return (Boolean)this.value;
    }

    public Double asDouble() {
        if (this.value instanceof String) {
            return new BigDecimal((String)this.value).doubleValue();
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        throw new XpathParserException("cast to number fail. vale = " + this.value);
    }

    public Long asLong() {
        if (this.value instanceof String) {
            return new BigDecimal((String)this.value).setScale(0, 4).longValue();
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        throw new XpathParserException("cast to number fail. vale = " + this.value);
    }

    public Elements asElements() {
        return (Elements)this.value;
    }

    public String asString() {
        if (this.value instanceof List) {
            return Joiner.on((char)',').join((Iterable)((List)this.value));
        }
        return ((String)this.value).trim();
    }

    public List<String> asList() {
        return (List)this.value;
    }

    public XValue attr() {
        this.isAttr = true;
        return this;
    }

    public boolean isAttr() {
        return this.isAttr;
    }

    public XValue exprStr() {
        this.isExprStr = true;
        String str = StringUtils.removeStart((String)String.valueOf(this.value), (String)"'");
        str = StringUtils.removeStart((String)str, (String)"\"");
        str = StringUtils.removeEnd((String)str, (String)"'");
        this.value = StringUtils.removeEnd((String)str, (String)"\"");
        return this;
    }

    public boolean isExprStr() {
        return this.isExprStr;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("isAttr", this.isAttr).add("isExprStr", this.isExprStr).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XValue value1 = (XValue)o;
        return Objects.equal((Object)this.value, (Object)value1.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    @Override
    public int compareTo(XValue o) {
        if (this.equals(o)) {
            return 0;
        }
        if (o == null || o.value == null) {
            return 1;
        }
        if (this.value == null) {
            return -1;
        }
        ComparisonChain chain = ComparisonChain.start();
        if (this.isString()) {
            return chain.compare((Comparable)((Object)this.asString()), (Comparable)((Object)o.asString())).result();
        }
        if (this.isNumber()) {
            return chain.compare((Comparable)this.asDouble(), (Comparable)o.asDouble()).result();
        }
        throw new XpathParserException("Unsupported comparable XValue = " + this.toString());
    }
}

