/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.convertor;

import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldMeta;
import cn.zhxu.bs.bean.DbType;
import cn.zhxu.bs.util.StringUtils;

public class BoolParamConvertor
implements FieldConvertor.ParamConvertor {
    private String[] falseValues = new String[]{"0", "OFF", "FALSE", "N", "NO", "F"};

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        return meta.getDbType() == DbType.BOOL && (String.class == valueType || Number.class.isAssignableFrom(valueType) || Boolean.class == valueType);
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if (StringUtils.isBlank(s)) {
                return null;
            }
            for (String f : this.falseValues) {
                if (!s.equalsIgnoreCase(f)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        return null;
    }

    public String[] getFalseValues() {
        return this.falseValues;
    }

    public void setFalseValues(String[] falseValues) {
        this.falseValues = falseValues;
    }
}

