/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.convertor;

import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldMeta;
import cn.zhxu.bs.bean.DbType;
import cn.zhxu.bs.util.StringUtils;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class DateTimeParamConvertor
implements FieldConvertor.ParamConvertor {
    static final Pattern DATETIME_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{1,2}-[0-9]{1,2}(?: [0-9]{1,2}(?::[0-9]{1,2}(?::[0-9]{1,2}(?:\\.[0-9]{1,3})?)?)?)?");
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-").appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NOT_NEGATIVE).appendPattern("-").appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendPattern(" ").appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).appendPattern(":").appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NOT_NEGATIVE).appendPattern(":").appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).appendPattern(".").appendValue(ChronoField.MILLI_OF_SECOND, 1, 3, SignStyle.NOT_NEGATIVE).toFormatter();
    private TimeZone timeZone = TimeZone.getDefault();
    private Target target = Target.SQL_TIMESTAMP;
    private transient ZoneId zoneId;
    private transient ZoneOffset offset;

    public DateTimeParamConvertor() {
    }

    public DateTimeParamConvertor(Target target) {
        this.target = Objects.requireNonNull(target);
    }

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        return meta.getDbType() == DbType.DATETIME && (String.class == valueType || java.util.Date.class.isAssignableFrom(valueType) || LocalDate.class == valueType || LocalDateTime.class == valueType || Long.class == valueType);
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        if (value instanceof String) {
            String str = ((String)value).trim();
            if (StringUtils.isBlank(str)) {
                return null;
            }
            if (StringUtils.isNumeric(str)) {
                return this.toTargetType(Long.parseLong(str));
            }
            String datetime = str.replaceAll("/", "-");
            if (DATETIME_PATTERN.matcher(datetime).matches()) {
                return this.toTargetType(LocalDateTime.parse(this.normalize(datetime), FORMATTER));
            }
            return null;
        }
        if (value instanceof java.util.Date) {
            if (this.target == Target.LOCAL_DATE_TIME) {
                if (value instanceof Date) {
                    LocalDate localDate = ((Date)value).toLocalDate();
                    return LocalDateTime.of(localDate, LocalTime.of(0, 0, 0, 0));
                }
                return LocalDateTime.ofInstant(((java.util.Date)value).toInstant(), this.getZoneId());
            }
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalDate) {
            return this.toTargetType(((LocalDate)value).atTime(0, 0, 0));
        }
        if (value instanceof LocalDateTime) {
            return this.toTargetType((LocalDateTime)value);
        }
        if (value instanceof Long) {
            return this.toTargetType((Long)value);
        }
        return null;
    }

    protected Object toTargetType(long epochMilli) {
        if (this.target == Target.SQL_TIMESTAMP) {
            return new Timestamp(epochMilli);
        }
        Instant instant = Instant.ofEpochMilli(epochMilli);
        return LocalDateTime.ofInstant(instant, this.getZoneId());
    }

    protected Object toTargetType(LocalDateTime dateTime) {
        if (this.target == Target.SQL_TIMESTAMP) {
            Instant instant = dateTime.toInstant(this.getZoneOffset());
            return new Timestamp(instant.toEpochMilli());
        }
        return dateTime;
    }

    protected String normalize(String datetime) {
        int spaceIdx = datetime.indexOf(32);
        if (spaceIdx < 0) {
            return datetime + " 00:00:00.000";
        }
        int colonIdx1 = datetime.indexOf(58, spaceIdx + 1);
        if (colonIdx1 < 0) {
            return datetime + ":00:00.000";
        }
        int colonIdx2 = datetime.indexOf(58, colonIdx1 + 1);
        if (colonIdx2 < 0) {
            return datetime + ":00.000";
        }
        int dotIdx = datetime.indexOf(46, colonIdx2 + 1);
        if (dotIdx < 0) {
            return datetime + ".000";
        }
        return datetime;
    }

    public ZoneId getZoneId() {
        if (this.zoneId != null) {
            return this.zoneId;
        }
        this.zoneId = this.timeZone.toZoneId();
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        if (zoneId != null) {
            this.timeZone = TimeZone.getTimeZone(zoneId);
            this.zoneId = zoneId;
            this.offset = null;
        }
    }

    public ZoneOffset getZoneOffset() {
        if (this.offset != null) {
            return this.offset;
        }
        this.offset = ZoneOffset.ofTotalSeconds(this.timeZone.getRawOffset() / 1000);
        return this.offset;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = Objects.requireNonNull(target);
    }

    public static enum Target {
        SQL_TIMESTAMP,
        LOCAL_DATE_TIME;

    }
}

