/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.filter;

import cn.zhxu.bs.BeanMeta;
import cn.zhxu.bs.IllegalParamException;
import cn.zhxu.bs.ParamFilter;
import java.util.Map;

public class SizeLimitParamFilter
implements ParamFilter {
    private final int maxParaMapSize;

    public SizeLimitParamFilter() {
        this(150);
    }

    public SizeLimitParamFilter(int maxParaMapSize) {
        this.maxParaMapSize = maxParaMapSize;
    }

    @Override
    public <T> Map<String, Object> doFilter(BeanMeta<T> beanMeta, Map<String, Object> paraMap) throws IllegalParamException {
        int size = paraMap.size();
        if (size > this.maxParaMapSize) {
            throw new IllegalParamException("A too large paraMap sized of " + size + ", max allowed " + this.maxParaMapSize);
        }
        return paraMap;
    }

    public int getMaxParaMapSize() {
        return this.maxParaMapSize;
    }
}

