/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.filter;

import cn.zhxu.bs.BeanMeta;
import cn.zhxu.bs.FieldOpPool;
import cn.zhxu.bs.ParamFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SuffixOpParamFilter
implements ParamFilter {
    private final FieldOpPool fieldOpPool;
    private final String separator;
    private final String operatorKey;

    public SuffixOpParamFilter() {
        this(FieldOpPool.DEFAULT, "-", "op");
    }

    public SuffixOpParamFilter(String separator, String operatorKey) {
        this(FieldOpPool.DEFAULT, separator, operatorKey);
    }

    public SuffixOpParamFilter(FieldOpPool fieldOpPool, String separator, String operatorKey) {
        this.fieldOpPool = Objects.requireNonNull(fieldOpPool);
        this.separator = Objects.requireNonNull(separator);
        this.operatorKey = Objects.requireNonNull(operatorKey);
    }

    @Override
    public <T> Map<String, Object> doFilter(BeanMeta<T> beanMeta, Map<String, Object> paraMap) {
        HashMap<String, Object> newMap = null;
        for (Map.Entry<String, Object> entry : paraMap.entrySet()) {
            String opName;
            int idx;
            String key = entry.getKey();
            if (key == null || (idx = key.indexOf(this.separator)) < 1 || idx >= key.length() - 1 || this.fieldOpPool.getFieldOp(opName = key.substring(idx + 1)) == null) continue;
            if (newMap == null) {
                newMap = new HashMap<String, Object>();
            }
            String field = key.substring(0, idx);
            Object value = entry.getValue();
            if (value instanceof String[]) {
                String[] vs = (String[])value;
                for (int i = 0; i < vs.length; ++i) {
                    newMap.put(field + this.separator + i, vs[i]);
                }
            } else {
                newMap.put(field, value);
            }
            newMap.put(field + this.separator + this.operatorKey, opName);
        }
        if (newMap != null) {
            paraMap.putAll(newMap);
        }
        return paraMap;
    }

    public FieldOpPool getFieldOpPool() {
        return this.fieldOpPool;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getOperatorKey() {
        return this.operatorKey;
    }
}

