/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.implement;

import cn.zhxu.bs.BeanMeta;
import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldMeta;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOpPool;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.IllegalParamException;
import cn.zhxu.bs.PageExtractor;
import cn.zhxu.bs.ParamFilter;
import cn.zhxu.bs.ParamResolver;
import cn.zhxu.bs.SearchParam;
import cn.zhxu.bs.convertor.BoolParamConvertor;
import cn.zhxu.bs.convertor.DateParamConvertor;
import cn.zhxu.bs.convertor.DateTimeParamConvertor;
import cn.zhxu.bs.convertor.EnumParamConvertor;
import cn.zhxu.bs.convertor.NumberParamConvertor;
import cn.zhxu.bs.convertor.TimeParamConvertor;
import cn.zhxu.bs.filter.ArrayValueParamFilter;
import cn.zhxu.bs.filter.SizeLimitParamFilter;
import cn.zhxu.bs.group.DefaultGroupResolver;
import cn.zhxu.bs.group.Group;
import cn.zhxu.bs.group.GroupResolver;
import cn.zhxu.bs.implement.PageSizeExtractor;
import cn.zhxu.bs.operator.Equal;
import cn.zhxu.bs.param.FetchType;
import cn.zhxu.bs.param.FieldParam;
import cn.zhxu.bs.param.OrderBy;
import cn.zhxu.bs.param.Paging;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapWrapper;
import cn.zhxu.bs.util.ObjectUtils;
import cn.zhxu.bs.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DefaultParamResolver
implements ParamResolver {
    public static final Pattern INDEX_PATTERN = Pattern.compile("\\d+");
    private PageExtractor pageExtractor = new PageSizeExtractor();
    private List<ParamFilter> paramFilters = new ArrayList<ParamFilter>();
    private List<FieldConvertor.ParamConvertor> convertors = new ArrayList<FieldConvertor.ParamConvertor>();
    private FieldOpPool fieldOpPool = FieldOpPool.DEFAULT;
    private GroupResolver groupResolver = new DefaultGroupResolver();
    private ParamResolver.Configuration configuration = new ParamResolver.Configuration();

    public DefaultParamResolver() {
        this.convertors.add(new BoolParamConvertor());
        this.convertors.add(new NumberParamConvertor());
        this.convertors.add(new DateParamConvertor());
        this.convertors.add(new TimeParamConvertor());
        this.convertors.add(new DateTimeParamConvertor());
        this.convertors.add(new EnumParamConvertor());
        this.paramFilters.add(new SizeLimitParamFilter());
        this.paramFilters.add(new ArrayValueParamFilter());
    }

    public DefaultParamResolver(List<FieldConvertor.ParamConvertor> convertors, List<ParamFilter> paramFilters) {
        this.setConvertors(convertors);
        this.setParamFilters(paramFilters);
    }

    @Override
    public SearchParam resolve(BeanMeta<?> beanMeta, FetchType fetchType, Map<String, Object> paraMap) throws IllegalParamException {
        for (ParamFilter filter : this.paramFilters) {
            if (paraMap == null) {
                paraMap = new HashMap<String, Object>();
            }
            paraMap = filter.doFilter(beanMeta, paraMap);
        }
        if (paraMap == null) {
            paraMap = Collections.emptyMap();
        }
        return this.doResolve(beanMeta, fetchType, paraMap);
    }

    public SearchParam doResolve(BeanMeta<?> beanMeta, FetchType fetchType, Map<String, Object> paraMap) throws IllegalParamException {
        List<String> fetchFields = this.resolveFetchFields(beanMeta, fetchType, paraMap);
        Group<List<FieldParam>> paramsGroup = this.resolveParamsGroup(beanMeta.getFieldMetas(), paraMap);
        Paging paging = this.resolvePaging(fetchType, paraMap);
        SearchParam searchParam = new SearchParam(paraMap, fetchType, fetchFields, paramsGroup, paging);
        if (fetchType.shouldQueryList() && beanMeta.isSortable()) {
            Set<String> fieldSet = beanMeta.getFieldSet();
            for (OrderBy orderBy : this.resolveOrderBys(paraMap)) {
                if (orderBy.isValid(fieldSet)) {
                    searchParam.addOrderBy(orderBy);
                    continue;
                }
                throw new IllegalParamException("Invalid " + orderBy + " on " + beanMeta.getBeanClass());
            }
        }
        return searchParam;
    }

    public Paging resolvePaging(FetchType fetchType, Map<String, Object> paraMap) throws IllegalParamException {
        if (fetchType.canPaging()) {
            Paging paging = this.pageExtractor.extract(paraMap);
            if (fetchType.isFetchFirst()) {
                paging.setSize(1);
            }
            return paging;
        }
        return null;
    }

    public List<String> resolveFetchFields(BeanMeta<?> beanMeta, FetchType fetchType, Map<String, Object> paraMap) {
        if (fetchType.shouldQueryList() || beanMeta.isDistinctOrGroupBy()) {
            List<String> fieldList = beanMeta.getSelectFields();
            List onlySelect = ObjectUtils.toList(this.getOnlySelect(paraMap)).stream().filter(fieldList::contains).collect(Collectors.toList());
            List<String> selectExclude = ObjectUtils.toList(this.getSelectExclude(paraMap));
            return (onlySelect.isEmpty() ? fieldList : onlySelect).stream().filter(f -> !selectExclude.contains(f)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected Object getSelectExclude(Map<String, Object> paraMap) {
        Object value = paraMap.get(MapBuilder.SELECT_EXCLUDE);
        if (value != null) {
            return value;
        }
        return paraMap.get(this.configuration.selectExclude());
    }

    protected Object getOnlySelect(Map<String, Object> paraMap) {
        Object value = paraMap.get(MapBuilder.ONLY_SELECT);
        if (value != null) {
            return value;
        }
        return paraMap.get(this.configuration.onlySelect());
    }

    public Group<List<FieldParam>> resolveParamsGroup(Collection<FieldMeta> fieldMetas, Map<String, Object> paraMap) throws IllegalParamException {
        HashMap holder = new HashMap();
        return this.groupResolver.resolve(this.getGroupExpr(paraMap)).transform(gKey -> {
            List<FieldParam> params = (List<FieldParam>)holder.get(gKey);
            if (params == null) {
                MapWrapper mapWrapper = gKey != null ? new MapWrapper(paraMap, (String)gKey, this.configuration.groupSeparator()) : new MapWrapper(paraMap);
                params = this.extractFieldParams(fieldMetas, mapWrapper);
                holder.put(gKey, params);
            }
            return params;
        }).filter(list -> !list.isEmpty());
    }

    protected String getGroupExpr(Map<String, Object> paraMap) throws IllegalParamException {
        String gExpr = ObjectUtils.string(paraMap.get(MapBuilder.GROUP_EXPR));
        String expr = ObjectUtils.string(paraMap.get(this.configuration.gexpr()));
        if (StringUtils.isBlank(gExpr)) {
            gExpr = expr;
        } else if (this.configuration.gexprMerge() && StringUtils.isNotBlank(expr)) {
            gExpr = '(' + gExpr + ')' + '&' + '(' + expr + ')';
        }
        if (StringUtils.isNotBlank(gExpr)) {
            if (gExpr.contains("$")) {
                throw new IllegalParamException("Invalid groupExpr [" + gExpr + "] because of containing '" + "$" + "'.");
            }
            gExpr = "$&(" + gExpr + ')';
        }
        return gExpr;
    }

    protected List<FieldParam> extractFieldParams(Collection<FieldMeta> fieldMetas, MapWrapper paraMap) {
        HashMap<String, Set<Integer>> fieldIndicesMap = new HashMap<String, Set<Integer>>();
        for (String key : paraMap.keySet()) {
            String suffix;
            int index = key.lastIndexOf(this.configuration.separator());
            if (index > 0 && key.length() > index + 1 && INDEX_PATTERN.matcher(suffix = key.substring(index + 1)).matches()) {
                String field = key.substring(0, index);
                this.mapFieldIndex(fieldIndicesMap, field, Integer.parseInt(suffix));
            }
            this.mapFieldIndex(fieldIndicesMap, key, 0);
        }
        ArrayList<FieldParam> fieldParams = new ArrayList<FieldParam>();
        for (FieldMeta meta : fieldMetas) {
            Set indices;
            FieldParam param;
            if (!meta.isConditional() || (param = this.toFieldParam(meta, indices = (Set)fieldIndicesMap.get(meta.getName()), paraMap)) == null) continue;
            fieldParams.add(param);
        }
        return fieldParams;
    }

    protected void mapFieldIndex(Map<String, Set<Integer>> fieldIndicesKeysMap, String field, int index) {
        fieldIndicesKeysMap.computeIfAbsent(field, k -> new HashSet(2)).add(index);
    }

    protected FieldParam getFieldParam(MapWrapper paraMap, String field) {
        Object value = paraMap.get0(MapBuilder.FIELD_PARAM + field);
        if (value instanceof FieldParam) {
            return (FieldParam)value;
        }
        return null;
    }

    protected FieldParam toFieldParam(FieldMeta meta, Set<Integer> indices, MapWrapper paraMap) {
        ArrayList<FieldParam.Value> values;
        FieldParam param;
        String field = meta.getName();
        FieldOp operator = this.allowedOperator(this.toOperator(field, paraMap, param = this.getFieldParam(paraMap, field)), meta.getOnlyOn());
        if (operator == null) {
            return null;
        }
        if (operator.lonely()) {
            if (param == null) {
                return new FieldParam(field, operator);
            }
            return new FieldParam(field, operator, param.getValueList(), param.isIgnoreCase());
        }
        if ((indices == null || indices.isEmpty()) && param == null) {
            return null;
        }
        ArrayList<FieldParam.Value> arrayList = values = param != null ? param.getValueList() : new ArrayList<FieldParam.Value>();
        if (values.isEmpty() && indices != null) {
            for (int index : indices) {
                Object value = paraMap.get1(field + this.configuration.separator() + index);
                if (index == 0 && value == null) {
                    value = paraMap.get1(field);
                }
                value = this.convertParamValue(meta, value);
                values.add(new FieldParam.Value(value, index));
            }
        } else if (!values.isEmpty()) {
            for (int index = 0; index < values.size(); ++index) {
                FieldParam.Value value = (FieldParam.Value)values.get(index);
                if (value == null) continue;
                Object v = this.convertParamValue(meta, value.getValue());
                values.set(index, new FieldParam.Value(v, index));
            }
        }
        if (this.isAllEmpty(values)) {
            return null;
        }
        Boolean ignoreCase = null;
        if (param != null) {
            ignoreCase = param.isIgnoreCase();
        }
        if (ignoreCase == null) {
            ignoreCase = ObjectUtils.toBoolean(paraMap.get1(field + this.configuration.icSuffix()));
        }
        return new FieldParam(field, operator, values, ignoreCase);
    }

    protected Object convertParamValue(FieldMeta meta, Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = meta.getDbType().getType();
        if (type != null && type.isInstance(value)) {
            return value;
        }
        Class<?> vType = value.getClass();
        for (FieldConvertor.ParamConvertor convertor : this.convertors) {
            if (!convertor.supports(meta, vType)) continue;
            return convertor.convert(meta, value);
        }
        return value;
    }

    protected boolean isAllEmpty(List<FieldParam.Value> values) {
        for (FieldParam.Value value : values) {
            if (value.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected FieldOp toOperator(String field, MapWrapper paraMap, FieldParam param) {
        if (param != null) {
            FieldOp fieldOp;
            Object op = param.getOperator();
            if (op instanceof FieldOp && (fieldOp = (FieldOp)op).isNonPublic()) {
                return fieldOp;
            }
            if (op != null) {
                return this.fieldOpPool.getFieldOp(op);
            }
        }
        Object value = paraMap.get1(field + this.configuration.opSuffix());
        return this.fieldOpPool.getFieldOp(value);
    }

    protected FieldOp allowedOperator(FieldOp op, Class<? extends FieldOp>[] onlyOn) {
        if (op == null) {
            Equal tOp = onlyOn.length == 0 ? FieldOps.Equal : onlyOn[0];
            return this.fieldOpPool.getFieldOp(tOp);
        }
        if (onlyOn.length == 0) {
            return op;
        }
        Class<?> opCls = op.getClass();
        for (Class<? extends FieldOp> clazz : onlyOn) {
            if (clazz != opCls) continue;
            return op;
        }
        return this.fieldOpPool.getFieldOp(onlyOn[0]);
    }

    public List<OrderBy> resolveOrderBys(Map<String, Object> paraMap) {
        Object list = paraMap.get(MapBuilder.ORDER_BY);
        if (list instanceof List) {
            List orderBys = (List)list;
            return orderBys;
        }
        String string = ObjectUtils.string(paraMap.get(this.configuration.orderBy()));
        if (StringUtils.isNotBlank(string)) {
            return Arrays.stream(string.split(",")).map(str -> {
                String[] splits = str.split(":");
                if (splits.length == 1 && StringUtils.isNotBlank(splits[0])) {
                    return new OrderBy(splits[0], null);
                }
                if (splits.length == 2 && StringUtils.isNotBlank(splits[0])) {
                    return new OrderBy(splits[0], splits[1]);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        String sort = ObjectUtils.string(paraMap.get(this.configuration.sort()));
        String order = ObjectUtils.string(paraMap.get(this.configuration.order()));
        if (StringUtils.isNotBlank(sort)) {
            return Collections.singletonList(new OrderBy(sort, order));
        }
        return Collections.emptyList();
    }

    public PageExtractor getPageExtractor() {
        return this.pageExtractor;
    }

    public void setPageExtractor(PageExtractor pageExtractor) {
        this.pageExtractor = Objects.requireNonNull(pageExtractor);
    }

    public List<ParamFilter> getParamFilters() {
        return this.paramFilters;
    }

    public void addParamFilter(ParamFilter paramFilter) {
        this.paramFilters.add(Objects.requireNonNull(paramFilter));
    }

    public void setParamFilters(List<ParamFilter> paramFilters) {
        this.paramFilters = Objects.requireNonNull(paramFilters);
    }

    public FieldOpPool getFieldOpPool() {
        return this.fieldOpPool;
    }

    public void setFieldOpPool(FieldOpPool fieldOpPool) {
        this.fieldOpPool = Objects.requireNonNull(fieldOpPool);
    }

    public GroupResolver getGroupResolver() {
        return this.groupResolver;
    }

    public void setGroupResolver(GroupResolver groupResolver) {
        this.groupResolver = Objects.requireNonNull(groupResolver);
    }

    public List<FieldConvertor.ParamConvertor> getConvertors() {
        return this.convertors;
    }

    public void setConvertors(List<FieldConvertor.ParamConvertor> convertors) {
        this.convertors = Objects.requireNonNull(convertors);
    }

    public void addConvertor(FieldConvertor.ParamConvertor convertor) {
        this.convertors.add(Objects.requireNonNull(convertor));
    }

    public ParamResolver.Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ParamResolver.Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }
}

