/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.util;

import cn.zhxu.bs.util.Cache;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LRUCache<T>
extends LinkedHashMap<String, T>
implements Cache<T> {
    private int maxCacheCount;
    private final Lock lock = new ReentrantLock();

    public LRUCache(int maxCacheCount) {
        super(maxCacheCount, 1.0f, true);
        this.maxCacheCount = maxCacheCount;
    }

    @Override
    public T get(String key) {
        this.lock.lock();
        try {
            Object v = super.get(key);
            return (T)v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void cache(String key, T value) {
        this.lock.lock();
        try {
            this.put(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry eldest) {
        return this.size() > this.maxCacheCount;
    }

    public int getMaxCacheCount() {
        return this.maxCacheCount;
    }

    public void setMaxCacheCount(int maxCacheCount) {
        this.maxCacheCount = maxCacheCount;
    }
}

