/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.org.eclipse.aether.transfer.AbstractTransferListener;
import capsule.org.eclipse.aether.transfer.MetadataNotFoundException;
import capsule.org.eclipse.aether.transfer.TransferEvent;
import capsule.org.eclipse.aether.transfer.TransferResource;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ConsoleTransferListener
extends AbstractTransferListener {
    private final PrintStream out;
    private final Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
    private int lastLength;
    private final boolean verbose;

    public ConsoleTransferListener(boolean verbose, PrintStream out) {
        this.out = out;
        this.verbose = verbose;
    }

    @Override
    public void transferInitiated(TransferEvent event) {
        String message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        this.verbose(message + ": " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
    }

    @Override
    public void transferProgressed(TransferEvent event) {
        TransferResource resource = event.getResource();
        this.downloads.put(resource, event.getTransferredBytes());
        StringBuilder buffer = new StringBuilder(64);
        for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
            long total = entry.getKey().getContentLength();
            long complete = entry.getValue();
            buffer.append(this.getStatus(complete, total)).append("  ");
        }
        int pad = this.lastLength - buffer.length();
        this.lastLength = buffer.length();
        ConsoleTransferListener.pad(buffer, pad);
        buffer.append('\r');
        this.out.print(buffer);
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return ConsoleTransferListener.toKB(complete) + "/" + ConsoleTransferListener.toKB(total) + " KB ";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B ";
        }
        if (complete >= 1024L) {
            return ConsoleTransferListener.toKB(complete) + " KB ";
        }
        return complete + " B ";
    }

    @Override
    public void transferSucceeded(TransferEvent event) {
        this.transferCompleted(event);
        if (!this.verbose) {
            return;
        }
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? ConsoleTransferListener.toKB(contentLength) + " KB" : contentLength + " B";
            String throughput = "";
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            if (duration > 0L) {
                long bytes = contentLength - resource.getResumeOffset();
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)bytes / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            this.println(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + throughput + ")");
        }
    }

    @Override
    public void transferFailed(TransferEvent event) {
        this.transferCompleted(event);
        if (!(event.getException() instanceof MetadataNotFoundException)) {
            this.println("Transfer failed: " + event.getException() + (this.verbose ? "" : " (for stack trace, run with -Dcapsule.log=verbose)"));
            if (this.verbose) {
                event.getException().printStackTrace(this.out);
            }
        }
    }

    @Override
    public void transferCorrupted(TransferEvent event) {
        this.println("Transfer corrupted: " + event.getException() + (this.verbose ? "" : " (for stack trace, run with -Dcapsule.log=verbose)"));
        if (this.verbose) {
            event.getException().printStackTrace(this.out);
        }
    }

    private void transferCompleted(TransferEvent event) {
        this.downloads.remove(event.getResource());
        StringBuilder buffer = new StringBuilder(64);
        ConsoleTransferListener.pad(buffer, this.lastLength);
        buffer.append('\r');
        this.out.print(buffer);
    }

    private static long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }

    private static void pad(StringBuilder buffer, int spaces) {
        String block = "                                        ";
        while (spaces > 0) {
            int n = Math.min(spaces, "                                        ".length());
            buffer.append("                                        ", 0, n);
            spaces -= n;
        }
    }

    private void println(String str) {
        this.out.println(str);
    }

    private void verbose(String str) {
        if (this.verbose) {
            this.println(str);
        }
    }
}

