/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.org.eclipse.aether.repository.Proxy;
import capsule.org.eclipse.aether.repository.ProxySelector;
import capsule.org.eclipse.aether.repository.RemoteRepository;
import capsule.org.eclipse.aether.util.repository.AuthenticationBuilder;
import capsule.org.eclipse.aether.util.repository.DefaultProxySelector;
import java.util.Map;
import java.util.Properties;

public class SystemProxySelector
implements ProxySelector {
    private final int logLevel;
    private final DefaultProxySelector target = new DefaultProxySelector();
    private final Map<String, String> env;
    private final Properties props;
    private int count;

    public SystemProxySelector(int logLevel) {
        this(System.getenv(), System.getProperties(), logLevel);
    }

    SystemProxySelector(Map env, Properties props, int logLevel) {
        this.env = env;
        this.props = props;
        this.logLevel = logLevel;
        this.init();
    }

    @Override
    public Proxy getProxy(RemoteRepository repository) {
        return this.target.getProxy(repository);
    }

    protected void init() {
        this.addProxyFromProperties("http");
        this.addProxyFromProperties("https");
        this.addProxyFromEnv("http");
        this.addProxyFromEnv("https");
        this.addProxyFromEnv("HTTP");
        this.addProxyFromEnv("HTTPS");
    }

    protected void addProxyFromEnv(String type) {
        Proxy proxy;
        this.checkValidProtocol(type);
        String key = type + (this.isUpper(type) ? "_PROXY" : "_proxy");
        String[] items = SystemProxySelector.parseProxy(this.env.get(key), "http".equals(type) ? "80" : "443");
        if (items == null) {
            return;
        }
        String[] credentials = SystemProxySelector.parseCredentials(this.env.get(key));
        String noProxy = this.env.get(this.isUpper(type) ? "NO_PROXY" : "no_proxy");
        if (noProxy != null) {
            noProxy = noProxy.replace(',', '|');
        }
        if (credentials != null) {
            AuthenticationBuilder authenticationBuilder = new AuthenticationBuilder();
            authenticationBuilder.addUsername(credentials[0]);
            if (credentials[1] != null) {
                authenticationBuilder.addPassword(credentials[1]);
            }
            proxy = new Proxy(type.toLowerCase(), items[0], Integer.parseInt(items[1]), authenticationBuilder.build());
        } else {
            proxy = new Proxy(type.toLowerCase(), items[0], Integer.parseInt(items[1]));
        }
        this.target.add(proxy, noProxy);
        ++this.count;
        if (this.isLogging(2)) {
            this.log(2, String.format("Adding `%s` proxy: %s [from system environment]", type, proxy));
        }
    }

    protected void addProxyFromProperties(String type) {
        Proxy proxy;
        this.checkValidProtocol(type);
        String host = this.props.getProperty(type + ".proxyHost");
        if (host == null || host.isEmpty()) {
            return;
        }
        String port = this.props.getProperty(type + ".proxyPort");
        if (port == null || port.isEmpty()) {
            port = "http".equals(type) ? "80" : "443";
        }
        String nonProxy = this.props.getProperty(type + ".nonProxyHosts");
        String username = this.props.getProperty(type + ".proxyUser");
        String password = this.props.getProperty(type + ".proxyPassword");
        if (username != null) {
            AuthenticationBuilder authenticationBuilder = new AuthenticationBuilder();
            authenticationBuilder.addUsername(username);
            if (password != null) {
                authenticationBuilder.addPassword(password);
            }
            proxy = new Proxy(type, host, Integer.parseInt(port), authenticationBuilder.build());
        } else {
            proxy = new Proxy(type, host, Integer.parseInt(port));
        }
        this.target.add(proxy, nonProxy);
        ++this.count;
        if (this.isLogging(2)) {
            this.log(2, String.format("Adding `%s` proxy: %s [from Java system properties]", type, proxy));
        }
    }

    static String[] parseCredentials(String url) {
        String[] result = new String[2];
        if (url == null || url.isEmpty()) {
            return null;
        }
        int p = url.indexOf("://");
        if (p != -1) {
            url = url.substring(p + 3);
        }
        if ((p = url.indexOf(64)) != -1) {
            String credentials = url.substring(0, p);
            if ((p = credentials.indexOf(58)) != -1) {
                result[0] = credentials.substring(0, p);
                result[1] = credentials.substring(p + 1);
            } else {
                result[0] = credentials;
            }
        } else {
            return null;
        }
        return result;
    }

    static String[] parseProxy(String url, String defPort) {
        String[] result = new String[2];
        if (url == null || url.isEmpty()) {
            return null;
        }
        int p = url.indexOf("://");
        if (p != -1) {
            url = url.substring(p + 3);
        }
        if ((p = url.indexOf(64)) != -1) {
            url = url.substring(p + 1);
        }
        if ((p = url.indexOf(58)) != -1) {
            result[0] = url.substring(0, p);
            result[1] = url.substring(p + 1);
        } else {
            result[0] = url;
            result[1] = defPort;
        }
        p = result[0].indexOf("/");
        if (p != -1) {
            result[0] = result[0].substring(0, p);
        }
        if ((p = result[1].indexOf("/")) != -1) {
            result[1] = result[1].substring(0, p);
        }
        return result;
    }

    public boolean isValid() {
        return this.count > 0;
    }

    private boolean isUpper(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected final boolean isLogging(int level) {
        return level <= this.logLevel;
    }

    protected final void log(int level, String str) {
        if (this.isLogging(level)) {
            System.err.println("CAPSULE: " + str);
        }
    }

    protected void checkValidProtocol(String protocol) {
        if ("http".equalsIgnoreCase(protocol)) {
            return;
        }
        if ("https".equalsIgnoreCase(protocol)) {
            return;
        }
        throw new IllegalArgumentException(String.format("Illegal proxy protocol: '%s'", protocol));
    }
}

